/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.obrplugin;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.obrplugin.Config;
import org.apache.felix.obrplugin.ObrUpdate;
import org.apache.felix.obrplugin.ObrUtils;
import org.apache.felix.obrplugin.RemoteFileManager;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;

public final class ObrDeploy
extends AbstractMojo {
    private boolean ignoreLock;
    private String prefixUrl;
    private String bundleUrl;
    private String remoteOBR;
    private String obrRepository;
    private List supportedProjectTypes = Arrays.asList("jar", "bundle");
    private ArtifactRepository deploymentRepository;
    private String altDeploymentRepository;
    private String obrDeploymentRepository;
    private ArtifactRepository localRepository;
    private MavenProject project;
    private List attachedArtifacts;
    private Settings settings;
    private WagonManager m_wagonManager;
    private Artifact m_sourceArtifact;
    private Artifact m_docArtifact;
    private static final Pattern ALT_REPO_SYNTAX_PATTERN = Pattern.compile("(.+)::(.+)::(.+)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        String projectType = this.project.getPackaging();
        if (!this.supportedProjectTypes.contains(projectType)) {
            this.getLog().warn((CharSequence)("Ignoring project type " + projectType + " - supportedProjectTypes = " + this.supportedProjectTypes));
            return;
        }
        if ("NONE".equalsIgnoreCase(this.remoteOBR) || "false".equalsIgnoreCase(this.remoteOBR)) {
            this.getLog().info((CharSequence)"Remote OBR update disabled (enable with -DremoteOBR)");
            return;
        }
        for (Artifact artifact : this.attachedArtifacts) {
            if ("sources".equals(artifact.getClassifier())) {
                this.m_sourceArtifact = artifact;
                continue;
            }
            if (!"javadoc".equals(artifact.getClassifier())) continue;
            this.m_docArtifact = artifact;
        }
        if (null == this.remoteOBR || this.remoteOBR.trim().length() == 0 || "true".equalsIgnoreCase(this.remoteOBR)) {
            this.remoteOBR = this.obrRepository;
        }
        URI tempURI = ObrUtils.findRepositoryXml("", this.remoteOBR);
        String repositoryName = new File(tempURI.getSchemeSpecificPart()).getName();
        Log log = this.getLog();
        RemoteFileManager remoteFile = new RemoteFileManager(this.m_wagonManager, this.settings, log);
        this.openRepositoryConnection(remoteFile);
        log.info((CharSequence)("LOCK " + remoteFile + '/' + repositoryName));
        remoteFile.lockFile(repositoryName, this.ignoreLock);
        File downloadedRepositoryXml = null;
        try {
            log.info((CharSequence)("Downloading " + repositoryName));
            downloadedRepositoryXml = remoteFile.get(repositoryName, ".xml");
            String mavenRepository = this.localRepository.getBasedir();
            URI repositoryXml = downloadedRepositoryXml.toURI();
            URI obrXmlFile = ObrUtils.findObrXml(this.project.getResources());
            Config userConfig = new Config();
            userConfig.setRemoteFile(true);
            if (this.bundleUrl != null) {
                userConfig.setRemoteBundle(URI.create(this.bundleUrl));
            } else if (this.prefixUrl != null) {
                URI bundleJar = ObrUtils.getArtifactURI(this.localRepository, this.project.getArtifact());
                String relative = ObrUtils.getRelativeURI(ObrUtils.toFileURI(mavenRepository), bundleJar).toASCIIString();
                URL resourceURL = new URL(new URL(this.prefixUrl + '/'), relative);
                userConfig.setRemoteBundle(URI.create(resourceURL.toString()));
            }
            ObrUpdate update = new ObrUpdate(repositoryXml, obrXmlFile, this.project, mavenRepository, userConfig, log);
            update.parseRepositoryXml();
            this.updateRemoteBundleMetadata(this.project.getArtifact(), update);
            Iterator i = this.attachedArtifacts.iterator();
            while (i.hasNext()) {
                this.updateRemoteBundleMetadata((Artifact)i.next(), update);
            }
            update.writeRepositoryXml();
            if (downloadedRepositoryXml.exists()) {
                log.info((CharSequence)("Uploading " + repositoryName));
                remoteFile.put(downloadedRepositoryXml, repositoryName);
            }
        }
        catch (Exception e) {
            log.warn((CharSequence)("Exception while updating remote OBR: " + e.getLocalizedMessage()), (Throwable)e);
        }
        finally {
            log.info((CharSequence)("UNLOCK " + remoteFile + '/' + repositoryName));
            remoteFile.unlockFile(repositoryName);
            remoteFile.disconnect();
            if (null != downloadedRepositoryXml) {
                downloadedRepositoryXml.delete();
            }
        }
    }

    private void openRepositoryConnection(RemoteFileManager remoteFile) throws MojoExecutionException {
        if (this.obrDeploymentRepository != null) {
            this.altDeploymentRepository = this.obrDeploymentRepository;
        }
        if (this.deploymentRepository == null && this.altDeploymentRepository == null) {
            String msg = "Deployment failed: repository element was not specified in the pom inside distributionManagement element or in -DaltDeploymentRepository=id::layout::url parameter";
            throw new MojoExecutionException(msg);
        }
        if (this.altDeploymentRepository != null) {
            this.getLog().info((CharSequence)("Using alternate deployment repository " + this.altDeploymentRepository));
            Matcher matcher = ALT_REPO_SYNTAX_PATTERN.matcher(this.altDeploymentRepository);
            if (!matcher.matches()) {
                throw new MojoExecutionException("Invalid syntax for alternative repository \"" + this.altDeploymentRepository + "\". Use \"id::layout::url\".");
            }
            remoteFile.connect(matcher.group(1).trim(), matcher.group(3).trim());
        } else {
            remoteFile.connect(this.deploymentRepository.getId(), this.deploymentRepository.getUrl());
        }
    }

    private void updateRemoteBundleMetadata(Artifact artifact, ObrUpdate update) throws MojoExecutionException {
        if (!this.supportedProjectTypes.contains(artifact.getType())) {
            return;
        }
        if (null == artifact.getFile() || artifact.getFile().isDirectory()) {
            this.getLog().error((CharSequence)"No artifact found, try \"mvn install bundle:deploy\"");
            return;
        }
        URI bundleJar = ObrUtils.getArtifactURI(this.localRepository, artifact);
        URI sourceJar = null;
        if (null != this.m_sourceArtifact) {
            sourceJar = ObrUtils.getArtifactURI(this.localRepository, this.m_sourceArtifact);
        }
        URI docJar = null;
        if (null != this.m_docArtifact) {
            docJar = ObrUtils.getArtifactURI(this.localRepository, this.m_docArtifact);
        }
        update.updateRepository(bundleJar, sourceJar, docJar);
    }
}

