/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.obrplugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.felix.obrplugin.Capability;
import org.apache.felix.obrplugin.Category;
import org.apache.felix.obrplugin.PElement;
import org.apache.felix.obrplugin.Require;
import org.apache.maven.plugin.MojoExecutionException;
import org.osgi.impl.bundle.obr.resource.BundleInfo;
import org.osgi.impl.bundle.obr.resource.CapabilityImpl;
import org.osgi.impl.bundle.obr.resource.RepositoryImpl;
import org.osgi.impl.bundle.obr.resource.RequirementImpl;
import org.osgi.impl.bundle.obr.resource.ResourceImpl;
import org.osgi.impl.bundle.obr.resource.VersionRange;

public class ExtractBindexInfo {
    private ResourceImpl m_resource = null;

    public ExtractBindexInfo(URI repoFilename, String outFile) throws MojoExecutionException {
        RepositoryImpl repository = null;
        try {
            repository = new RepositoryImpl(new File(repoFilename).getAbsoluteFile().toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new MojoExecutionException("MalformedURLException");
        }
        BundleInfo info = null;
        try {
            info = new BundleInfo(repository, new File(outFile));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException("Exception");
        }
        try {
            this.m_resource = info.build();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException("Exception");
        }
    }

    public List getCapabilities() {
        ArrayList<Capability> list = new ArrayList<Capability>();
        Collection res = this.m_resource.getCapabilityList();
        Iterator it = res.iterator();
        while (it.hasNext()) {
            Capability capability = new Capability();
            CapabilityImpl ci = (CapabilityImpl)it.next();
            capability.setName(ci.getName());
            if (ci.getName().compareTo("bundle") == 0) continue;
            Map properties = ci.getProperties();
            Iterator e = properties.entrySet().iterator();
            while (e.hasNext()) {
                PElement p = new PElement();
                Map.Entry entry = e.next();
                String key = (String)entry.getKey();
                List values = (List)entry.getValue();
                for (Object value : values) {
                    p.setN(key);
                    if (value != null) {
                        p.setV(value.toString());
                    } else {
                        System.out.println("Missing value " + key);
                    }
                    String type = null;
                    if (value instanceof Number) {
                        type = "number";
                    } else if (value instanceof VersionRange) {
                        type = "version";
                    }
                    if (type == null) continue;
                    p.setT(type);
                }
                capability.addP(p);
            }
            list.add(capability);
        }
        return list;
    }

    public List getRequirement() {
        ArrayList<Require> list = new ArrayList<Require>();
        Collection res = this.m_resource.getRequirementList();
        for (RequirementImpl ci : res) {
            Require require = new Require();
            require.setExtend(String.valueOf(ci.isExtend()));
            require.setMultiple(String.valueOf(ci.isMultiple()));
            require.setOptional(String.valueOf(ci.isOptional()));
            require.setName(ci.getName());
            require.setFilter(ci.getFilter());
            require.setValue(ci.getComment());
            list.add(require);
        }
        return list;
    }

    public List getCategories() {
        ArrayList<Category> list = new ArrayList<Category>();
        String[] res = this.m_resource.getCategories();
        for (int i = 0; i < res.length; ++i) {
            Category category = new Category();
            category.setId(res[i]);
            list.add(category);
        }
        return list;
    }

    public String getSymbolicName() {
        return this.m_resource.getSymbolicName();
    }

    public String getVersion() {
        if (this.m_resource.getVersion() != null) {
            return this.m_resource.getVersion().toString();
        }
        return null;
    }

    public String getPresentationName() {
        return this.m_resource.getPresentationName();
    }

    public String getCopyright() {
        return this.m_resource.getCopyright();
    }

    public String getDescription() {
        return this.m_resource.getDescription();
    }

    public String getDocumentation() {
        if (this.m_resource.getDocumentation() != null) {
            return this.m_resource.getDocumentation().toString();
        }
        return null;
    }

    public String getLicense() {
        if (this.m_resource.getLicense() != null) {
            return this.m_resource.getLicense().toString();
        }
        return null;
    }

    public String getSource() {
        if (this.m_resource.getSource() != null) {
            return this.m_resource.getSource().toString();
        }
        return null;
    }

    public String getId() {
        if (this.m_resource.getId() != null) {
            return this.m_resource.getId();
        }
        return null;
    }
}

