/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.felix.scrplugin.Constants;
import org.apache.felix.scrplugin.om.Component;
import org.apache.felix.scrplugin.om.Components;
import org.apache.felix.scrplugin.om.Implementation;
import org.apache.felix.scrplugin.om.Interface;
import org.apache.felix.scrplugin.om.Property;
import org.apache.felix.scrplugin.om.Reference;
import org.apache.felix.scrplugin.om.Service;
import org.apache.felix.scrplugin.om.metatype.AttributeDefinition;
import org.apache.felix.scrplugin.om.metatype.Designate;
import org.apache.felix.scrplugin.om.metatype.MTObject;
import org.apache.felix.scrplugin.om.metatype.MetaData;
import org.apache.felix.scrplugin.om.metatype.OCD;
import org.apache.felix.scrplugin.tags.JavaClassDescription;
import org.apache.felix.scrplugin.tags.JavaClassDescriptorManager;
import org.apache.felix.scrplugin.tags.JavaField;
import org.apache.felix.scrplugin.tags.JavaTag;
import org.apache.felix.scrplugin.xml.ComponentDescriptorIO;
import org.apache.felix.scrplugin.xml.MetaTypeIO;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

public class SCRDescriptorMojo
extends AbstractMojo {
    private File outputDirectory;
    private MavenProject project;
    private String finalName;
    private String metaTypeName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)"Starting SCRDescriptorMojo....");
        boolean hasFailures = false;
        JavaClassDescriptorManager jManager = new JavaClassDescriptorManager(this.getLog(), this.project);
        JavaClassDescription[] javaSources = jManager.getSourceDescriptions();
        Components components = new Components();
        Components abstractComponents = new Components();
        MetaData metaData = new MetaData();
        metaData.setLocalization("metatype");
        for (int i = 0; i < javaSources.length; ++i) {
            this.getLog().debug((CharSequence)("Testing source " + javaSources[i].getName()));
            JavaTag tag = javaSources[i].getTagByName("scr.component");
            if (tag == null) continue;
            this.getLog().debug((CharSequence)("Processing service class " + javaSources[i].getName()));
            Component comp = this.createComponent(javaSources[i], metaData);
            if (comp != null) {
                if (comp.isAbstract()) {
                    this.getLog().debug((CharSequence)("Adding abstract descriptor " + comp));
                    abstractComponents.addComponent(comp);
                    continue;
                }
                this.getLog().debug((CharSequence)("Adding descriptor " + comp));
                components.addComponent(comp);
                continue;
            }
            hasFailures = true;
        }
        if (hasFailures) {
            throw new MojoFailureException("SCR Descriptor parsing had failures (see log)");
        }
        File adFile = new File(this.outputDirectory, Constants.ABSTRACT_DESCRIPTOR_RELATIVE_PATH);
        if (!abstractComponents.getComponents().isEmpty()) {
            this.getLog().info((CharSequence)("Writing abstract service descriptor " + adFile + " with " + components.getComponents().size() + " entries."));
            adFile.getParentFile().mkdirs();
            ComponentDescriptorIO.write(abstractComponents, adFile);
        } else {
            this.getLog().debug((CharSequence)"No abstract SCR Descriptors found in project.");
            if (adFile.exists()) {
                this.getLog().debug((CharSequence)("Removing obsolete abstract service descriptor " + adFile));
                adFile.delete();
            }
        }
        if (components.getComponents().isEmpty()) {
            this.getLog().debug((CharSequence)"No SCR Descriptors found in project.");
            return;
        }
        if (StringUtils.isEmpty((String)this.finalName)) {
            this.getLog().error((CharSequence)"Descriptor file name must not be empty.");
            return;
        }
        File descriptorFile = new File(new File(this.outputDirectory, "OSGI-INF"), this.finalName);
        descriptorFile.getParentFile().mkdirs();
        this.getLog().info((CharSequence)("Generating " + components.getComponents().size() + " Service Component Descriptors to " + descriptorFile));
        ComponentDescriptorIO.write(components, descriptorFile);
        if (StringUtils.isEmpty((String)this.metaTypeName)) {
            this.getLog().error((CharSequence)"Meta type file name must not be empty.");
            return;
        }
        File mtFile = new File(this.outputDirectory, "OSGI-INF" + File.separator + "metatype" + File.separator + this.metaTypeName);
        mtFile.getParentFile().mkdirs();
        if (metaData.getDescriptors().size() > 0) {
            MetaTypeIO.write(metaData, mtFile);
        } else if (mtFile.exists()) {
            mtFile.delete();
        }
        String ourRsrcPath = this.outputDirectory.getAbsolutePath();
        boolean found = false;
        Iterator rsrcIterator = this.project.getResources().iterator();
        while (!found && rsrcIterator.hasNext()) {
            Resource rsrc = (Resource)rsrcIterator.next();
            found = rsrc.getDirectory().equals(ourRsrcPath);
        }
        if (!found) {
            Resource resource = new Resource();
            resource.setDirectory(this.outputDirectory.getAbsolutePath());
            this.project.addResource(resource);
        }
        this.project.getProperties().setProperty("Service-Component", "OSGI-INF/" + this.finalName);
    }

    protected Component createComponent(JavaClassDescription description, MetaData metaData) throws MojoExecutionException {
        JavaTag[] references;
        JavaTag componentTag = description.getTagByName("scr.component");
        Component component = new Component(componentTag);
        component.setImplementation(new Implementation(description.getName()));
        OCD ocd = this.doComponent(componentTag, component, metaData);
        boolean inherited = this.getBoolean(componentTag, "inherit", false);
        boolean serviceFactory = this.doServices(description.getTagsByName("scr.service", inherited), component, description);
        component.setServiceFactory(serviceFactory);
        JavaTag[] properties = description.getTagsByName("scr.property", inherited);
        if (properties != null && properties.length > 0) {
            for (int i = 0; i < properties.length; ++i) {
                this.doProperty(properties[i], null, component, ocd);
            }
        }
        if ((references = description.getTagsByName("scr.reference", inherited)) != null || references.length > 0) {
            for (int i = 0; i < references.length; ++i) {
                this.doReference(references[i], null, component);
            }
        }
        do {
            JavaField[] fields = description.getFields();
            for (int i = 0; fields != null && i < fields.length; ++i) {
                JavaTag tag = fields[i].getTagByName("scr.reference");
                if (tag != null) {
                    this.doReference(tag, fields[i].getName(), component);
                }
                if ((tag = fields[i].getTagByName("scr.property")) == null) continue;
                this.doProperty(tag, fields[i].getInitializationExpression(), component, ocd);
            }
            description = description.getSuperClass();
        } while (inherited && description != null);
        ArrayList issues = new ArrayList();
        ArrayList warnings = new ArrayList();
        component.validate(issues, warnings);
        Iterator i = warnings.iterator();
        while (i.hasNext()) {
            this.getLog().warn((CharSequence)((String)i.next()));
        }
        i = issues.iterator();
        while (i.hasNext()) {
            this.getLog().error((CharSequence)((String)i.next()));
        }
        return issues.size() == 0 ? component : null;
    }

    protected OCD doComponent(JavaTag tag, Component component, MetaData metaData) {
        boolean hasMetaType;
        String abstractType = tag.getNamedParameter("abstract");
        component.setAbstract(abstractType == null ? false : "yes".equalsIgnoreCase(abstractType) || "true".equalsIgnoreCase(abstractType));
        String name = tag.getNamedParameter("name");
        component.setName(StringUtils.isEmpty((String)name) ? component.getImplementation().getClassame() : name);
        component.setEnabled(this.getBoolean(tag, "enabled", true));
        component.setFactory(tag.getNamedParameter("factory"));
        component.setImmediate(this.getBoolean(tag, "immediate", true));
        String metaType = tag.getNamedParameter("metatype");
        boolean bl = hasMetaType = metaType == null || "yes".equalsIgnoreCase(metaType) || "true".equalsIgnoreCase(metaType);
        if (hasMetaType) {
            OCD ocd = new OCD();
            metaData.addOCD(ocd);
            ocd.setId(component.getName());
            String ocdName = tag.getNamedParameter("label");
            if (ocdName == null) {
                ocdName = "%" + component.getName() + ".name";
            }
            ocd.setName(ocdName);
            String ocdDescription = tag.getNamedParameter("description");
            if (ocdDescription == null) {
                ocdDescription = "%" + component.getName() + ".description";
            }
            ocd.setDescription(ocdDescription);
            Designate designate = new Designate();
            metaData.addDesignate(designate);
            designate.setPid(component.getName());
            MTObject mtobject = new MTObject();
            designate.setObject(mtobject);
            mtobject.setOcdref(component.getName());
            return ocd;
        }
        return null;
    }

    protected boolean doServices(JavaTag[] services, Component component, JavaClassDescription description) throws MojoExecutionException {
        if (services == null || services.length == 0) {
            return false;
        }
        Service service = new Service();
        component.setService(service);
        boolean serviceFactory = false;
        for (int i = 0; i < services.length; ++i) {
            String name = services[i].getNamedParameter("interface");
            if (StringUtils.isEmpty((String)name)) {
                while (description != null) {
                    JavaClassDescription[] interfaces = description.getImplementedInterfaces();
                    for (int j = 0; interfaces != null && j < interfaces.length; ++j) {
                        Interface interf = new Interface(services[i]);
                        interf.setInterfacename(interfaces[j].getName());
                        service.addInterface(interf);
                    }
                    description = description.getSuperClass();
                }
            } else {
                Interface interf = new Interface(services[i]);
                interf.setInterfacename(name);
                service.addInterface(interf);
            }
            serviceFactory |= this.getBoolean(services[i], "servicefactory", false);
        }
        return serviceFactory;
    }

    protected void doProperty(JavaTag property, String defaultName, Component component, OCD ocd) {
        String name = property.getNamedParameter("name");
        if (StringUtils.isEmpty((String)name) && defaultName != null) {
            name = defaultName.trim();
            if (name.startsWith("\"")) {
                name = name.substring(1);
            }
            if (name.endsWith("\"")) {
                name = name.substring(0, name.length() - 1);
            }
        }
        if (!StringUtils.isEmpty((String)name)) {
            Property prop = new Property(property);
            prop.setName(name);
            prop.setType(property.getNamedParameter("type"));
            String value = property.getNamedParameter("value");
            if (value != null) {
                prop.setValue(value);
            } else {
                ArrayList values = new ArrayList();
                Map valueMap = property.getNamedParameterMap();
                Iterator vi = valueMap.entrySet().iterator();
                while (vi.hasNext()) {
                    Map.Entry entry = vi.next();
                    String key = (String)entry.getKey();
                    if (!key.startsWith("values")) continue;
                    values.add(entry.getValue());
                }
                if (values.size() > 0) {
                    prop.setMultiValue(values.toArray(new String[values.size()]));
                }
            }
            boolean isPrivate = this.getBoolean(property, "private", false);
            if (!isPrivate && ocd != null) {
                AttributeDefinition ad = new AttributeDefinition();
                ocd.getProperties().add(ad);
                ad.setId(prop.getName());
                ad.setType(prop.getType());
                String adName = property.getNamedParameter("label");
                if (adName == null) {
                    adName = "%" + prop.getName() + ".name";
                }
                ad.setName(adName);
                String adDesc = property.getNamedParameter("description");
                if (adDesc == null) {
                    adDesc = "%" + prop.getName() + ".description";
                }
                ad.setDescription(adDesc);
                String cValue = property.getNamedParameter("cardinality");
                if (cValue != null) {
                    if ("-".equals(cValue)) {
                        ad.setCardinality(new Integer(Integer.MIN_VALUE));
                    } else if ("+".equals(cValue)) {
                        ad.setCardinality(new Integer(Integer.MAX_VALUE));
                    } else {
                        try {
                            ad.setCardinality(Integer.valueOf(cValue));
                        }
                        catch (NumberFormatException nfe) {
                            // empty catch block
                        }
                    }
                }
                ad.setDefaultValue(prop.getValue());
                ad.setDefaultMultiValue(prop.getMultiValue());
                String[] parameters = property.getParameters();
                LinkedHashMap<String, String> options = null;
                for (int j = 0; j < parameters.length; ++j) {
                    String optionValue;
                    if ("options".equals(parameters[j])) {
                        options = new LinkedHashMap<String, String>();
                        continue;
                    }
                    if (options == null) continue;
                    String optionLabel = parameters[j];
                    String string = optionValue = j < parameters.length - 2 ? parameters[j + 2] : null;
                    if (optionValue != null) {
                        options.put(optionLabel, optionValue);
                    }
                    j += 2;
                }
                ad.setOptions(options);
            }
            component.addProperty(prop);
        }
    }

    protected void doReference(JavaTag reference, String defaultName, Component component) {
        String type;
        String name = reference.getNamedParameter("name");
        if (StringUtils.isEmpty((String)name)) {
            name = defaultName;
        }
        if (StringUtils.isEmpty((String)(type = reference.getNamedParameter("interface"))) && reference.getField() != null) {
            type = reference.getField().getType();
        }
        if (!StringUtils.isEmpty((String)name)) {
            Reference ref = new Reference(reference);
            ref.setName(name);
            ref.setInterfacename(type);
            ref.setCardinality(reference.getNamedParameter("cardinality"));
            ref.setPolicy(reference.getNamedParameter("policy"));
            ref.setTarget(reference.getNamedParameter("target"));
            String value = reference.getNamedParameter("bind");
            if (value != null) {
                ref.setBind(value);
            }
            if ((value = reference.getNamedParameter("unbind")) != null) {
                ref.setUnbind(value);
            }
            component.addReference(ref);
        }
    }

    protected boolean getBoolean(JavaTag tag, String name, boolean defaultValue) {
        String value = tag.getNamedParameter(name);
        return value == null ? defaultValue : Boolean.valueOf(value);
    }
}

