/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.tags.qdox;

import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.Type;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.felix.scrplugin.tags.JavaClassDescription;
import org.apache.felix.scrplugin.tags.JavaClassDescriptorManager;
import org.apache.felix.scrplugin.tags.JavaField;
import org.apache.felix.scrplugin.tags.JavaMethod;
import org.apache.felix.scrplugin.tags.JavaTag;
import org.apache.felix.scrplugin.tags.ModifiableJavaClassDescription;
import org.apache.felix.scrplugin.tags.qdox.QDoxJavaField;
import org.apache.felix.scrplugin.tags.qdox.QDoxJavaMethod;
import org.apache.felix.scrplugin.tags.qdox.QDoxJavaTag;
import org.apache.maven.plugin.MojoExecutionException;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.ClassNode;

public class QDoxJavaClassDescription
implements JavaClassDescription,
ModifiableJavaClassDescription {
    protected final JavaClass javaClass;
    protected final JavaClassDescriptorManager manager;
    protected final JavaSource source;

    public QDoxJavaClassDescription(JavaSource source, JavaClassDescriptorManager m) {
        this.javaClass = source.getClasses()[0];
        this.manager = m;
        this.source = source;
    }

    public JavaClassDescription getSuperClass() throws MojoExecutionException {
        JavaClass parent = this.javaClass.getSuperJavaClass();
        if (parent != null) {
            return this.manager.getJavaClassDescription(parent.getFullyQualifiedName());
        }
        return null;
    }

    public JavaTag getTagByName(String name) {
        DocletTag tag = this.javaClass.getTagByName(name);
        if (tag == null) {
            return null;
        }
        return new QDoxJavaTag(tag, this);
    }

    public String getName() {
        return this.javaClass.getFullyQualifiedName();
    }

    public JavaTag[] getTagsByName(String name, boolean inherited) throws MojoExecutionException {
        JavaTag[] superTags;
        JavaTag[] javaTags;
        DocletTag[] tags = this.javaClass.getTagsByName(name, false);
        if (tags == null || tags.length == 0) {
            javaTags = new JavaTag[]{};
        } else {
            javaTags = new JavaTag[tags.length];
            for (int i = 0; i < tags.length; ++i) {
                javaTags[i] = new QDoxJavaTag(tags[i], this);
            }
        }
        if (inherited && this.getSuperClass() != null && (superTags = this.getSuperClass().getTagsByName(name, inherited)).length > 0) {
            ArrayList<JavaTag> list = new ArrayList<JavaTag>(Arrays.asList(javaTags));
            list.addAll(Arrays.asList(superTags));
            javaTags = list.toArray(new JavaTag[list.size()]);
        }
        return javaTags;
    }

    public JavaField[] getFields() {
        com.thoughtworks.qdox.model.JavaField[] fields = this.javaClass.getFields();
        if (fields == null || fields.length == 0) {
            return new JavaField[0];
        }
        JavaField[] f = new JavaField[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            f[i] = new QDoxJavaField(fields[i], this);
        }
        return f;
    }

    public JavaClassDescription[] getImplementedInterfaces() throws MojoExecutionException {
        JavaClass[] interfaces = this.javaClass.getImplementedInterfaces();
        if (interfaces == null || interfaces.length == 0) {
            return JavaClassDescription.EMPTY_RESULT;
        }
        JavaClassDescription[] descs = new JavaClassDescription[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            descs[i] = this.manager.getJavaClassDescription(interfaces[i].getFullyQualifiedName());
        }
        return descs;
    }

    public JavaMethod getMethodBySignature(String name, String[] parameters) throws MojoExecutionException {
        Type[] types = null;
        if (parameters == null || parameters.length == 0) {
            types = new Type[]{};
        } else {
            types = new Type[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                types[i] = new Type(parameters[i]);
            }
        }
        com.thoughtworks.qdox.model.JavaMethod m = this.javaClass.getMethodBySignature(name, types);
        if (m == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getMethodBySignature(name, parameters);
            }
            return null;
        }
        return new QDoxJavaMethod(m);
    }

    public JavaMethod[] getMethods() {
        com.thoughtworks.qdox.model.JavaMethod[] methods = this.javaClass.getMethods();
        if (methods == null || methods.length == 0) {
            return JavaMethod.EMPTY_RESULT;
        }
        JavaMethod[] m = new JavaMethod[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            m[i] = new QDoxJavaMethod(methods[i]);
        }
        return m;
    }

    public boolean isA(String type) throws MojoExecutionException {
        Type qType = new Type(type);
        if (this.javaClass.isA(type)) {
            return true;
        }
        Type[] interfaces = this.javaClass.getImplements();
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                if (!interfaces[i].isA(qType)) continue;
                return true;
            }
        }
        if (this.getSuperClass() != null) {
            return this.getSuperClass().isA(type);
        }
        return false;
    }

    public boolean isAbstract() {
        return this.javaClass.isAbstract();
    }

    public boolean isInterface() {
        return this.javaClass.isInterface();
    }

    public boolean isPublic() {
        return this.javaClass.isPublic();
    }

    public void addMethods(final String propertyName, final String className, final boolean createBind, final boolean createUnbind) throws MojoExecutionException {
        String targetDirectory = this.manager.getProject().getBuild().getOutputDirectory();
        String fileName = targetDirectory + File.separatorChar + this.getName().replace('.', File.separatorChar) + ".class";
        ClassNode cn = new ClassNode();
        try {
            ClassReader reader = new ClassReader((InputStream)new FileInputStream(fileName));
            reader.accept((ClassVisitor)cn, 0);
            ClassWriter writer = new ClassWriter(0);
            ClassAdapter adapter = new ClassAdapter((ClassVisitor)writer){
                protected final String bindMethodName;
                protected final String unbindMethodName;
                protected final String description;
                {
                    this.bindMethodName = "bind" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
                    this.unbindMethodName = "unbind" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
                    this.description = "(L" + className.replace('.', '/') + ";)V";
                }

                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    if (createBind && name.equals(this.bindMethodName) && this.description.equals(desc)) {
                        return null;
                    }
                    if (createUnbind && name.equals(this.unbindMethodName) && this.description.equals(desc)) {
                        return null;
                    }
                    return super.visitMethod(access, name, desc, signature, exceptions);
                }
            };
            cn.accept((ClassVisitor)adapter);
            if (createBind) {
                this.createMethod(writer, propertyName, className, true);
            }
            if (createUnbind) {
                this.createMethod(writer, propertyName, className, false);
            }
            FileOutputStream fos = new FileOutputStream(fileName);
            fos.write(writer.toByteArray());
            fos.close();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to add methods to " + this.getName(), e);
        }
    }

    protected void createMethod(ClassWriter cw, String propertyName, String typeName, boolean bind) {
        org.objectweb.asm.Type type = org.objectweb.asm.Type.getType((String)("L" + typeName.replace('.', '/') + ";"));
        String methodName = (bind ? "" : "un") + "bind" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        MethodVisitor mv = cw.visitMethod(4, methodName, "(" + type.toString() + ")V", null, null);
        mv.visitVarInsn(25, 0);
        if (bind) {
            mv.visitVarInsn(type.getOpcode(21), 1);
            mv.visitFieldInsn(181, this.getName().replace('.', '/'), propertyName, type.toString());
        } else {
            mv.visitFieldInsn(180, this.getName().replace('.', '/'), propertyName, type.toString());
            mv.visitVarInsn(25, 1);
            Label jmpLabel = new Label();
            mv.visitJumpInsn(166, jmpLabel);
            mv.visitVarInsn(25, 0);
            mv.visitInsn(1);
            mv.visitFieldInsn(181, this.getName().replace('.', '/'), propertyName, type.toString());
            mv.visitLabel(jmpLabel);
        }
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        JavaParameter param = new JavaParameter(new Type(typeName), "param");
        JavaParameter[] params = new JavaParameter[]{param};
        com.thoughtworks.qdox.model.JavaMethod meth = new com.thoughtworks.qdox.model.JavaMethod();
        meth.setName(methodName);
        meth.setParameters(params);
        meth.setModifiers(new String[]{"protected"});
        this.javaClass.addMethod(meth);
    }
}

