/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.om;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.scrplugin.om.AbstractObject;
import org.apache.felix.scrplugin.om.Implementation;
import org.apache.felix.scrplugin.om.Property;
import org.apache.felix.scrplugin.om.Reference;
import org.apache.felix.scrplugin.om.Service;
import org.apache.felix.scrplugin.tags.JavaClassDescription;
import org.apache.felix.scrplugin.tags.JavaMethod;
import org.apache.felix.scrplugin.tags.JavaTag;
import org.apache.maven.plugin.MojoExecutionException;

public class Component
extends AbstractObject {
    protected String name;
    protected Boolean enabled;
    protected Boolean immediate;
    protected String factory;
    protected Implementation implementation;
    protected List properties = new ArrayList();
    protected Service service;
    protected List references = new ArrayList();
    protected boolean isAbstract;
    protected boolean isDs;

    public Component() {
        this(null);
    }

    public Component(JavaTag t) {
        super(t);
    }

    public JavaClassDescription getJavaClassDescription() {
        if (this.tag != null) {
            return this.tag.getJavaClassDescription();
        }
        return null;
    }

    public List getProperties() {
        return this.properties;
    }

    public void setProperties(List properties) {
        this.properties = properties;
    }

    public void addProperty(Property property) {
        this.properties.add(property);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFactory() {
        return this.factory;
    }

    public void setFactory(String factory) {
        this.factory = factory;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean isImmediate() {
        return this.immediate;
    }

    public void setImmediate(Boolean immediate) {
        this.immediate = immediate;
    }

    public Implementation getImplementation() {
        return this.implementation;
    }

    public void setImplementation(Implementation implementation) {
        this.implementation = implementation;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public List getReferences() {
        return this.references;
    }

    public void setReferences(List references) {
        this.references = references;
    }

    public void addReference(Reference ref) {
        this.references.add(ref);
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public boolean isDs() {
        return this.isDs;
    }

    public void setDs(boolean isDs) {
        this.isDs = isDs;
    }

    public void validate(List issues, List warnings) throws MojoExecutionException {
        if (!this.isDs()) {
            return;
        }
        JavaClassDescription javaClass = this.tag.getJavaClassDescription();
        if (javaClass == null) {
            issues.add(this.getMessage("Tag not declared in a Java Class"));
        } else if (!this.isAbstract) {
            if (!javaClass.isPublic()) {
                issues.add(this.getMessage("Class must be public: " + javaClass.getName()));
            }
            if (javaClass.isAbstract() || javaClass.isInterface()) {
                issues.add(this.getMessage("Class must be concrete class (not abstract or interface) : " + javaClass.getName()));
            }
            if (issues.size() == 0) {
                this.checkLifecycleMethod(javaClass, "activate", warnings);
                this.checkLifecycleMethod(javaClass, "deactivate", warnings);
                boolean constructorFound = true;
                JavaMethod[] methods = javaClass.getMethods();
                for (int i = 0; methods != null && i < methods.length; ++i) {
                    if (!methods[i].isConstructor()) continue;
                    if (methods[i].isPublic() && (methods[i].getParameters() == null || methods[i].getParameters().length == 0)) {
                        constructorFound = true;
                        break;
                    }
                    constructorFound = false;
                }
                if (!constructorFound) {
                    issues.add(this.getMessage("Class must have public default constructor: " + javaClass.getName()));
                }
                Iterator pi = this.getProperties().iterator();
                while (pi.hasNext()) {
                    Property prop = (Property)pi.next();
                    prop.validate(issues, warnings);
                }
                boolean isServiceFactory = false;
                if (this.getService() != null) {
                    if (this.getService().getInterfaces().size() == 0) {
                        issues.add(this.getMessage("Service interface information is missing for @scr.service tag"));
                    }
                    this.getService().validate(issues, warnings);
                    isServiceFactory = this.getService().isServicefactory();
                }
                if (isServiceFactory && this.isImmediate() != null && this.isImmediate().booleanValue() && this.getFactory() != null) {
                    issues.add(this.getMessage("Component must not be a ServiceFactory, if immediate and/or component factory: " + javaClass.getName()));
                }
                Iterator ri = this.getReferences().iterator();
                while (ri.hasNext()) {
                    Reference ref = (Reference)ri.next();
                    ref.validate(issues, warnings);
                }
            }
        }
    }

    protected void checkLifecycleMethod(JavaClassDescription javaClass, String methodName, List warnings) throws MojoExecutionException {
        block4: {
            block2: {
                JavaMethod method;
                block3: {
                    method = javaClass.getMethodBySignature(methodName, new String[]{"org.osgi.service.component.ComponentContext"});
                    if (method == null) break block2;
                    if (!method.isPublic()) break block3;
                    warnings.add(this.getMessage("Lifecycle method " + method.getName() + " should be declared protected"));
                    break block4;
                }
                if (method.isProtected()) break block4;
                warnings.add(this.getMessage("Lifecycle method " + method.getName() + " has wrong qualifier, public or protected required"));
                break block4;
            }
            JavaMethod[] methods = javaClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methodName.equals(methods[i].getName())) continue;
                if (methods[i].getParameters().length != 1) {
                    warnings.add(this.getMessage("Lifecycle method " + methods[i].getName() + " has wrong number of arguments"));
                    continue;
                }
                warnings.add(this.getMessage("Lifecycle method " + methods[i].getName() + " has wrong argument " + methods[i].getParameters()[0].getType()));
            }
        }
    }
}

