/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.mojo;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.scrplugin.Log;
import org.apache.felix.scrplugin.Source;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.Scanner;
import org.sonatype.plexus.build.incremental.BuildContext;

public class MavenProjectScanner {
    private final MavenProject project;
    private final String includeString;
    private final String excludeString;
    private final boolean scanClasses;
    private final Log log;
    private final BuildContext buildContext;

    public MavenProjectScanner(BuildContext buildContext, MavenProject project, String includeString, String excludeString, boolean scanClasses, Log log) {
        this.project = project;
        this.includeString = includeString;
        this.excludeString = excludeString;
        this.scanClasses = scanClasses;
        this.log = log;
        this.buildContext = buildContext;
    }

    public Collection<Source> getSources() {
        if (this.scanClasses) {
            ArrayList<Source> files = new ArrayList<Source>();
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(this.project.getBuild().getOutputDirectory());
            if (this.includeString != null) {
                scanner.setIncludes(this.includeString.split(","));
            } else {
                scanner.setIncludes(new String[]{"**/*.class"});
            }
            if (this.excludeString != null) {
                scanner.setExcludes(this.excludeString.split(","));
            }
            scanner.addDefaultExcludes();
            scanner.scan();
            for (final String fileName : scanner.getIncludedFiles()) {
                files.add(new Source(){

                    public File getFile() {
                        return new File(MavenProjectScanner.this.project.getBuild().getOutputDirectory(), fileName);
                    }

                    public String getClassName() {
                        String name = fileName.substring(0, fileName.length() - 6);
                        return name.replace(File.separatorChar, '/').replace('/', '.');
                    }
                });
            }
            return files;
        }
        return this.getSourcesForScanKind(ScanKind.ADDED_OR_UPDATED);
    }

    private Collection<Source> getSourcesForScanKind(ScanKind scanKind) throws AssertionError {
        ArrayList<Source> files = new ArrayList<Source>();
        Iterator i = this.project.getCompileSourceRoots().iterator();
        String[] includes = new String[]{"**/*.java"};
        if (this.includeString != null) {
            includes = this.includeString.split(",");
        }
        String[] excludes = this.excludeString != null ? this.excludeString.split(",") : null;
        while (i.hasNext()) {
            Scanner scanner;
            String tree = (String)i.next();
            final File directory = new File(tree);
            if (!directory.exists()) {
                this.log.warn("Source tree does not exist. Ignoring " + tree);
                continue;
            }
            this.log.debug("Scanning source tree " + tree);
            switch (scanKind) {
                case ADDED_OR_UPDATED: {
                    scanner = this.buildContext.newScanner(directory, false);
                    break;
                }
                case DELETED: {
                    scanner = this.buildContext.newDeleteScanner(directory);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unhandled ScanKind " + (Object)((Object)scanKind)));
                }
            }
            if (excludes != null && excludes.length > 0) {
                scanner.setExcludes(excludes);
            }
            scanner.addDefaultExcludes();
            scanner.setIncludes(includes);
            scanner.scan();
            for (final String fileName : scanner.getIncludedFiles()) {
                files.add(new Source(){

                    public File getFile() {
                        return new File(directory, fileName);
                    }

                    public String getClassName() {
                        String name = fileName.substring(0, fileName.length() - 5);
                        return name.replace(File.separatorChar, '/').replace('/', '.');
                    }
                });
            }
        }
        return files;
    }

    public Collection<Source> getDeletedSources() {
        return this.getSourcesForScanKind(ScanKind.DELETED);
    }

    public List<File> getDependencies() {
        ArrayList<File> dependencies = new ArrayList<File>();
        for (Artifact declared : this.project.getArtifacts()) {
            this.log.debug("Checking artifact " + declared);
            if (this.isJavaArtifact(declared)) {
                if ("compile".equals(declared.getScope()) || "runtime".equals(declared.getScope()) || "provided".equals(declared.getScope()) || "system".equals(declared.getScope())) {
                    this.log.debug("Resolving artifact " + declared);
                    if (declared.getFile() != null) {
                        dependencies.add(declared.getFile());
                        continue;
                    }
                    this.log.debug("Unable to resolve artifact " + declared);
                    continue;
                }
                this.log.debug("Artifact " + declared + " has not scope compile or runtime, but " + declared.getScope());
                continue;
            }
            this.log.debug("Artifact " + declared + " is not a java artifact, type is " + declared.getType());
        }
        return dependencies;
    }

    private boolean isJavaArtifact(Artifact artifact) {
        if ("jar".equals(artifact.getType())) {
            return true;
        }
        return "bundle".equals(artifact.getType());
    }

    private static enum ScanKind {
        ADDED_OR_UPDATED,
        DELETED;

    }
}

