/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.tags;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.felix.scrplugin.om.Component;
import org.apache.felix.scrplugin.om.Components;
import org.apache.felix.scrplugin.tags.ClassUtil;
import org.apache.felix.scrplugin.tags.JavaClassDescription;
import org.apache.felix.scrplugin.tags.annotation.AnnotationJavaClassDescription;
import org.apache.felix.scrplugin.tags.annotation.AnnotationTagProviderManager;
import org.apache.felix.scrplugin.tags.cl.ClassLoaderJavaClassDescription;
import org.apache.felix.scrplugin.tags.qdox.QDoxJavaClassDescription;
import org.apache.felix.scrplugin.xml.ComponentDescriptorIO;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class JavaClassDescriptorManager {
    protected static final String SERVICE_COMPONENT = "Service-Component";
    protected final JavaSource[] sources;
    protected final Log log;
    protected final ClassLoader classloader;
    protected final Map<String, JavaClassDescription> javaClassDescriptions = new HashMap<String, JavaClassDescription>();
    protected final Map<String, Component> componentDescriptions = new HashMap<String, Component>();
    protected final MavenProject project;
    protected final AnnotationTagProviderManager annotationTagProviderManager;
    protected final boolean parseJavadocs;
    protected final boolean processAnnotations;

    public JavaClassDescriptorManager(Log log, MavenProject project, String[] annotationTagProviders, String excludeString, boolean parseJavadocs, boolean processAnnotations) throws MojoFailureException, MojoExecutionException {
        this.processAnnotations = processAnnotations;
        this.parseJavadocs = parseJavadocs;
        this.log = log;
        this.project = project;
        this.annotationTagProviderManager = new AnnotationTagProviderManager(annotationTagProviders);
        ClassUtil.classLoader = this.classloader = this.getCompileClassLoader();
        this.log.debug((CharSequence)"Setting up QDox");
        JavaDocBuilder builder = new JavaDocBuilder();
        builder.getClassLibrary().addClassLoader(this.classloader);
        Iterator i = project.getCompileSourceRoots().iterator();
        if (excludeString != null) {
            String[] excludes = StringUtils.split((String)excludeString, (String)",");
            String[] includes = new String[]{"**/*.java"};
            while (i.hasNext()) {
                String tree = (String)i.next();
                this.log.debug((CharSequence)("Scanning source tree " + tree));
                File directory = new File(tree);
                DirectoryScanner scanner = new DirectoryScanner();
                scanner.setBasedir(directory);
                if (excludes != null && excludes.length > 0) {
                    scanner.setExcludes(excludes);
                }
                scanner.addDefaultExcludes();
                scanner.setIncludes(includes);
                scanner.scan();
                String[] files = scanner.getIncludedFiles();
                if (files == null) continue;
                for (int m = 0; m < files.length; ++m) {
                    this.log.debug((CharSequence)("Adding source file " + files[m]));
                    try {
                        builder.addSource(new File(directory, files[m]));
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        throw new MojoExecutionException("Unable to scan directory.", (Exception)e);
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Unable to scan directory.", (Exception)e);
                    }
                }
            }
        } else {
            while (i.hasNext()) {
                String tree = (String)i.next();
                this.log.debug((CharSequence)("Adding source tree " + tree));
                File directory = new File(tree);
                builder.addSourceTree(directory);
            }
        }
        this.sources = builder.getSources();
        ArrayList<Component> components = new ArrayList<Component>();
        Map resolved = project.getArtifactMap();
        Set artifacts = project.getDependencyArtifacts();
        for (Artifact declared : artifacts) {
            this.log.debug((CharSequence)("Checking artifact " + declared));
            if (this.isJavaArtifact(declared)) {
                if ("compile".equals(declared.getScope()) || "runtime".equals(declared.getScope()) || "provided".equals(declared.getScope())) {
                    this.log.debug((CharSequence)("Resolving artifact " + declared));
                    Artifact artifact = (Artifact)resolved.get(ArtifactUtils.versionlessKey((Artifact)declared));
                    if (artifact != null) {
                        this.log.debug((CharSequence)("Trying to get manifest from artifact " + artifact));
                        try {
                            Manifest manifest = this.getManifest(artifact);
                            if (manifest != null) {
                                if (manifest.getMainAttributes().getValue(SERVICE_COMPONENT) != null) {
                                    String serviceComponent = manifest.getMainAttributes().getValue(SERVICE_COMPONENT);
                                    this.log.debug((CharSequence)("Found Service-Component: " + serviceComponent + " in artifact " + artifact));
                                    StringTokenizer st = new StringTokenizer(serviceComponent, ",");
                                    while (st.hasMoreTokens()) {
                                        Components c;
                                        String entry = st.nextToken().trim();
                                        if (entry.length() <= 0 || (c = this.readServiceComponentDescriptor(artifact, entry)) == null) continue;
                                        components.addAll(c.getComponents());
                                    }
                                } else {
                                    this.log.debug((CharSequence)("Artifact has no service component entry in manifest " + artifact));
                                }
                            } else {
                                this.log.debug((CharSequence)("Unable to get manifest from artifact " + artifact));
                            }
                        }
                        catch (IOException ioe) {
                            throw new MojoExecutionException("Unable to get manifest from artifact " + artifact, (Exception)ioe);
                        }
                        this.log.debug((CharSequence)("Trying to get scrinfo from artifact " + artifact));
                        try {
                            File scrInfoFile = this.getFile(artifact, "OSGI-INF/scr-plugin/scrinfo.xml");
                            if (scrInfoFile != null) {
                                components.addAll(this.parseServiceComponentDescriptor(artifact, scrInfoFile).getComponents());
                                continue;
                            }
                            this.log.debug((CharSequence)("Artifact has no scrinfo file (it's optional): " + artifact));
                            continue;
                        }
                        catch (IOException ioe) {
                            throw new MojoExecutionException("Unable to get scrinfo from artifact " + artifact, (Exception)ioe);
                        }
                    }
                    this.log.debug((CharSequence)("Unable to resolve artifact " + declared));
                    continue;
                }
                this.log.debug((CharSequence)("Artifact " + declared + " has not scope compile or runtime, but " + declared.getScope()));
                continue;
            }
            this.log.debug((CharSequence)("Artifact " + declared + " is not a java artifact, type is " + declared.getType()));
        }
        for (Component component : components) {
            this.componentDescriptions.put(component.getImplementation().getClassame(), component);
        }
    }

    private boolean isJavaArtifact(Artifact artifact) {
        if ("jar".equals(artifact.getType())) {
            return true;
        }
        return "bundle".equals(artifact.getType());
    }

    public Log getLog() {
        return this.log;
    }

    public ClassLoader getClassLoader() {
        return this.classloader;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public AnnotationTagProviderManager getAnnotationTagProviderManager() {
        return this.annotationTagProviderManager;
    }

    protected Components readServiceComponentDescriptor(Artifact artifact, String entry) {
        this.log.debug((CharSequence)("Reading " + entry + " from " + artifact));
        try {
            File xml = this.getFile(artifact, entry);
            if (xml == null) {
                throw new MojoExecutionException("Artifact " + artifact + " does not contain declared service component descriptor " + entry);
            }
            return this.parseServiceComponentDescriptor(artifact, xml);
        }
        catch (IOException mee) {
            this.log.warn((CharSequence)("Unable to read SCR descriptor file from artifact " + artifact + " at " + entry));
            this.log.debug((CharSequence)("Exception occurred during reading: " + mee.getMessage()), (Throwable)mee);
        }
        catch (MojoExecutionException mee) {
            this.log.warn((CharSequence)("Unable to read SCR descriptor file from artifact " + artifact + " at " + entry));
            this.log.debug((CharSequence)("Exception occurred during reading: " + mee.getMessage()), (Throwable)mee);
        }
        return null;
    }

    protected Components parseServiceComponentDescriptor(Artifact artifact, File file) throws MojoExecutionException {
        this.log.debug((CharSequence)("Parsing " + file));
        Components list = ComponentDescriptorIO.read(file);
        return list;
    }

    protected URL getOutputDirectory() throws MojoFailureException {
        String targetDirectory = this.getProject().getBuild().getOutputDirectory();
        try {
            return new File(targetDirectory).toURI().toURL();
        }
        catch (IOException ioe) {
            throw new MojoFailureException("Unable to add target directory to classloader.");
        }
    }

    protected ClassLoader getCompileClassLoader() throws MojoFailureException {
        List artifacts = this.getProject().getCompileArtifacts();
        URL[] path = new URL[artifacts.size() + 1];
        int i = 0;
        for (Artifact a : artifacts) {
            try {
                path[i++] = a.getFile().toURI().toURL();
            }
            catch (IOException ioe) {
                throw new MojoFailureException("Unable to get compile class loader.");
            }
        }
        path[path.length - 1] = this.getOutputDirectory();
        return new URLClassLoader(path, this.getClass().getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Manifest getManifest(Artifact artifact) throws IOException {
        JarFile file = null;
        try {
            file = new JarFile(artifact.getFile());
            Manifest manifest = file.getManifest();
            return manifest;
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File getFile(Artifact artifact, String path) throws IOException {
        int pos = path.lastIndexOf(46);
        String suffix = path.substring(pos + 1);
        JarFile file = null;
        File tmpFile = null;
        try {
            file = new JarFile(artifact.getFile());
            JarEntry entry = file.getJarEntry(path);
            if (entry != null) {
                tmpFile = File.createTempFile("scrjcdm" + artifact.getArtifactId(), suffix);
                tmpFile.deleteOnExit();
                FileOutputStream fos = new FileOutputStream(tmpFile);
                IOUtil.copy((InputStream)file.getInputStream(entry), (OutputStream)fos);
                IOUtil.close((OutputStream)fos);
                File file2 = tmpFile;
                return file2;
            }
            File file3 = null;
            return file3;
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    public JavaClassDescription[] getSourceDescriptions() throws MojoExecutionException {
        JavaClassDescription[] descs = new JavaClassDescription[this.sources.length];
        for (int i = 0; i < this.sources.length; ++i) {
            String className = this.sources[i].getClasses()[0].getFullyQualifiedName();
            descs[i] = this.getJavaClassDescription(className);
        }
        return descs;
    }

    public JavaClassDescription getJavaClassDescription(String className) throws MojoExecutionException {
        JavaClassDescription result = this.javaClassDescriptions.get(className);
        if (result == null) {
            this.log.debug((CharSequence)("Searching description for: " + className));
            int index = 0;
            while (result == null && index < this.sources.length) {
                JavaClass javaClass = this.sources[index].getClasses()[0];
                if (javaClass.getFullyQualifiedName().equals(className)) {
                    try {
                        Class<?> clazz = this.classloader.loadClass(className);
                        if (this.processAnnotations && this.getAnnotationTagProviderManager().hasScrPluginAnnotation(javaClass)) {
                            this.log.debug((CharSequence)("Found java annotation description for: " + className));
                            result = new AnnotationJavaClassDescription(clazz, this.sources[index], this);
                            continue;
                        }
                        if (!this.parseJavadocs) continue;
                        this.log.debug((CharSequence)("Found qdox description for: " + className));
                        result = new QDoxJavaClassDescription(clazz, this.sources[index], this);
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new MojoExecutionException("Unable to load class " + className);
                    }
                }
                ++index;
            }
            if (result == null) {
                try {
                    this.log.debug((CharSequence)("Generating classloader description for: " + className));
                    result = new ClassLoaderJavaClassDescription(this.classloader.loadClass(className), this.componentDescriptions.get(className), this);
                }
                catch (ClassNotFoundException e) {
                    throw new MojoExecutionException("Unable to load class " + className);
                }
            }
            this.javaClassDescriptions.put(className, result);
        }
        return result;
    }
}

