/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.mojo;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.felix.scrplugin.SCRDescriptorException;
import org.apache.felix.scrplugin.SCRDescriptorFailureException;
import org.apache.felix.scrplugin.SCRDescriptorGenerator;
import org.apache.felix.scrplugin.mojo.MavenJavaClassDescriptorManager;
import org.apache.felix.scrplugin.mojo.MavenLog;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

public class SCRDescriptorMojo
extends AbstractMojo {
    private File outputDirectory;
    private MavenProject project;
    private String finalName;
    private String metaTypeName;
    private boolean generateAccessors;
    protected boolean parseJavadoc;
    protected boolean processAnnotations;
    protected boolean strictMode;
    private String sourceExcludes;
    private Map<String, String> properties = new HashMap<String, String>();
    private String[] annotationTagProviders = new String[0];
    private String specVersion;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            MavenLog scrLog = new MavenLog(this.getLog());
            URLClassLoader classLoader = new URLClassLoader(this.getClassPath(), ((Object)((Object)this)).getClass().getClassLoader());
            MavenJavaClassDescriptorManager jManager = new MavenJavaClassDescriptorManager(this.project, scrLog, classLoader, this.annotationTagProviders, this.sourceExcludes, this.parseJavadoc, this.processAnnotations);
            SCRDescriptorGenerator generator = new SCRDescriptorGenerator(scrLog);
            generator.setOutputDirectory(this.outputDirectory);
            generator.setDescriptorManager(jManager);
            generator.setFinalName(this.finalName);
            generator.setMetaTypeName(this.metaTypeName);
            generator.setGenerateAccessors(this.generateAccessors);
            generator.setStrictMode(this.strictMode);
            generator.setProperties(this.properties);
            generator.setSpecVersion(this.specVersion);
            if (generator.execute()) {
                this.setServiceComponentHeader();
                this.addResources();
            }
        }
        catch (SCRDescriptorException sde) {
            throw new MojoExecutionException(sde.getMessage(), sde.getCause());
        }
        catch (SCRDescriptorFailureException sdfe) {
            throw (MojoFailureException)new MojoFailureException(sdfe.getMessage()).initCause((Throwable)sdfe);
        }
    }

    private URL[] getClassPath() throws MojoFailureException {
        List artifacts = this.project.getCompileArtifacts();
        ArrayList<URL> path = new ArrayList<URL>();
        try {
            path.add(new File(this.project.getBuild().getOutputDirectory()).toURI().toURL());
        }
        catch (IOException ioe) {
            throw new MojoFailureException("Unable to add target directory to classloader.");
        }
        boolean i = true;
        for (Artifact a : artifacts) {
            try {
                path.add(a.getFile().toURI().toURL());
            }
            catch (IOException ioe) {
                throw new MojoFailureException("Unable to get compile class loader.");
            }
        }
        return path.toArray(new URL[path.size()]);
    }

    private void setServiceComponentHeader() {
        File descriptorFile;
        File file = descriptorFile = StringUtils.isEmpty((String)this.finalName) ? null : new File(new File(this.outputDirectory, "OSGI-INF"), this.finalName);
        if (descriptorFile.exists()) {
            String svcComp = this.project.getProperties().getProperty("Service-Component");
            String svcPath = "OSGI-INF/" + this.finalName;
            svcComp = svcComp == null ? svcPath : (svcComp.contains(svcPath) ? svcComp : svcComp + ", " + svcPath);
            this.project.getProperties().setProperty("Service-Component", svcComp);
        }
    }

    private void addResources() {
        String ourRsrcPath = this.outputDirectory.getAbsolutePath();
        boolean found = false;
        Iterator rsrcIterator = this.project.getResources().iterator();
        while (!found && rsrcIterator.hasNext()) {
            Resource rsrc = (Resource)rsrcIterator.next();
            found = rsrc.getDirectory().equals(ourRsrcPath);
        }
        if (!found) {
            Resource resource = new Resource();
            resource.setDirectory(this.outputDirectory.getAbsolutePath());
            this.project.addResource(resource);
        }
    }
}

