/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.mojo;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.felix.scrplugin.JavaClassDescriptorManager;
import org.apache.felix.scrplugin.Log;
import org.apache.felix.scrplugin.SCRDescriptorFailureException;
import org.apache.felix.scrplugin.helper.StringUtils;
import org.apache.felix.scrplugin.om.Component;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenJavaClassDescriptorManager
extends JavaClassDescriptorManager {
    private final MavenProject project;
    private final String excludeString;
    private Map<String, Component> componentDescriptions;

    public MavenJavaClassDescriptorManager(MavenProject project, Log log, ClassLoader classLoader, String[] annotationTagProviders, String excludeString, boolean parseJavadocs, boolean processAnnotations) throws SCRDescriptorFailureException {
        super(log, classLoader, annotationTagProviders, parseJavadocs, processAnnotations);
        this.project = project;
        this.excludeString = excludeString;
    }

    public String getOutputDirectory() {
        return this.project.getBuild().getOutputDirectory();
    }

    protected Iterator<File> getSourceFiles() {
        ArrayList<File> files = new ArrayList<File>();
        Iterator i = this.project.getCompileSourceRoots().iterator();
        String[] includes = new String[]{"**/*.java"};
        String[] excludes = this.excludeString != null ? StringUtils.split((String)this.excludeString, (String)",") : null;
        while (i.hasNext()) {
            String tree = (String)i.next();
            File directory = new File(tree);
            if (!directory.exists()) {
                this.log.warn("Source tree does not exist. Ignoring " + tree);
                continue;
            }
            this.log.debug("Scanning source tree " + tree);
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(directory);
            if (excludes != null && excludes.length > 0) {
                scanner.setExcludes(excludes);
            }
            scanner.addDefaultExcludes();
            scanner.setIncludes(includes);
            scanner.scan();
            for (String fileName : scanner.getIncludedFiles()) {
                files.add(new File(directory, fileName));
            }
        }
        return files.iterator();
    }

    protected List<File> getDependencies() {
        ArrayList<File> dependencies = new ArrayList<File>();
        Map resolved = this.project.getArtifactMap();
        for (Artifact declared : resolved.values()) {
            this.log.debug("Checking artifact " + declared);
            if (this.isJavaArtifact(declared)) {
                if ("compile".equals(declared.getScope()) || "runtime".equals(declared.getScope()) || "provided".equals(declared.getScope()) || "system".equals(declared.getScope())) {
                    this.log.debug("Resolving artifact " + declared);
                    Artifact artifact = (Artifact)resolved.get(ArtifactUtils.versionlessKey((Artifact)declared));
                    if (artifact != null) {
                        dependencies.add(artifact.getFile());
                        continue;
                    }
                    this.log.debug("Unable to resolve artifact " + declared);
                    continue;
                }
                this.log.debug("Artifact " + declared + " has not scope compile or runtime, but " + declared.getScope());
                continue;
            }
            this.log.debug("Artifact " + declared + " is not a java artifact, type is " + declared.getType());
        }
        return dependencies;
    }

    private boolean isJavaArtifact(Artifact artifact) {
        if ("jar".equals(artifact.getType())) {
            return true;
        }
        return "bundle".equals(artifact.getType());
    }
}

