/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.configadmin.plugin.interpolation;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.configadmin.plugin.interpolation.InterpolationConfigurationPlugin;
import org.osgi.annotation.bundle.Header;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Header(name="Bundle-Activator", value="${@class}")
public class Activator
implements BundleActivator {
    static final String DEPRECATED_DIR_PROPERTY = "org.apache.felix.configadmin.plugin.interpolation.dir";
    static final String DIR_PROPERTY = "org.apache.felix.configadmin.plugin.interpolation.secretsdir";
    static final String ENCODING_PROPERTY = "org.apache.felix.configadmin.plugin.interpolation.file.encoding";
    static final String PLUGIN_ID = "org.apache.felix.configadmin.plugin.interpolation";
    static final int PLUGIN_RANKING = 500;
    static final Logger LOG = LoggerFactory.getLogger(InterpolationConfigurationPlugin.class);

    public void start(BundleContext context) throws Exception {
        String directory = context.getProperty(DIR_PROPERTY);
        if (directory == null && (directory = context.getProperty(DEPRECATED_DIR_PROPERTY)) != null) {
            LOG.warn("Deprecated property is used for configuration, switch from using 'org.apache.felix.configadmin.plugin.interpolation.dir' to the new 'org.apache.felix.configadmin.plugin.interpolation.secretsdir'.");
        }
        String encoding = context.getProperty(ENCODING_PROPERTY);
        InterpolationConfigurationPlugin plugin = new InterpolationConfigurationPlugin(context, directory, encoding);
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("service.cmRanking", 500);
        ((Dictionary)props).put("config.plugin.id", PLUGIN_ID);
        if (directory != null) {
            ((Dictionary)props).put(DIR_PROPERTY, directory);
        } else {
            ((Dictionary)props).put(DIR_PROPERTY, "<not configured>");
        }
        if (encoding != null) {
            ((Dictionary)props).put(ENCODING_PROPERTY, encoding);
        } else {
            ((Dictionary)props).put(ENCODING_PROPERTY, "<not configured>");
        }
        context.registerService(ConfigurationPlugin.class, (Object)plugin, props);
    }

    public void stop(BundleContext context) throws Exception {
    }
}

