/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.configadmin.plugin.interpolation;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.configadmin.plugin.interpolation.Activator;
import org.apache.felix.configadmin.plugin.interpolation.Interpolator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationPlugin;
import org.osgi.util.converter.Converters;
import org.slf4j.Logger;

class InterpolationConfigurationPlugin
implements ConfigurationPlugin {
    private static final String TYPE_ENV = "env";
    private static final String TYPE_PROP = "prop";
    private static final String TYPE_SECRET = "secret";
    private static final String DIRECTIVE_TYPE = "type";
    private static final String DIRECTIVE_DELIMITER = "delimiter";
    private static final String DIRECTIVE_DEFAULT = "default";
    private static final Map<String, Class<?>> TYPE_MAP = new HashMap();
    private final BundleContext context;
    private final File directory;
    private final Charset encodingCharset;

    InterpolationConfigurationPlugin(BundleContext bc, String dir, String fileEncoding) {
        this.context = bc;
        if (dir != null) {
            this.directory = new File(dir);
            this.getLog().info("Configured directory for secrets: {}", (Object)dir);
        } else {
            this.directory = null;
        }
        this.encodingCharset = fileEncoding == null ? Charset.defaultCharset() : Charset.forName(fileEncoding);
    }

    private Logger getLog() {
        return Activator.LOG;
    }

    public void modifyConfiguration(ServiceReference<?> reference, Dictionary<String, Object> properties) {
        Object pid = properties.get("service.pid");
        Enumeration<String> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Object val = properties.get(key);
            if (val instanceof String) {
                Object newVal = this.getNewValue(key, (String)val, pid);
                if (newVal == null || newVal.equals(val)) continue;
                properties.put(key, newVal);
                this.getLog().info("Replaced value of configuration property '{}' for PID {}", (Object)key, pid);
                continue;
            }
            if (!(val instanceof String[])) continue;
            String[] array = (String[])val;
            String[] newArray = null;
            for (int i = 0; i < array.length; ++i) {
                Object newVal = this.getNewValue(key, array[i], pid);
                if (newVal == null || newVal.equals(array[i])) continue;
                if (newArray == null) {
                    newArray = new String[array.length];
                    System.arraycopy(array, 0, newArray, 0, array.length);
                }
                newArray[i] = newVal.toString();
            }
            if (newArray == null) continue;
            properties.put(key, newArray);
            this.getLog().info("Replaced value of configuration property '{}' for PID {}", (Object)key, pid);
        }
    }

    private Object getNewValue(String key, String value, Object pid) {
        Object result = this.replace(key, value, pid);
        if (value.equals(result)) {
            return null;
        }
        return result;
    }

    Object replace(String key, String value, Object pid) {
        Object result = Interpolator.replace(value, (type, name, dir) -> {
            String v = null;
            if (TYPE_ENV.equals(type)) {
                v = this.getVariableFromEnvironment(name);
            } else if (TYPE_PROP.equals(type)) {
                v = this.getVariableFromProperty(name);
            } else if (TYPE_SECRET.equals(type)) {
                v = this.getVariableFromFile(key, name, pid);
            }
            if (v == null) {
                v = (String)dir.get(DIRECTIVE_DEFAULT);
            }
            if (v != null && dir.containsKey(DIRECTIVE_TYPE)) {
                return this.convertType((String)dir.get(DIRECTIVE_TYPE), v, (String)dir.get(DIRECTIVE_DELIMITER));
            }
            return v;
        });
        return result;
    }

    String getVariableFromEnvironment(String name) {
        return System.getenv(name);
    }

    String getVariableFromProperty(String name) {
        return this.context.getProperty(name);
    }

    String getVariableFromFile(String key, String name, Object pid) {
        byte[] bytes;
        if (this.directory == null) {
            this.getLog().warn("Cannot replace property value {} for PID {}. No directory configured via framework property org.apache.felix.configadmin.plugin.interpolation.secretsdir", (Object)key, pid);
            return null;
        }
        if (name.contains("..")) {
            this.getLog().error("Illegal secret location: " + name + " Going up in the directory structure is not allowed");
            return null;
        }
        File file = new File(this.directory, name);
        if (!file.isFile()) {
            this.getLog().warn("Cannot replace variable. Configured path is not a regular file: " + file);
            return null;
        }
        if (!file.getAbsolutePath().startsWith(this.directory.getAbsolutePath())) {
            this.getLog().error("Illegal secret location: " + name + " Going out the directory structure is not allowed");
            return null;
        }
        try {
            bytes = Files.readAllBytes(file.toPath());
        }
        catch (IOException e) {
            this.getLog().error("Problem replacing configuration property '{}' for PID {} from file {}", new Object[]{key, pid, file, e});
            return null;
        }
        return new String(bytes, this.encodingCharset).trim();
    }

    Object convertType(String type, String value, String delimiter) {
        if (type == null) {
            return value;
        }
        Class<?> cls = TYPE_MAP.get(type);
        if (cls != null) {
            if ((cls.isArray() || Collection.class.isAssignableFrom(cls)) && delimiter != null) {
                String[] array = this.split(value, delimiter);
                return Converters.standardConverter().convert((Object)array).to(cls);
            }
            return Converters.standardConverter().convert((Object)value).to(cls);
        }
        this.getLog().warn("Cannot convert to type: " + type);
        return value;
    }

    String[] split(String value, String delimiter) {
        ArrayList<String> result = null;
        int start = -1;
        while (start < value.length()) {
            if ((start = value.indexOf(delimiter, start + 1)) == -1) {
                start = value.length();
                if (result == null) continue;
                result.add(value);
                continue;
            }
            boolean split = true;
            if (start > 1 && value.charAt(start - 1) == '\\') {
                if (start == 1 || value.charAt(start - 2) != '\\') {
                    split = false;
                } else if (value.charAt(start - 2) == '\\') {
                    value = value.substring(0, start - 2).concat(value.substring(start - 1));
                    --start;
                }
            }
            if (split) {
                if (result == null) {
                    result = new ArrayList<String>();
                }
                result.add(value.substring(0, start));
                value = value.substring(start + delimiter.length());
                start = -1;
                continue;
            }
            if (start == 1) {
                value = value.substring(1);
                continue;
            }
            value = value.substring(0, start - 1).concat(value.substring(start));
            --start;
        }
        if (result == null) {
            return new String[]{value};
        }
        return result.toArray(new String[result.size()]);
    }

    static {
        TYPE_MAP.put("String", String.class);
        TYPE_MAP.put("Integer", Integer.class);
        TYPE_MAP.put("int", Integer.class);
        TYPE_MAP.put("Long", Long.class);
        TYPE_MAP.put("long", Long.class);
        TYPE_MAP.put("Float", Float.class);
        TYPE_MAP.put("float", Float.class);
        TYPE_MAP.put("Double", Double.class);
        TYPE_MAP.put("double", Double.class);
        TYPE_MAP.put("Byte", Byte.class);
        TYPE_MAP.put("byte", Byte.class);
        TYPE_MAP.put("Short", Short.class);
        TYPE_MAP.put("short", Short.class);
        TYPE_MAP.put("Character", Character.class);
        TYPE_MAP.put("char", Character.class);
        TYPE_MAP.put("Boolean", Boolean.class);
        TYPE_MAP.put("boolean", Boolean.class);
        TYPE_MAP.put("String[]", String[].class);
        TYPE_MAP.put("Integer[]", Integer[].class);
        TYPE_MAP.put("int[]", int[].class);
        TYPE_MAP.put("Long[]", Long[].class);
        TYPE_MAP.put("long[]", long[].class);
        TYPE_MAP.put("Float[]", Float[].class);
        TYPE_MAP.put("float[]", float[].class);
        TYPE_MAP.put("Double[]", Double[].class);
        TYPE_MAP.put("double[]", double[].class);
        TYPE_MAP.put("Byte[]", Byte[].class);
        TYPE_MAP.put("byte[]", byte[].class);
        TYPE_MAP.put("Short[]", Short[].class);
        TYPE_MAP.put("short[]", short[].class);
        TYPE_MAP.put("Boolean[]", Boolean[].class);
        TYPE_MAP.put("boolean[]", boolean[].class);
        TYPE_MAP.put("Character[]", Character[].class);
        TYPE_MAP.put("char[]", char[].class);
    }
}

