/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.felix.cm.PersistenceManager;
import org.apache.felix.cm.impl.CaseInsensitiveDictionary;
import org.apache.felix.cm.impl.SimpleFilter;

class CachingPersistenceManagerProxy
implements PersistenceManager {
    private final PersistenceManager pm;
    private final Hashtable<String, CaseInsensitiveDictionary> cache;
    private final ReadWriteLock globalLock = new ReentrantReadWriteLock();
    private boolean fullyLoaded;

    public CachingPersistenceManagerProxy(PersistenceManager pm) {
        this.pm = pm;
        this.cache = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String pid) throws IOException {
        Lock lock = this.globalLock.writeLock();
        try {
            lock.lock();
            this.cache.remove(pid);
            this.pm.delete(pid);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String pid) {
        Lock lock = this.globalLock.readLock();
        try {
            lock.lock();
            boolean bl = this.cache.containsKey(pid) || !this.fullyLoaded && this.pm.exists(pid);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public Enumeration getDictionaries() throws IOException {
        return this.getDictionaries(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getDictionaries(SimpleFilter filter) throws IOException {
        Lock lock = this.globalLock.readLock();
        try {
            lock.lock();
            if (!this.fullyLoaded) {
                lock.unlock();
                lock = this.globalLock.writeLock();
                lock.lock();
                if (!this.fullyLoaded) {
                    Enumeration fromPm = this.pm.getDictionaries();
                    while (fromPm.hasMoreElements()) {
                        Dictionary next = (Dictionary)fromPm.nextElement();
                        String pid = (String)next.get("service.pid");
                        if (pid == null) continue;
                        this.cache.put(pid, this.copy(next));
                    }
                    this.fullyLoaded = true;
                }
            }
            Vector<CaseInsensitiveDictionary> configs = new Vector<CaseInsensitiveDictionary>();
            for (CaseInsensitiveDictionary o : this.cache.values()) {
                Dictionary d = o;
                if (filter != null && !filter.matches(d)) continue;
                configs.add(this.copy(d));
            }
            Enumeration enumeration = configs.elements();
            return enumeration;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dictionary load(String pid) throws IOException {
        Lock lock = this.globalLock.readLock();
        try {
            lock.lock();
            Dictionary loaded = this.cache.get(pid);
            if (loaded == null && !this.fullyLoaded) {
                lock.unlock();
                lock = this.globalLock.writeLock();
                lock.lock();
                loaded = this.cache.get(pid);
                if (loaded == null) {
                    loaded = this.pm.load(pid);
                    this.cache.put(pid, this.copy(loaded));
                }
            }
            CaseInsensitiveDictionary caseInsensitiveDictionary = this.copy(loaded);
            return caseInsensitiveDictionary;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String pid, Dictionary properties) throws IOException {
        Lock lock = this.globalLock.writeLock();
        try {
            lock.lock();
            this.pm.store(pid, properties);
            this.cache.put(pid, this.copy(properties));
        }
        finally {
            lock.unlock();
        }
    }

    CaseInsensitiveDictionary copy(Dictionary source) {
        return new CaseInsensitiveDictionary(source);
    }
}

