/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.connect;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.felix.connect.FileEntriesEnumeration;
import org.apache.felix.connect.Revision;

class DirRevision
implements Revision {
    private final File m_file;

    public DirRevision(File file) {
        this.m_file = file;
    }

    @Override
    public long getLastModified() {
        return this.m_file.lastModified();
    }

    @Override
    public Enumeration<String> getEntries() {
        return new FileEntriesEnumeration(this.m_file);
    }

    @Override
    public URL getEntry(String entryName) {
        try {
            File file;
            if (entryName != null && (file = new File(this.m_file, entryName.startsWith("/") ? entryName.substring(1) : entryName)).exists()) {
                return file.toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return null;
    }
}

