/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.annotation.plugin.bnd;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Patterns {
    public static final Pattern VOID = Pattern.compile("\\(\\)V");
    public static final Pattern COMPOSITION = Pattern.compile("\\(\\)\\[Ljava/lang/Object;");
    public static final Pattern BIND_CLASS1 = Pattern.compile("\\((Lorg/apache/felix/dm/Component;)(Lorg/osgi/framework/ServiceReference;)L([^;]+);\\)V");
    public static final Pattern BIND_CLASS2 = Pattern.compile("\\((Lorg/apache/felix/dm/Component;)L([^;]+);\\)V");
    public static final Pattern BIND_CLASS3 = Pattern.compile("\\((Lorg/apache/felix/dm/Component;)(Ljava/util/Map;)L([^;]+);\\)V");
    public static final Pattern BIND_CLASS4 = Pattern.compile("\\((Lorg/osgi/framework/ServiceReference;)L([^;]+);\\)V");
    public static final Pattern BIND_CLASS5 = Pattern.compile("\\(L([^;]+);\\)V");
    public static final Pattern BIND_CLASS6 = Pattern.compile("\\(L([^;]+);(Ljava/util/Map;)\\)V");
    public static final Pattern BIND_CLASS7 = Pattern.compile("\\((Ljava/util/Map;)L([^;]+);\\)V");
    public static final Pattern BIND_CLASS8 = Pattern.compile("\\(L([^;]+);(Ljava/util/Dictionary;)\\)V");
    public static final Pattern BIND_CLASS9 = Pattern.compile("\\((Ljava/util/Dictionary;)L([^;]+);\\)V");
    public static final Pattern CLASS = Pattern.compile("L([^;]+);");
    public static final Pattern RUNNABLE = Pattern.compile("Ljava/lang/Runnable;");
    public static final Pattern BUNDLE_CONTEXT = Pattern.compile("Lorg/osgi/framework/BundleContext;");
    public static final Pattern DEPENDENCY_MANAGER = Pattern.compile("Lorg.apache.felix.dm.DependencyManager;");
    public static final Pattern COMPONENT = Pattern.compile("Lorg.apache.felix.dm.Component;");

    public static String parseClass(String clazz, Pattern pattern, int group) {
        return Patterns.parseClass(clazz, pattern, group, true);
    }

    public static String parseClass(String clazz, Pattern pattern, int group, boolean throwException) {
        Matcher matcher = pattern.matcher(clazz);
        if (matcher.matches()) {
            return matcher.group(group).replace("/", ".");
        }
        if (throwException) {
            throw new IllegalArgumentException("Invalid class descriptor: " + clazz);
        }
        return null;
    }

    public static void parseMethod(String method, String descriptor, Pattern pattern) {
        Matcher matcher = pattern.matcher(descriptor);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid method " + method + ", wrong signature: " + descriptor);
        }
    }

    public static void parseField(String field, String descriptor, Pattern pattern) {
        Matcher matcher = pattern.matcher(descriptor);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid field " + field + ", wrong signature: " + descriptor);
        }
    }
}

