/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.shell;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.ComponentDeclaration;
import org.apache.felix.dm.ComponentDependencyDeclaration;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.diagnostics.CircularDependency;
import org.apache.felix.dm.diagnostics.DependencyGraph;
import org.apache.felix.dm.diagnostics.MissingDependency;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Descriptor;
import org.apache.felix.service.command.Parameter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

@Descriptor(value="Commands used to dump all existing Dependency Manager components")
public class DMCommand {
    private final BundleContext m_context;
    private static final ComponentDeclarationComparator COMPONENT_DECLARATION_COMPARATOR = new ComponentDeclarationComparator();
    private static final String SERVICE = "service";
    private static final String CONFIGURATION = "configuration";
    private static final String RESOURCE = "resource";
    private static final String BUNDLE = "bundle";
    private static final String ENV_COMPACT = "dependencymanager.compact";
    private static final String ENV_SERVICES = "dependencymanager.services";
    private static final String ENV_COMPONENTS = "dependencymanager.components";

    public DMCommand(BundleContext context) {
        this.m_context = context;
    }

    @Descriptor(value="List dependency manager components")
    public void dm(CommandSession session, @Descriptor(value="Hides component dependencies") @Parameter(names={"nodeps", "nd"}, presentValue="true", absentValue="false") boolean nodeps, @Descriptor(value="Displays components using a compact form") @Parameter(names={"compact", "cp"}, presentValue="true", absentValue="") String compact, @Descriptor(value="Only displays unavailable components") @Parameter(names={"notavail", "na"}, presentValue="true", absentValue="false") boolean notavail, @Descriptor(value="Detects where are the root failures") @Parameter(names={"wtf"}, presentValue="true", absentValue="false") boolean wtf, @Descriptor(value="Displays components statistics") @Parameter(names={"stats", "stat", "st"}, presentValue="true", absentValue="false") boolean stats, @Descriptor(value="<OSGi filter used to filter some service properties>") @Parameter(names={"services", "s"}, absentValue="") String services, @Descriptor(value="<Regex(s) used to filter on component implementation class names (comma separated), can be negated using \"!\" prefix>") @Parameter(names={"components", "c"}, absentValue="") String components, @Descriptor(value="<List of component identifiers to display (comma separated)>") @Parameter(names={"componentIds", "cid", "ci"}, absentValue="") String componentIds, @Descriptor(value="<List of bundle ids or bundle symbolic names to display (comma separated)>") @Parameter(names={"bundleIds", "bid", "bi", "b"}, absentValue="") String bundleIds, @Descriptor(value="<Max number of top components to display (0=all)> This command displays components callbacks (init/start) times>") @Parameter(names={"top"}, absentValue="-1") int top) throws Throwable {
        boolean comp = Boolean.parseBoolean(this.getParam(session, ENV_COMPACT, compact));
        services = this.getParam(session, ENV_SERVICES, services);
        String[] componentsRegex = this.getParams(session, ENV_COMPONENTS, components);
        ArrayList<String> bids = new ArrayList<String>();
        ArrayList<Long> cids = new ArrayList<Long>();
        StringTokenizer tok = new StringTokenizer(componentIds, ", ");
        while (tok.hasMoreTokens()) {
            try {
                cids.add(Long.parseLong(tok.nextToken()));
            }
            catch (NumberFormatException e) {
                System.out.println("Invalid value for componentIds option");
                return;
            }
        }
        Filter servicesFilter = null;
        try {
            if (services != null) {
                servicesFilter = this.m_context.createFilter(services);
            }
        }
        catch (InvalidSyntaxException e) {
            System.out.println("Invalid services OSGi filter: " + services);
            e.printStackTrace(System.err);
            return;
        }
        tok = new StringTokenizer(bundleIds, ", ");
        while (tok.hasMoreTokens()) {
            bids.add(tok.nextToken());
        }
        if (top != -1) {
            this.showTopComponents(top);
            return;
        }
        if (wtf) {
            this.wtf();
            return;
        }
        DependencyGraph graph = null;
        graph = notavail ? DependencyGraph.getGraph((DependencyGraph.ComponentState)DependencyGraph.ComponentState.UNREGISTERED, (DependencyGraph.DependencyState)DependencyGraph.DependencyState.ALL_UNAVAILABLE) : DependencyGraph.getGraph((DependencyGraph.ComponentState)DependencyGraph.ComponentState.ALL, (DependencyGraph.DependencyState)DependencyGraph.DependencyState.ALL);
        List allComponents = graph.getAllComponents();
        Collections.sort(allComponents, COMPONENT_DECLARATION_COMPARATOR);
        long numberOfComponents = 0L;
        long numberOfDependencies = 0L;
        long lastBundleId = -1L;
        for (ComponentDeclaration cd : allComponents) {
            List dependencies;
            Bundle bundle = cd.getBundleContext().getBundle();
            if (!this.matchBundle(bundle, bids)) continue;
            Component component = (Component)cd;
            String name = cd.getName();
            if (!this.mayDisplay(component, servicesFilter, componentsRegex, cids)) continue;
            ++numberOfComponents;
            long bundleId = bundle.getBundleId();
            if (lastBundleId != bundleId) {
                lastBundleId = bundleId;
                if (comp) {
                    System.out.println("[" + bundleId + "] " + this.compactName(bundle.getSymbolicName()));
                } else {
                    System.out.println("[" + bundleId + "] " + bundle.getSymbolicName());
                }
            }
            if (comp) {
                System.out.print(" [" + cd.getId() + "] " + this.compactName(name) + " " + this.compactState(ComponentDeclaration.STATE_NAMES[cd.getState()]));
            } else {
                System.out.println(" [" + cd.getId() + "] " + name + " " + ComponentDeclaration.STATE_NAMES[cd.getState()]);
            }
            if (!nodeps && !(dependencies = graph.getDependecies(cd)).isEmpty()) {
                numberOfDependencies += (long)dependencies.size();
                if (comp) {
                    System.out.print('(');
                }
                for (int j = 0; j < dependencies.size(); ++j) {
                    ComponentDependencyDeclaration dep = (ComponentDependencyDeclaration)dependencies.get(j);
                    String depName = dep.getName();
                    String depType = dep.getType();
                    int depState = dep.getState();
                    if (comp) {
                        if (j > 0) {
                            System.out.print(' ');
                        }
                        System.out.print(this.compactName(depName) + " " + this.compactState(depType) + " " + this.compactState(ComponentDependencyDeclaration.STATE_NAMES[depState]));
                        continue;
                    }
                    System.out.println("    " + depName + " " + depType + " " + ComponentDependencyDeclaration.STATE_NAMES[depState]);
                }
                if (comp) {
                    System.out.print(')');
                }
            }
            if (!comp) continue;
            System.out.println();
        }
        if (stats) {
            System.out.println("Statistics:");
            System.out.println(" - Dependency managers: " + DependencyManager.getDependencyManagers().size());
            System.out.println(" - Components: " + numberOfComponents);
            if (!nodeps) {
                System.out.println(" - Dependencies: " + numberOfDependencies);
            }
        }
    }

    private void showTopComponents(int max) {
        ArrayList components = new ArrayList();
        for (DependencyManager manager : DependencyManager.getDependencyManagers()) {
            components.addAll(manager.getComponents());
        }
        Collections.sort(components, new Comparator<Component>(){

            @Override
            public int compare(Component c1, Component c2) {
                Map c1Times = c1.getComponentDeclaration().getCallbacksTime();
                Map c2Times = c2.getComponentDeclaration().getCallbacksTime();
                Long c1Start = (Long)c1Times.get("start");
                Long c2Start = (Long)c2Times.get("start");
                if (c1Start != null) {
                    if (c2Start != null) {
                        return c1Start > c2Start ? 1 : -1;
                    }
                    return 1;
                }
                if (c2Start != null) {
                    return -1;
                }
                return 0;
            }
        });
        Collections.reverse(components);
        System.out.printf("%-100s %10s %10s%n%n", "Top components (sorted by start duration time)", "[init time]", "[start time]");
        if (components.size() > 0) {
            System.out.println();
            max = max == 0 ? components.size() : Math.min(components.size(), max);
            for (int i = 0; i < components.size() && i < max; ++i) {
                ComponentDeclaration decl = ((Component)components.get(i)).getComponentDeclaration();
                System.out.printf("%-100s %10d %10d%n", decl.getClassName(), decl.getCallbacksTime().get("init"), decl.getCallbacksTime().get("start"));
            }
        }
    }

    private boolean matchBundle(Bundle bundle, List<String> ids) {
        if (ids.size() == 0) {
            return true;
        }
        for (int i = 0; i < ids.size(); ++i) {
            String id = ids.get(i);
            try {
                Long longId = Long.valueOf(id);
                if (longId.longValue() != bundle.getBundleId()) continue;
                return true;
            }
            catch (NumberFormatException e) {
                if (!id.equals(bundle.getSymbolicName())) continue;
                return true;
            }
        }
        return false;
    }

    private String getParam(CommandSession session, String param, String value) {
        if (value != null && value.length() > 0) {
            return value;
        }
        Object shellParamValue = session.get(param);
        return shellParamValue != null ? shellParamValue.toString() : null;
    }

    private String[] getParams(CommandSession session, String name, String value) {
        String values = null;
        if (value == null || value.length() == 0) {
            value = (String)session.get(name);
            if (value != null) {
                values = value;
            }
        } else {
            values = value;
        }
        if (values == null) {
            return new String[0];
        }
        return values.trim().split(", ");
    }

    private boolean mayDisplay(Component component, Filter servicesFilter, String[] components, List<Long> componentIds) {
        long componentId;
        if (componentIds.size() > 0 && componentIds.indexOf(componentId = ((ComponentDeclaration)component).getId()) == -1) {
            return false;
        }
        if (servicesFilter == null && components.length == 0) {
            return true;
        }
        boolean servicesMatches = this.servicesMatches(component, servicesFilter);
        boolean componentsMatches = this.componentMatches(((ComponentDeclaration)component).getClassName(), components);
        return servicesMatches || componentsMatches;
    }

    private boolean servicesMatches(Component component, Filter servicesFilter) {
        String[] services;
        boolean match = false;
        if (servicesFilter != null && (services = ((ComponentDeclaration)component).getServices()) != null) {
            Hashtable<String, String[]> properties = component.getServiceProperties();
            if (properties == null) {
                properties = new Hashtable<String, String[]>();
            }
            if (((Dictionary)properties).get("objectClass") == null) {
                ((Dictionary)properties).put("objectClass", services);
            }
            match = servicesFilter.match(properties);
        }
        return match;
    }

    private boolean componentMatches(String description, String[] names) {
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            boolean not = false;
            if (name.startsWith("!")) {
                name = name.substring(1);
                not = true;
            }
            boolean match = false;
            if (description.matches(name)) {
                match = true;
            }
            if (not) {
                boolean bl = match = !match;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }

    private String compactState(String input) {
        StringBuffer output = new StringBuffer();
        StringTokenizer st = new StringTokenizer(input);
        while (st.hasMoreTokens()) {
            output.append(st.nextToken().toUpperCase().charAt(0));
        }
        return output.toString();
    }

    private String compactName(String input) {
        StringBuffer output = new StringBuffer();
        int lastIndex = 0;
        block4: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '.': {
                    output.append(input.charAt(lastIndex));
                    output.append('.');
                    lastIndex = i + 1;
                    continue block4;
                }
                case ' ': 
                case ',': {
                    if (lastIndex < i) {
                        output.append(input.substring(lastIndex, i));
                    }
                    output.append(c);
                    lastIndex = i + 1;
                    continue block4;
                }
            }
        }
        if (lastIndex < input.length()) {
            output.append(input.substring(lastIndex));
        }
        return output.toString();
    }

    public void wtf() {
        List missingBundleDependencies;
        List missingResourceDependencies;
        List missingServiceDependencies;
        List missingConfigDependencies;
        DependencyGraph graph = DependencyGraph.getGraph((DependencyGraph.ComponentState)DependencyGraph.ComponentState.UNREGISTERED, (DependencyGraph.DependencyState)DependencyGraph.DependencyState.REQUIRED_UNAVAILABLE);
        List unregisteredComponents = graph.getAllComponents();
        if (unregisteredComponents.isEmpty()) {
            System.out.println("No unregistered components found");
        } else {
            String message = unregisteredComponents.size() + " unregistered components found";
            System.out.println(message);
            System.out.println("----------------------------------------------------".substring(0, message.length()));
        }
        this.listResolvedBundles();
        this.listInstalledBundles();
        List circularDependencies = graph.getCircularDependencies();
        if (!circularDependencies.isEmpty()) {
            System.out.println("Circular dependencies:");
            this.printCircularDependencies(circularDependencies);
        }
        if (!(missingConfigDependencies = graph.getMissingDependencies(CONFIGURATION)).isEmpty()) {
            System.out.println("The following configuration(s) are missing: ");
            this.printMissingDependencies(missingConfigDependencies);
        }
        if (!(missingServiceDependencies = graph.getMissingDependencies(SERVICE)).isEmpty()) {
            System.out.println("The following service(s) are missing: ");
            this.printMissingDependencies(missingServiceDependencies);
        }
        if (!(missingResourceDependencies = graph.getMissingDependencies(RESOURCE)).isEmpty()) {
            System.out.println("The following resource(s) are missing: ");
            this.printMissingDependencies(missingResourceDependencies);
        }
        if (!(missingBundleDependencies = graph.getMissingDependencies(BUNDLE)).isEmpty()) {
            System.out.println("The following bundle(s) are missing: ");
            this.printMissingDependencies(missingBundleDependencies);
        }
    }

    private void printCircularDependencies(List<CircularDependency> circularDependencies) {
        for (CircularDependency c : circularDependencies) {
            System.out.print(" *");
            for (ComponentDeclaration cd : c.getComponents()) {
                System.out.print(" -> " + cd.getName());
            }
            System.out.println();
        }
    }

    private void printMissingDependencies(List<MissingDependency> missingConfigDependencies) {
        for (MissingDependency m : missingConfigDependencies) {
            System.out.println(" * " + m.getName() + " for bundle " + m.getBundleName());
        }
    }

    private void listResolvedBundles() {
        boolean areResolved = false;
        for (Bundle b : this.m_context.getBundles()) {
            if (b.getState() != 4 || this.isFragment(b)) continue;
            areResolved = true;
            break;
        }
        if (areResolved) {
            System.out.println("Please note that the following bundles are in the RESOLVED state:");
            for (Bundle b : this.m_context.getBundles()) {
                if (b.getState() != 4 || this.isFragment(b)) continue;
                System.out.println(" * [" + b.getBundleId() + "] " + b.getSymbolicName());
            }
        }
    }

    private void listInstalledBundles() {
        boolean areResolved = false;
        for (Bundle b : this.m_context.getBundles()) {
            if (b.getState() != 2) continue;
            areResolved = true;
            break;
        }
        if (areResolved) {
            System.out.println("Please note that the following bundles are in the INSTALLED state:");
            for (Bundle b : this.m_context.getBundles()) {
                if (b.getState() != 2) continue;
                System.out.println(" * [" + b.getBundleId() + "] " + b.getSymbolicName());
            }
        }
    }

    private boolean isFragment(Bundle b) {
        Dictionary headers = b.getHeaders();
        return headers.get("Fragment-Host") != null;
    }

    public static class ComponentDeclarationComparator
    implements Comparator<ComponentDeclaration> {
        @Override
        public int compare(ComponentDeclaration cd1, ComponentDeclaration cd2) {
            long id2;
            long id1 = cd1.getBundleContext().getBundle().getBundleId();
            if (id1 == (id2 = cd2.getBundleContext().getBundle().getBundleId())) {
                long cid2;
                long cid1 = cd1.getId();
                return cid1 > (cid2 = cd2.getId()) ? 1 : -1;
            }
            return id1 > id2 ? 1 : -1;
        }
    }
}

