/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dependencymanager;

import java.util.Dictionary;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public final class ServiceRegistrationImpl
implements ServiceRegistration {
    public static final ServiceRegistrationImpl ILLEGAL_STATE = new ServiceRegistrationImpl();
    private ServiceRegistration m_registration = null;

    public ServiceReference getReference() {
        return this.ensureRegistration().getReference();
    }

    public void setProperties(Dictionary dictionary) {
        this.ensureRegistration().setProperties(dictionary);
    }

    public void unregister() {
        this.ensureRegistration().unregister();
    }

    public boolean equals(Object obj) {
        return this.ensureRegistration().equals(obj);
    }

    public int hashCode() {
        return this.ensureRegistration().hashCode();
    }

    public String toString() {
        return this.ensureRegistration().toString();
    }

    private synchronized ServiceRegistration ensureRegistration() {
        while (this.m_registration == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (ILLEGAL_STATE == this.m_registration) {
            throw new IllegalStateException("Service is not registered.");
        }
        return this.m_registration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setServiceRegistration(ServiceRegistration registration) {
        ServiceRegistrationImpl serviceRegistrationImpl = this;
        synchronized (serviceRegistrationImpl) {
            this.m_registration = registration;
            this.notifyAll();
        }
    }

    void setIllegalState() {
        this.setServiceRegistration(ILLEGAL_STATE);
    }
}

