/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.dm.FilterIndex;
import org.apache.felix.dm.ServiceUtil;
import org.apache.felix.dm.impl.index.AbstractFactoryFilterIndex;
import org.apache.felix.dm.tracker.ServiceTracker;
import org.apache.felix.dm.tracker.ServiceTrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class AdapterFilterIndex
extends AbstractFactoryFilterIndex
implements FilterIndex,
ServiceTrackerCustomizer {
    private static final String FILTER_REGEXP = "\\(&\\(objectClass=([a-zA-Z\\.\\$0-9]*)\\)\\(\\|\\(service.id=([0-9]*)\\)\\(org.apache.felix.dependencymanager.aspect=([0-9]*)\\)\\)\\)";
    private static final Pattern PATTERN = Pattern.compile("\\(&\\(objectClass=([a-zA-Z\\.\\$0-9]*)\\)\\(\\|\\(service.id=([0-9]*)\\)\\(org.apache.felix.dependencymanager.aspect=([0-9]*)\\)\\)\\)");
    private final Object m_lock = new Object();
    private ServiceTracker m_tracker;
    private BundleContext m_context;
    private final Map m_sidToListenersMap = new HashMap();
    protected final Map m_listenerToObjectClassMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(BundleContext context) {
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_context != null) {
                throw new IllegalStateException("Filter already open.");
            }
            try {
                this.m_tracker = new ServiceTracker(context, context.createFilter("(objectClass=*)"), (ServiceTrackerCustomizer)this);
            }
            catch (InvalidSyntaxException e) {
                throw new Error();
            }
            this.m_context = context;
        }
        this.m_tracker.open(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ServiceTracker tracker;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_context == null) {
                throw new IllegalStateException("Filter already closed.");
            }
            tracker = this.m_tracker;
            this.m_tracker = null;
            this.m_context = null;
        }
        tracker.close();
    }

    public boolean isApplicable(String clazz, String filter) {
        return this.getFilterData(clazz, filter) != null;
    }

    private AbstractFactoryFilterIndex.FilterData getFilterData(String clazz, String filter) {
        String sid2;
        String sid;
        Matcher matcher;
        AbstractFactoryFilterIndex.FilterData resultData = null;
        if (filter != null && (matcher = PATTERN.matcher(filter)).matches() && (sid = matcher.group(2)).equals(sid2 = matcher.group(3))) {
            resultData = new AbstractFactoryFilterIndex.FilterData();
            resultData.serviceId = Long.parseLong(sid);
        }
        return resultData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllServiceReferences(String clazz, String filter) {
        AbstractFactoryFilterIndex.FilterData data;
        ArrayList<ServiceReference> result = new ArrayList<ServiceReference>();
        Matcher matcher = PATTERN.matcher(filter);
        if (matcher.matches() && (data = this.getFilterData(clazz, filter)) != null) {
            SortedSet list = null;
            Map map = this.m_sidToServiceReferencesMap;
            synchronized (map) {
                list = (SortedSet)this.m_sidToServiceReferencesMap.get(data.serviceId);
                if (list != null) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        String objectClass;
                        ServiceReference ref = (ServiceReference)iterator.next();
                        if (!this.referenceMatchesObjectClass(ref, objectClass = matcher.group(1))) continue;
                        result.add(ref);
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceChanged(ServiceEvent event) {
        ServiceReference reference = event.getServiceReference();
        Long sid = ServiceUtil.getServiceIdObject(reference);
        ArrayList<ServiceListener> notificationList = new ArrayList<ServiceListener>();
        Map map = this.m_sidToListenersMap;
        synchronized (map) {
            ArrayList list = (ArrayList)this.m_sidToListenersMap.get(sid);
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ServiceListener listener = (ServiceListener)iterator.next();
                    String objectClass = (String)this.m_listenerToObjectClassMap.get(listener);
                    if (!this.referenceMatchesObjectClass(reference, objectClass)) continue;
                    notificationList.add(listener);
                }
            }
        }
        Iterator iterator = notificationList.iterator();
        while (iterator.hasNext()) {
            ServiceListener listener = (ServiceListener)iterator.next();
            listener.serviceChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceListener(ServiceListener listener, String filter) {
        AbstractFactoryFilterIndex.FilterData data = this.getFilterData(null, filter);
        if (data != null) {
            Long sidObject = data.serviceId;
            Map map = this.m_sidToListenersMap;
            synchronized (map) {
                ArrayList<ServiceListener> listeners = (ArrayList<ServiceListener>)this.m_sidToListenersMap.get(sidObject);
                if (listeners == null) {
                    listeners = new ArrayList<ServiceListener>();
                    this.m_sidToListenersMap.put(sidObject, listeners);
                }
                listeners.add(listener);
                this.m_listenerToFilterMap.put(listener, filter);
                Matcher matcher = PATTERN.matcher(filter);
                if (!matcher.matches()) {
                    throw new IllegalArgumentException("Filter string does not match index pattern");
                }
                String objectClass = matcher.group(1);
                this.m_listenerToObjectClassMap.put(listener, objectClass);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceListener(ServiceListener listener) {
        Map map = this.m_sidToListenersMap;
        synchronized (map) {
            Long sidObject;
            List listeners;
            AbstractFactoryFilterIndex.FilterData data;
            this.m_listenerToObjectClassMap.remove(listener);
            String filter = (String)this.m_listenerToFilterMap.remove(listener);
            if (filter != null && (data = this.getFilterData(null, filter)) != null && (listeners = (List)this.m_sidToListenersMap.get(sidObject = Long.valueOf(data.serviceId))) != null) {
                listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference reference) {
        BundleContext context;
        Object object = this.m_lock;
        synchronized (object) {
            context = this.m_context;
        }
        if (context != null) {
            return context.getService(reference);
        }
        throw new IllegalStateException("No valid bundle context.");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("AdapterFilterIndex[");
        sb.append("S2L: " + this.m_sidToListenersMap.size());
        sb.append(", S2SR: " + this.m_sidToServiceReferencesMap.size());
        sb.append(", L2F: " + this.m_listenerToFilterMap.size());
        sb.append("]");
        return sb.toString();
    }
}

