/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.diagnostics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.ComponentDeclaration;
import org.apache.felix.dm.ComponentDependencyDeclaration;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.diagnostics.CircularDependency;
import org.apache.felix.dm.diagnostics.ComponentNode;
import org.apache.felix.dm.diagnostics.DependencyGraphNode;
import org.apache.felix.dm.diagnostics.DependencyNode;
import org.apache.felix.dm.diagnostics.MissingDependency;
import org.osgi.framework.Bundle;

public class DependencyGraph {
    private static final String SERVICE = "service";
    private Map<ComponentDeclaration, DependencyGraphNode> m_componentToNode = new HashMap<ComponentDeclaration, DependencyGraphNode>();
    private Map<ComponentDependencyDeclaration, DependencyGraphNode> m_dependencyToNode = new HashMap<ComponentDependencyDeclaration, DependencyGraphNode>();
    private List<List<DependencyGraphNode>> m_circularDependencies = new ArrayList<List<DependencyGraphNode>>();
    private Map<DependencyGraphNode, DependencyGraphNode> m_parent = new HashMap<DependencyGraphNode, DependencyGraphNode>();
    private ComponentState m_componentState = ComponentState.ALL;
    private DependencyState m_dependencyState = DependencyState.ALL;

    private DependencyGraph(ComponentState componentState, DependencyState dependencyState) {
        this.m_componentState = componentState;
        this.m_dependencyState = dependencyState;
        this.buildComponentNodes();
        this.buildDependecyNodesAndEdges();
    }

    private void buildComponentNodes() {
        List<DependencyManager> dependencyManagers = DependencyManager.getDependencyManagers();
        for (DependencyManager dm : dependencyManagers) {
            List<Component> components = dm.getComponents();
            for (Component c : components) {
                ComponentDeclaration cd = c.getComponentDeclaration();
                if (!this.componentMustBeAddedToGraph(cd)) continue;
                this.m_componentToNode.put(cd, new ComponentNode(cd));
            }
        }
    }

    private boolean componentMustBeAddedToGraph(ComponentDeclaration cd) {
        if (this.m_componentState == ComponentState.ALL) {
            return true;
        }
        if (this.m_componentState == ComponentState.UNREGISTERED) {
            return cd.getState() == 0;
        }
        return false;
    }

    private void buildDependecyNodesAndEdges() {
        for (DependencyGraphNode node : this.m_componentToNode.values()) {
            ComponentDependencyDeclaration[] dependencyDeclarations;
            ComponentNode componentNode = (ComponentNode)node;
            for (ComponentDependencyDeclaration cdd : dependencyDeclarations = componentNode.getComponentDeclaration().getComponentDependencies()) {
                if (!this.dependencyMustBeAddedToGraph(cdd)) continue;
                DependencyNode dependencyNode = new DependencyNode(cdd);
                this.m_dependencyToNode.put(cdd, dependencyNode);
                componentNode.addSuccessor(dependencyNode);
                List<ComponentNode> providerComponents = this.getProviderComponents(dependencyNode);
                for (ComponentNode p : providerComponents) {
                    dependencyNode.addSuccessor(p);
                }
            }
        }
    }

    private List<ComponentNode> getProviderComponents(DependencyNode dependencyNode) {
        ArrayList<ComponentNode> result = new ArrayList<ComponentNode>();
        ComponentDependencyDeclaration cdd = dependencyNode.getDependencyDeclaration();
        if (!SERVICE.equals(cdd.getType())) {
            return result;
        }
        for (DependencyGraphNode n : this.m_componentToNode.values()) {
            ComponentNode componentNode = (ComponentNode)n;
            if (!this.componentProvidesDependency(componentNode, dependencyNode)) continue;
            result.add(componentNode);
        }
        return result;
    }

    private boolean componentProvidesDependency(ComponentNode componentNode, DependencyNode dependencyNode) {
        ComponentDeclaration cd = componentNode.getComponentDeclaration();
        String dependencyName = dependencyNode.getDependencyDeclaration().getName();
        String simpleName = this.getSimpleName(dependencyName);
        Properties properties = this.parseProperties(dependencyName);
        String componentName = cd.getName();
        int cuttOff = componentName.indexOf("(");
        if (cuttOff != -1) {
            componentName = componentName.substring(0, cuttOff).trim();
        }
        for (String serviceName : componentName.split(",")) {
            if (!simpleName.equals(serviceName.trim()) || !this.doPropertiesMatch(properties, this.parseProperties(cd.getName()))) continue;
            return true;
        }
        return false;
    }

    private boolean dependencyMustBeAddedToGraph(ComponentDependencyDeclaration cdd) {
        if (this.m_dependencyState == DependencyState.ALL) {
            return true;
        }
        if (this.m_dependencyState == DependencyState.ALL_UNAVAILABLE) {
            return cdd.getState() == 2 || cdd.getState() == 0;
        }
        if (this.m_dependencyState == DependencyState.REQUIRED_UNAVAILABLE) {
            return cdd.getState() == 2;
        }
        return false;
    }

    public static DependencyGraph getGraph(ComponentState componentState, DependencyState dependencyState) {
        return new DependencyGraph(componentState, dependencyState);
    }

    public List<ComponentDeclaration> getAllComponents() {
        return new ArrayList<ComponentDeclaration>(this.m_componentToNode.keySet());
    }

    public List<ComponentDependencyDeclaration> getAllDependencies() {
        return new ArrayList<ComponentDependencyDeclaration>(this.m_dependencyToNode.keySet());
    }

    public List<ComponentDependencyDeclaration> getDependecies(ComponentDeclaration componentDeclaration) {
        ArrayList<ComponentDependencyDeclaration> result = new ArrayList<ComponentDependencyDeclaration>();
        DependencyGraphNode node = this.m_componentToNode.get(componentDeclaration);
        if (node == null) {
            return null;
        }
        for (DependencyGraphNode s : node.getSuccessors()) {
            result.add(((DependencyNode)s).getDependencyDeclaration());
        }
        return result;
    }

    public List<ComponentDeclaration> getProviders(ComponentDependencyDeclaration dependency) {
        ArrayList<ComponentDeclaration> result = new ArrayList<ComponentDeclaration>();
        DependencyGraphNode node = this.m_dependencyToNode.get(dependency);
        if (node == null) {
            return null;
        }
        for (DependencyGraphNode s : node.getSuccessors()) {
            result.add(((ComponentNode)s).getComponentDeclaration());
        }
        return result;
    }

    public List<CircularDependency> getCircularDependencies() {
        ArrayList<CircularDependency> result = new ArrayList<CircularDependency>();
        for (DependencyGraphNode dependencyGraphNode : this.m_componentToNode.values()) {
            if (!dependencyGraphNode.isUndiscovered()) continue;
            this.depthFirstSearch(dependencyGraphNode);
        }
        for (List list : this.m_circularDependencies) {
            CircularDependency circularDependency = new CircularDependency();
            for (DependencyGraphNode n : list) {
                if (!(n instanceof ComponentNode)) continue;
                circularDependency.addComponent(((ComponentNode)n).getComponentDeclaration());
            }
            result.add(circularDependency);
        }
        return result;
    }

    private void depthFirstSearch(DependencyGraphNode n) {
        n.setState(DependencyGraphNode.DependencyGraphNodeState.DISCOVERED);
        for (DependencyGraphNode s : n.getSuccessors()) {
            if (s.isUndiscovered()) {
                this.m_parent.put(s, n);
                this.depthFirstSearch(s);
                continue;
            }
            if (!s.isDiscovered()) continue;
            this.addCycle(n, s);
        }
        n.setState(DependencyGraphNode.DependencyGraphNodeState.PROCESSED);
    }

    private void addCycle(DependencyGraphNode n, DependencyGraphNode s) {
        ArrayList cycle = new ArrayList();
        Stack<DependencyGraphNode> stack = new Stack<DependencyGraphNode>();
        stack.push(s);
        DependencyGraphNode p = n;
        while (p != s) {
            stack.push(p);
            p = this.m_parent.get(p);
        }
        stack.push(s);
        while (!stack.isEmpty()) {
            cycle.add(stack.pop());
        }
        this.m_circularDependencies.add(cycle);
    }

    public List<MissingDependency> getMissingDependencies(String type) {
        ArrayList<MissingDependency> result = new ArrayList<MissingDependency>();
        ArrayList<DependencyNode> missingDependencies = new ArrayList<DependencyNode>();
        for (DependencyGraphNode dependencyGraphNode : this.m_dependencyToNode.values()) {
            DependencyNode dependencyNode = (DependencyNode)dependencyGraphNode;
            if (!dependencyNode.isUnavailable() || type != null && !dependencyNode.getDependencyDeclaration().getType().equals(type) || !dependencyNode.getSuccessors().isEmpty()) continue;
            missingDependencies.add(dependencyNode);
        }
        for (DependencyNode dependencyNode : missingDependencies) {
            for (DependencyGraphNode p : dependencyNode.getPredecessors()) {
                ComponentNode componentNode = (ComponentNode)p;
                Bundle bundle = componentNode.getComponentDeclaration().getBundleContext().getBundle();
                MissingDependency missingDependency = new MissingDependency(dependencyNode.getDependencyDeclaration().getName(), dependencyNode.getDependencyDeclaration().getType(), bundle.getSymbolicName());
                result.add(missingDependency);
            }
        }
        return result;
    }

    private String getSimpleName(String name) {
        int cuttOff = name.indexOf("(");
        if (cuttOff != -1) {
            return name.substring(0, cuttOff).trim();
        }
        return name.trim();
    }

    private Properties parseProperties(String name) {
        Properties result = new Properties();
        int cuttOff = name.indexOf("(");
        if (cuttOff != -1) {
            String[] split;
            String propsText = name.substring(cuttOff + 1, name.indexOf(")"));
            for (String prop : split = propsText.split(",")) {
                String[] kv = prop.split("=");
                if (kv.length != 2) continue;
                result.put(kv[0], kv[1]);
            }
        }
        return result;
    }

    private boolean doPropertiesMatch(Properties need, Properties provide) {
        for (Map.Entry<Object, Object> entry : need.entrySet()) {
            Object prop = provide.get(entry.getKey());
            if (prop != null && prop.equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public static enum DependencyState {
        ALL,
        ALL_UNAVAILABLE,
        REQUIRED_UNAVAILABLE;

    }

    public static enum ComponentState {
        ALL,
        UNREGISTERED;

    }
}

