/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.dispatch;

import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import org.apache.felix.eventadmin.impl.tasks.SyncThread;
import org.apache.felix.eventadmin.impl.util.LogWrapper;

public class DefaultThreadPool
extends PooledExecutor {
    public DefaultThreadPool(int poolSize, boolean syncThreads) {
        super(new LinkedQueue());
        if (syncThreads) {
            this.setThreadFactory(new ThreadFactory(){

                public Thread newThread(Runnable command) {
                    SyncThread thread = new SyncThread(command);
                    thread.setPriority(5);
                    thread.setDaemon(true);
                    return thread;
                }
            });
        } else {
            this.setThreadFactory(new ThreadFactory(){

                public Thread newThread(Runnable command) {
                    Thread thread = new Thread(command);
                    thread.setPriority(5);
                    thread.setDaemon(true);
                    return thread;
                }
            });
        }
        this.configure(poolSize);
        this.setKeepAliveTime(60000L);
        this.runWhenBlocked();
    }

    public void configure(int poolSize) {
        this.setMinimumPoolSize(poolSize);
        this.setMaximumPoolSize(poolSize + 10);
    }

    public void close() {
        this.shutdownNow();
        try {
            this.awaitTerminationAfterShutdown();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void executeTask(Runnable task) {
        try {
            super.execute(task);
        }
        catch (Throwable t) {
            LogWrapper.getLogger().log(2, "Exception: " + t, t);
        }
    }
}

