/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.eventadmin.impl.util.CacheMap;

public class LeastRecentlyUsedCacheMap
implements CacheMap {
    private final Object m_lock = new Object();
    private final int m_maxSize;
    private final Map m_cache;
    private final List m_history;

    public LeastRecentlyUsedCacheMap(int maxSize) {
        if (0 >= maxSize) {
            throw new IllegalArgumentException("Size must be positive");
        }
        this.m_maxSize = maxSize;
        this.m_cache = new HashMap(this.m_maxSize + 1 + (this.m_maxSize + 1) * 3 / 4);
        this.m_history = new ArrayList(this.m_maxSize + 1 + (this.m_maxSize + 1) / 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        Object object = this.m_lock;
        synchronized (object) {
            Object result = this.m_cache.get(key);
            if (null != result) {
                this.m_history.remove(key);
                this.m_history.add(key);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object key, Object value) {
        Object object = this.m_lock;
        synchronized (object) {
            Object result = this.m_cache.put(key, value);
            if (null != result) {
                this.m_history.remove(key);
            }
            this.m_history.add(key);
            if (this.m_maxSize < this.m_cache.size()) {
                this.m_cache.remove(this.m_history.remove(0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        Object object = this.m_lock;
        synchronized (object) {
            Object result = this.m_cache.remove(key);
            if (null != result) {
                this.m_history.remove(key);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_cache.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_cache.clear();
            this.m_history.clear();
        }
    }
}

