/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.api;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.felix.hc.api.Result;

public class ResultLog
implements Iterable<Entry> {
    private List<Entry> entries = new LinkedList<Entry>();
    private Result.Status aggregateStatus;

    public ResultLog() {
        this.aggregateStatus = Result.Status.WARN;
    }

    public ResultLog(ResultLog log) {
        this.aggregateStatus = log.aggregateStatus;
        this.entries = new ArrayList<Entry>(log.entries);
    }

    public ResultLog add(Entry e) {
        if (this.entries.isEmpty()) {
            this.aggregateStatus = Result.Status.OK;
        }
        this.entries.add(e);
        if (e.getStatus().ordinal() > this.aggregateStatus.ordinal()) {
            this.aggregateStatus = e.getStatus();
        }
        return this;
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.entries.iterator();
    }

    public Result.Status getAggregateStatus() {
        return this.aggregateStatus;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ResultLog: ");
        sb.append(this.entries.toString());
        return sb.toString();
    }

    public static class Entry {
        private final Result.Status status;
        private final String message;
        private final boolean isDebug;
        private final Exception exception;

        public Entry(Result.Status s, String message) {
            this(s, message, false, null);
        }

        public Entry(String message, boolean isDebug) {
            this(Result.Status.OK, message, isDebug, null);
        }

        public Entry(String message, boolean isDebug, Exception exception) {
            this(Result.Status.OK, message, isDebug, exception);
        }

        public Entry(Result.Status s, String message, Exception exception) {
            this(s, message, false, exception);
        }

        private Entry(Result.Status s, String message, boolean isDebug, Exception exception) {
            this.status = s;
            this.message = message;
            this.exception = exception;
            this.isDebug = isDebug;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.getLogLevel()).append(" ").append(this.message);
            if (this.exception != null) {
                builder.append(" Exception: " + this.exception.getMessage());
            }
            return builder.toString();
        }

        public Result.Status getStatus() {
            return this.status;
        }

        public String getLogLevel() {
            switch (this.status) {
                case OK: {
                    return this.isDebug ? "DEBUG" : "INFO";
                }
            }
            return this.status.toString();
        }

        public String getMessage() {
            return this.message;
        }

        public Exception getException() {
            return this.exception;
        }

        public boolean isDebug() {
            return this.isDebug;
        }
    }
}

