/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.whiteboard.internal.manager;

import java.util.HashMap;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.whiteboard.internal.manager.DefaultHttpContext;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;

public final class HttpContextManager {
    private final HashMap<String, HttpContext> idMap = new HashMap();
    private final HashMap<HttpContext, String> contextMap = new HashMap();

    private String createId(Bundle bundle, String contextId) {
        return bundle.getBundleId() + "-" + contextId;
    }

    public synchronized HttpContext getHttpContext(Bundle bundle, String contextId) {
        String id = this.createId(bundle, contextId);
        HttpContext context = this.idMap.get(id);
        if (context == null) {
            context = new DefaultHttpContext(bundle);
            this.idMap.put(id, context);
            this.contextMap.put(context, id);
            SystemLogger.debug("Added context with id [" + contextId + "]");
        } else {
            SystemLogger.debug("Reusing context with id [" + contextId + "]");
        }
        return context;
    }

    public synchronized void removeHttpContext(HttpContext context) {
        String id = this.contextMap.remove(context);
        if (id != null) {
            this.idMap.remove(id);
        }
    }

    public synchronized void addHttpContext(Bundle bundle, String contextId, HttpContext context) {
        String id = this.createId(bundle, contextId);
        this.idMap.put(id, context);
        this.contextMap.put(context, id);
    }
}

