/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.httplite.osgi;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.felix.httplite.osgi.DefaultContextImpl;
import org.apache.felix.httplite.osgi.Logger;
import org.apache.felix.httplite.osgi.ServiceRegistration;
import org.apache.felix.httplite.osgi.ServiceRegistrationHandler;
import org.apache.felix.httplite.osgi.ServiceRegistrationResolver;
import org.apache.felix.httplite.server.ResourceHandler;
import org.apache.felix.httplite.server.Server;
import org.apache.felix.httplite.server.ServletHandler;
import org.apache.felix.httplite.servlet.HttpServletRequestImpl;
import org.apache.felix.httplite.servlet.HttpServletResponseImpl;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

public class HttpServiceImpl
implements HttpService,
ServiceRegistrationResolver {
    private final Server m_server;
    private final Map m_servletMap;
    private final Logger m_logger;
    private final Bundle m_bundle;

    public HttpServiceImpl(Bundle bundle, Server server, Logger logger, Map servletMap) {
        this.m_bundle = bundle;
        this.m_logger = logger;
        this.m_server = server;
        this.m_servletMap = servletMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerResources(String alias, String name, HttpContext context) throws NamespaceException {
        this.validateAlias(alias);
        Map map = this.m_servletMap;
        synchronized (map) {
            if (this.m_servletMap.containsKey(alias)) {
                throw new NamespaceException("Alias " + alias + " has already been registered.");
            }
        }
        if (context == null) {
            this.m_servletMap.put(alias, new ServiceRegistration(alias, name, this.createDefaultHttpContext(), this.m_logger));
        } else {
            this.m_servletMap.put(alias, new ServiceRegistration(alias, name, context, this.m_logger));
        }
        this.m_logger.log(4, "Registered resource for alias: " + alias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(String alias) {
        ServiceRegistration reg = null;
        Map map = this.m_servletMap;
        synchronized (map) {
            reg = (ServiceRegistration)this.m_servletMap.get(alias);
            if (reg != null) {
                this.m_servletMap.remove(alias);
                this.m_logger.log(4, "Unregistered resource for alias: " + alias);
            }
        }
        if (reg != null && reg.isServlet() && reg.hasBeenInitialized()) {
            reg.getServlet().destroy();
        }
    }

    public HttpContext createDefaultHttpContext() {
        return new DefaultContextImpl(this.m_bundle);
    }

    public void registerServlet(String alias, Servlet servlet, Dictionary initparams, HttpContext context) throws ServletException, NamespaceException {
        this.validateAlias(alias);
        if (this.m_servletMap.containsKey(alias)) {
            throw new NamespaceException("Alias " + alias + " has already been registered.");
        }
        if (context == null) {
            this.m_servletMap.put(alias, new ServiceRegistration(alias, servlet, initparams, new DefaultContextImpl(this.m_bundle), this.m_logger));
        } else {
            this.m_servletMap.put(alias, new ServiceRegistration(alias, servlet, initparams, context, this.m_logger));
        }
        this.m_logger.log(4, "Registered servlet for alias: " + alias);
    }

    protected final void start() throws IOException {
        if (this.m_server.getState() != 0) {
            throw new IllegalStateException("Attempted to start already-running server.");
        }
        this.m_server.start(this);
    }

    protected final void stop() throws InterruptedException {
        if (this.m_server.getState() != 1) {
            throw new IllegalStateException("Attempted to stop an inactive server.");
        }
        Iterator i = this.m_servletMap.values().iterator();
        while (i.hasNext()) {
            ServiceRegistration sr = (ServiceRegistration)i.next();
            try {
                this.m_logger.log(4, "Cleaning up servlet " + sr.getAlias());
                sr.getServlet().destroy();
            }
            catch (Exception e) {
                this.m_logger.log(1, "Servlet threw exception during destroy(): " + sr.getAlias());
            }
        }
        this.m_server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ServiceRegistration getServiceRegistration(String requestPath) {
        ServiceRegistration sr = null;
        int maxLength = 0;
        Map map = this.m_servletMap;
        synchronized (map) {
            Iterator i = this.m_servletMap.keySet().iterator();
            while (i.hasNext()) {
                String alias = (String)i.next();
                if (!requestPath.startsWith(alias)) continue;
                if (sr == null) {
                    sr = (ServiceRegistration)this.m_servletMap.get(alias);
                    maxLength = alias.length();
                    continue;
                }
                if (alias.length() <= maxLength) continue;
                sr = (ServiceRegistration)this.m_servletMap.get(alias);
                maxLength = alias.length();
            }
        }
        return sr;
    }

    public ServiceRegistrationHandler getProcessor(HttpServletRequestImpl request, HttpServletResponseImpl response, String requestPath) {
        ServiceRegistration element = this.getServiceRegistration(requestPath);
        if (element != null) {
            if (element.isServlet()) {
                return new ServletHandler(request, response, element, this.m_logger);
            }
            return new ResourceHandler(request, response, element, this.m_logger);
        }
        return null;
    }

    public HttpServletRequestImpl getServletRequest(Socket socket) {
        return new HttpServletRequestImpl(socket, this, this.m_logger);
    }

    public HttpServletResponseImpl getServletResponse(OutputStream output) {
        return new HttpServletResponseImpl(output);
    }

    private void validateAlias(String alias) throws NamespaceException {
        if (alias == null) {
            throw new NamespaceException("Alias is null.");
        }
        if (alias.trim().length() == 0) {
            throw new NamespaceException("Alias is an empty string.");
        }
        if (!alias.startsWith("/")) {
            throw new NamespaceException("Alias must begin with '/'.");
        }
    }
}

