/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo;

import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.FactoryClassloader;
import org.apache.felix.ipojo.HandlerFactory;
import org.apache.felix.ipojo.HandlerManager;
import org.apache.felix.ipojo.IPojoContext;
import org.apache.felix.ipojo.IPojoFactory;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.PrimitiveTypeDescription;
import org.apache.felix.ipojo.architecture.ComponentTypeDescription;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.ParseUtils;
import org.apache.felix.ipojo.parser.PojoMetadata;
import org.apache.felix.ipojo.util.Tracker;
import org.apache.felix.ipojo.util.TrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentFactory
extends IPojoFactory
implements TrackerCustomizer {
    public static final String HANDLER_AUTO_PRIMITIVE = "org.apache.felix.ipojo.handler.auto.primitive";
    protected Tracker m_tracker;
    private FactoryClassloader m_classLoader;
    private byte[] m_clazz;
    private String m_classname;
    private PojoMetadata m_manipulation;
    private boolean m_useFactoryClassloader = false;

    public ComponentFactory(BundleContext context, byte[] clazz, Element element) throws ConfigurationException {
        this(context, element);
        this.m_clazz = clazz;
    }

    public ComponentFactory(BundleContext context, Element element) throws ConfigurationException {
        super(context, element);
        this.check(element);
    }

    public void setUseFactoryClassloader(boolean use) {
        this.m_useFactoryClassloader = use;
    }

    @Override
    public ComponentTypeDescription getComponentTypeDescription() {
        return new PrimitiveTypeDescription(this);
    }

    public void check(Element element) throws ConfigurationException {
        this.m_classname = element.getAttribute("classname");
        if (this.m_classname == null) {
            throw new ConfigurationException("A component needs a class name : " + element);
        }
        this.m_manipulation = new PojoMetadata(this.m_componentMetadata);
    }

    @Override
    public String getClassName() {
        return this.m_classname;
    }

    @Override
    public ComponentInstance createInstance(Dictionary config, IPojoContext context, HandlerManager[] handlers) throws ConfigurationException {
        InstanceManager instance = new InstanceManager(this, context, handlers);
        try {
            instance.configure(this.m_componentMetadata, config);
            instance.start();
            return instance;
        }
        catch (ConfigurationException e) {
            instance.stop();
            throw e;
        }
        catch (Throwable e) {
            instance.stop();
            this.m_logger.log(1, e.getMessage(), e);
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    public synchronized Class<? extends Object> defineClass(String name, byte[] clazz, ProtectionDomain domain) {
        if (!this.m_useFactoryClassloader) {
            this.m_logger.log(2, "A class definition was required even without the factory classloader enabled");
        }
        if (this.m_classLoader == null) {
            this.m_classLoader = new FactoryClassloader(this);
        }
        return this.m_classLoader.defineClass(name, clazz, domain);
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        if (this.m_useFactoryClassloader && this.m_clazz != null && this.m_classname.equals(className)) {
            return this.defineClass(className, this.m_clazz, null);
        }
        return this.m_context.getBundle().loadClass(className);
    }

    @Override
    public void starting() {
        if (this.m_tracker == null && this.m_requiredHandlers.size() != 0) {
            try {
                String filter = "(&(handler.type=primitive)(factory.state=1))";
                this.m_tracker = new Tracker(this.m_context, this.m_context.createFilter(filter), (TrackerCustomizer)this);
                this.m_tracker.open();
            }
            catch (InvalidSyntaxException e) {
                this.m_logger.log(1, "A factory filter is not valid: " + e.getMessage());
                this.stop();
            }
        }
    }

    @Override
    public void stopping() {
        if (this.m_tracker != null) {
            this.m_tracker.close();
            this.m_tracker = null;
        }
    }

    @Override
    public String getFactoryName() {
        String name = this.m_componentMetadata.getAttribute("name");
        if (name == null) {
            name = this.m_componentMetadata.getAttribute("classname");
        }
        return name;
    }

    @Override
    public List<IPojoFactory.RequiredHandler> getRequiredHandlerList() {
        String v;
        String imm;
        Element[] elems;
        ArrayList<IPojoFactory.RequiredHandler> list = new ArrayList<IPojoFactory.RequiredHandler>();
        for (Element current : elems = this.m_componentMetadata.getElements()) {
            IPojoFactory.RequiredHandler req;
            if ("manipulation".equals(current.getName()) || list.contains(req = new IPojoFactory.RequiredHandler(this, current.getName(), current.getNameSpace()))) continue;
            list.add(req);
        }
        String arch = this.m_componentMetadata.getAttribute("architecture");
        if (arch == null || arch.equalsIgnoreCase("true")) {
            list.add(new IPojoFactory.RequiredHandler(this, "architecture", null));
        }
        if (this.m_componentMetadata.getElements("provides") == null && (imm = this.m_componentMetadata.getAttribute("immediate")) == null) {
            this.getLogger().log(3, "The component type " + this.getFactoryName() + " becomes immediate");
            this.m_componentMetadata.addAttribute(new Attribute("immediate", "true"));
        }
        IPojoFactory.RequiredHandler reqCallback = new IPojoFactory.RequiredHandler(this, "callback", null);
        String imm2 = this.m_componentMetadata.getAttribute("immediate");
        if (!list.contains(reqCallback) && imm2 != null && imm2.equalsIgnoreCase("true")) {
            list.add(reqCallback);
        }
        if ((v = System.getProperty(HANDLER_AUTO_PRIMITIVE)) != null && v.length() != 0) {
            String[] hs;
            for (String h1 : hs = ParseUtils.split(v, ",")) {
                String h = h1.trim();
                String[] segments = ParseUtils.split(h, ":");
                IPojoFactory.RequiredHandler rq = null;
                if (segments.length == 2) {
                    rq = new IPojoFactory.RequiredHandler(this, segments[1], segments[0]);
                } else if (segments.length == 1) {
                    rq = new IPojoFactory.RequiredHandler(this, segments[1], null);
                }
                if (rq == null || list.contains(rq)) continue;
                list.add(rq);
            }
        }
        return list;
    }

    @Override
    public synchronized boolean addingService(ServiceReference reference) {
        for (int i = 0; i < this.m_requiredHandlers.size(); ++i) {
            IPojoFactory.RequiredHandler req = (IPojoFactory.RequiredHandler)this.m_requiredHandlers.get(i);
            if (req.getReference() != null || !this.match(req, reference)) continue;
            int oldP = req.getLevel();
            req.setReference((ServiceReference<? extends HandlerFactory>)reference);
            if (oldP != req.getLevel()) {
                Collections.sort(this.m_requiredHandlers);
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized void addedService(ServiceReference reference) {
        if (this.m_state == 0) {
            this.computeFactoryState();
        }
    }

    @Override
    public synchronized void removedService(ServiceReference reference, Object service) {
        for (IPojoFactory.RequiredHandler m_requiredHandler : this.m_requiredHandlers) {
            IPojoFactory.RequiredHandler req = m_requiredHandler;
            if (!reference.equals(req.getReference())) continue;
            req.unRef();
            this.computeFactoryState();
            return;
        }
    }

    @Override
    public void modifiedService(ServiceReference reference, Object service) {
    }

    public PojoMetadata getPojoMetadata() {
        return this.m_manipulation;
    }

    @Override
    public String getVersion() {
        return this.m_version;
    }

    public ClassLoader getBundleClassLoader() {
        return this.m_classLoader;
    }
}

