/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.ConfigurationTracker;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.FactoryStateListener;
import org.apache.felix.ipojo.Handler;
import org.apache.felix.ipojo.HandlerFactory;
import org.apache.felix.ipojo.HandlerManager;
import org.apache.felix.ipojo.IPojoContext;
import org.apache.felix.ipojo.MissingHandlerException;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.ServiceContext;
import org.apache.felix.ipojo.UnacceptableConfiguration;
import org.apache.felix.ipojo.architecture.ComponentTypeDescription;
import org.apache.felix.ipojo.architecture.PropertyDescription;
import org.apache.felix.ipojo.extender.internal.Extender;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.util.Logger;
import org.apache.felix.ipojo.util.SecurityHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IPojoFactory
implements Factory {
    protected static final List<String> INSTANCE_NAME = Collections.synchronizedList(new ArrayList());
    protected ComponentTypeDescription m_componentDesc;
    protected final Map<String, ComponentInstance> m_componentInstances = new ConcurrentHashMap<String, ComponentInstance>();
    protected final Element m_componentMetadata;
    protected final BundleContext m_context;
    protected String m_factoryName;
    protected final List<RequiredHandler> m_requiredHandlers = new ArrayList<RequiredHandler>();
    protected List<FactoryStateListener> m_listeners = new ArrayList<FactoryStateListener>(1);
    protected final Logger m_logger;
    protected final boolean m_isPublic;
    protected final String m_version;
    protected ServiceRegistration m_sr;
    protected int m_state = 0;
    private boolean m_described;
    private NameGenerator m_generator = new UniquenessNameGenerator(new SwitchNameGenerator());

    public IPojoFactory(BundleContext context, Element metadata) throws ConfigurationException {
        this.m_context = context;
        this.m_componentMetadata = metadata;
        this.m_factoryName = this.getFactoryName();
        String fac = metadata.getAttribute("public");
        this.m_isPublic = fac == null || !fac.equalsIgnoreCase("false");
        this.m_logger = new Logger(this.m_context, this.m_factoryName);
        String version = metadata.getAttribute("version");
        this.m_version = "bundle".equalsIgnoreCase(version) ? (String)this.m_context.getBundle().getHeaders().get("Bundle-Version") : version;
        this.m_requiredHandlers.addAll(this.getRequiredHandlerList());
        this.m_logger.log(3, "New factory created : " + this.m_factoryName);
    }

    public ComponentTypeDescription getComponentTypeDescription() {
        return new ComponentTypeDescription(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFactoryStateListener(FactoryStateListener listener) {
        IPojoFactory iPojoFactory = this;
        synchronized (iPojoFactory) {
            this.m_listeners.add(listener);
        }
    }

    public Logger getLogger() {
        return this.m_logger;
    }

    public abstract String getFactoryName();

    public abstract List<RequiredHandler> getRequiredHandlerList();

    public abstract ComponentInstance createInstance(Dictionary var1, IPojoContext var2, HandlerManager[] var3) throws ConfigurationException;

    @Override
    public ComponentInstance createComponentInstance(Dictionary configuration) throws UnacceptableConfiguration, MissingHandlerException, ConfigurationException {
        return this.createComponentInstance(configuration, null);
    }

    @Override
    public synchronized ComponentInstance createComponentInstance(Dictionary configuration, ServiceContext serviceContext) throws UnacceptableConfiguration, MissingHandlerException, ConfigurationException {
        String name;
        if (configuration == null) {
            configuration = new Properties();
        }
        IPojoContext context = serviceContext == null ? new IPojoContext(this.m_context) : new IPojoContext(this.m_context, serviceContext);
        try {
            this.checkAcceptability(configuration);
        }
        catch (UnacceptableConfiguration e) {
            this.m_logger.log(1, "The configuration is not acceptable : " + e.getMessage());
            throw new UnacceptableConfiguration("The configuration " + configuration + " is not acceptable for " + this.m_factoryName, e);
        }
        if (configuration.get("instance.name") == null && configuration.get("name") == null) {
            name = null;
        } else {
            name = (String)configuration.get("instance.name");
            if (name == null) {
                name = (String)configuration.get("name");
                this.getLogger().log(2, "The 'name' (" + name + ") attribute, used as the instance name, is deprecated, please use the 'instance.name' attribute");
            }
        }
        String version = (String)configuration.get("factory.version");
        if (version == null) {
            version = this.m_version;
        }
        name = this.m_generator.generate(name, version);
        configuration.put("instance.name", name);
        HandlerManager[] handlers = new HandlerManager[this.m_requiredHandlers.size()];
        for (int i = 0; i < handlers.length; ++i) {
            handlers[i] = this.getHandler(this.m_requiredHandlers.get(i), serviceContext);
        }
        try {
            ComponentInstance instance = this.createInstance(configuration, context, handlers);
            this.m_componentInstances.put(name, instance);
            this.m_logger.log(3, "Instance " + name + " from factory " + this.m_factoryName + " created");
            ConfigurationTracker.get().instanceCreated(instance);
            return instance;
        }
        catch (ConfigurationException e) {
            INSTANCE_NAME.remove(name);
            this.m_logger.log(1, e.getMessage());
            throw new ConfigurationException(e.getMessage(), e, this.m_factoryName);
        }
    }

    @Override
    public BundleContext getBundleContext() {
        return this.m_context;
    }

    @Override
    public abstract String getClassName();

    @Override
    public synchronized ComponentTypeDescription getComponentDescription() {
        return this.m_componentDesc;
    }

    @Override
    public synchronized Element getDescription() {
        if (this.m_componentDesc == null) {
            return new Element("No description available for " + this.m_factoryName, "");
        }
        return this.m_componentDesc.getDescription();
    }

    @Override
    public Element getComponentMetadata() {
        return this.m_componentMetadata;
    }

    @Override
    public List<String> getMissingHandlers() {
        ArrayList<String> list = new ArrayList<String>();
        for (RequiredHandler req : this.m_requiredHandlers) {
            if (req.getReference() != null) continue;
            list.add(req.getFullName());
        }
        return list;
    }

    @Override
    public String getName() {
        return this.m_factoryName;
    }

    @Override
    public List<String> getRequiredHandlers() {
        ArrayList<String> list = new ArrayList<String>();
        for (RequiredHandler req : this.m_requiredHandlers) {
            list.add(req.getFullName());
        }
        return list;
    }

    @Override
    public synchronized int getState() {
        return this.m_state;
    }

    public ComponentInstance getInstanceByName(String name) {
        return this.m_componentInstances.get(name);
    }

    @Override
    public boolean isAcceptable(Dictionary conf) {
        try {
            this.checkAcceptability(conf);
        }
        catch (MissingHandlerException e) {
            return false;
        }
        catch (UnacceptableConfiguration e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAcceptability(Dictionary<String, ?> conf) throws UnacceptableConfiguration, MissingHandlerException {
        PropertyDescription[] props;
        IPojoFactory iPojoFactory = this;
        synchronized (iPojoFactory) {
            if (this.m_state == 0) {
                throw new MissingHandlerException(this.getMissingHandlers());
            }
            props = this.m_componentDesc.getProperties();
        }
        for (PropertyDescription prop : props) {
            if (prop.isImmutable() && conf.get(prop.getName()) != null) {
                throw new UnacceptableConfiguration("The property " + prop + " cannot be overridden : immutable " + "property");
            }
            if (!prop.isMandatory() || prop.getValue() != null || conf.get(prop.getName()) != null) continue;
            throw new UnacceptableConfiguration("The mandatory property " + prop.getName() + " is missing");
        }
    }

    @Override
    public synchronized void reconfigure(Dictionary properties) throws UnacceptableConfiguration, MissingHandlerException {
        ComponentInstance instance;
        if (properties == null || properties.get("instance.name") == null && properties.get("name") == null) {
            throw new UnacceptableConfiguration("The configuration does not contains the \"instance.name\" property");
        }
        String name = (String)properties.get("instance.name");
        if (name == null) {
            name = (String)properties.get("name");
        }
        if ((instance = this.m_componentInstances.get(name)) == null) {
            return;
        }
        this.checkAcceptability(properties);
        instance.reconfigure(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFactoryStateListener(FactoryStateListener listener) {
        IPojoFactory iPojoFactory = this;
        synchronized (iPojoFactory) {
            this.m_listeners.remove(listener);
        }
    }

    public abstract void stopping();

    public synchronized void stop() {
        if (this.m_sr != null) {
            this.m_sr.unregister();
            this.m_sr = null;
        }
        ConfigurationTracker.get().unregisterFactory(this);
        this.stopping();
        int oldState = this.m_state;
        this.m_state = 0;
        Set<String> col = this.m_componentInstances.keySet();
        Iterator<String> it = col.iterator();
        ComponentInstance[] instances = new ComponentInstance[col.size()];
        int index = 0;
        while (it.hasNext()) {
            instances[index] = this.m_componentInstances.get(it.next());
            ++index;
        }
        if (oldState == 1) {
            for (FactoryStateListener listener : this.m_listeners) {
                listener.stateChanged(this, 0);
            }
        }
        for (ComponentInstance instance : instances) {
            if (instance.getState() == -1) continue;
            instance.dispose();
        }
        for (RequiredHandler req : this.m_requiredHandlers) {
            req.unRef();
        }
        this.m_described = false;
        this.m_componentDesc = null;
        this.m_componentInstances.clear();
        this.m_logger.log(3, "Factory " + this.m_factoryName + " stopped");
    }

    public synchronized void dispose() {
        this.stop();
        this.m_requiredHandlers.clear();
        this.m_listeners = null;
    }

    public abstract void starting();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        IPojoFactory iPojoFactory = this;
        synchronized (iPojoFactory) {
            if (this.m_described) {
                return;
            }
        }
        this.m_componentDesc = this.getComponentTypeDescription();
        this.starting();
        iPojoFactory = this;
        synchronized (iPojoFactory) {
            this.computeFactoryState();
        }
        if (this.m_isPublic) {
            if (this.m_componentDesc == null) {
                this.m_logger.log(1, "Unexpected state, the description of " + this.m_factoryName + "  is null");
                return;
            }
            BundleContext bc = SecurityHelper.selectContextToRegisterServices(this.m_componentDesc.getFactoryInterfacesToPublish(), this.m_context, this.getIPOJOBundleContext());
            if (SecurityHelper.canRegisterService(bc)) {
                this.m_sr = bc.registerService(this.m_componentDesc.getFactoryInterfacesToPublish(), (Object)this, this.m_componentDesc.getPropertiesToPublish());
                this.m_logger.log(3, "Factory " + this.m_factoryName + " started");
            } else {
                this.m_logger.log(1, "Cannot register the Factory service with the bundle context of the bundle " + bc.getBundle().getBundleId() + " - the bundle is in the state " + bc.getBundle().getState());
            }
        }
    }

    public void restart() {
        this.m_requiredHandlers.clear();
        this.m_requiredHandlers.addAll(this.getRequiredHandlerList());
    }

    protected final BundleContext getIPOJOBundleContext() {
        return Extender.getIPOJOBundleContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(String name, Dictionary properties) throws org.osgi.service.cm.ConfigurationException {
        ComponentInstance instance;
        IPojoFactory iPojoFactory = this;
        synchronized (iPojoFactory) {
            instance = this.m_componentInstances.get(name);
        }
        if (instance == null) {
            try {
                properties.put("instance.name", name);
                this.createComponentInstance(properties);
            }
            catch (UnacceptableConfiguration e) {
                this.m_logger.log(1, "The configuration is not acceptable : " + e.getMessage());
                throw new org.osgi.service.cm.ConfigurationException(properties.toString(), e.getMessage(), e);
            }
            catch (MissingHandlerException e) {
                this.m_logger.log(1, "Handler not available : " + e.getMessage());
                throw new org.osgi.service.cm.ConfigurationException(properties.toString(), e.getMessage(), e);
            }
            catch (ConfigurationException e) {
                this.m_logger.log(1, "The Component Type metadata are not correct : " + e.getMessage());
                throw new org.osgi.service.cm.ConfigurationException(properties.toString(), e.getMessage(), e);
            }
        }
        try {
            properties.put("instance.name", name);
            this.reconfigure(properties);
        }
        catch (UnacceptableConfiguration e) {
            this.m_logger.log(1, "The configuration is not acceptable : " + e.getMessage());
            throw new org.osgi.service.cm.ConfigurationException(properties.toString(), e.getMessage(), e);
        }
        catch (MissingHandlerException e) {
            this.m_logger.log(1, "The factory is not valid, at least one handler is missing : " + e.getMessage());
            throw new org.osgi.service.cm.ConfigurationException(properties.toString(), e.getMessage(), e);
        }
    }

    public synchronized void deleted(String name) {
        INSTANCE_NAME.remove(name);
        ComponentInstance instance = this.m_componentInstances.remove(name);
        if (instance != null) {
            instance.dispose();
        }
    }

    public void disposed(ComponentInstance instance) {
        String name = instance.getInstanceName();
        this.m_componentInstances.remove(name);
        INSTANCE_NAME.remove(name);
    }

    protected void computeDescription() {
        for (RequiredHandler req : this.m_requiredHandlers) {
            if (this.getHandler(req, null) == null) {
                this.m_logger.log(1, "Cannot extract handler object from " + this.m_factoryName + " " + req.getFullName());
                continue;
            }
            Handler handler = this.getHandler(req, null).getHandler();
            try {
                handler.setFactory(this);
                handler.initializeComponentFactory(this.m_componentDesc, this.m_componentMetadata);
                ((Pojo)((Object)handler)).getComponentInstance().dispose();
            }
            catch (ConfigurationException e) {
                ((Pojo)((Object)handler)).getComponentInstance().dispose();
                this.m_logger.log(1, e.getMessage());
                this.stop();
                throw new IllegalStateException(e);
            }
        }
    }

    protected void computeFactoryState() {
        boolean isValid = true;
        for (RequiredHandler req : this.m_requiredHandlers) {
            if (req.getReference() != null) continue;
            isValid = false;
            break;
        }
        if (isValid) {
            if (this.m_state == 0) {
                if (!this.m_described) {
                    this.computeDescription();
                    this.m_described = true;
                }
                this.m_state = 1;
                if (this.m_sr != null && SecurityHelper.canUpdateService(this.m_sr)) {
                    this.m_sr.setProperties(this.m_componentDesc.getPropertiesToPublish());
                }
                ConfigurationTracker.get().registerFactory(this);
                for (FactoryStateListener listener : this.m_listeners) {
                    listener.stateChanged(this, 1);
                }
            }
        } else if (this.m_state == 1) {
            this.m_state = 0;
            ConfigurationTracker.get().unregisterFactory(this);
            for (FactoryStateListener listener : this.m_listeners) {
                listener.stateChanged(this, 0);
            }
            HashSet<String> keys = new HashSet<String>(this.m_componentInstances.keySet());
            for (String key : keys) {
                ComponentInstance instance = this.m_componentInstances.get(key);
                if (instance.getState() != -1) {
                    instance.dispose();
                }
                INSTANCE_NAME.remove(instance.getInstanceName());
            }
            this.m_componentInstances.clear();
            if (SecurityHelper.canUpdateService(this.m_sr)) {
                this.m_sr.setProperties(this.m_componentDesc.getPropertiesToPublish());
            }
        }
    }

    protected boolean match(RequiredHandler req, ServiceReference<?> ref) {
        String name = (String)ref.getProperty("handler.name");
        String namespace = (String)ref.getProperty("handler.namespace");
        if ("org.apache.felix.ipojo".equals(namespace)) {
            return name.equalsIgnoreCase(req.getName()) && req.getNamespace() == null;
        }
        return name.equalsIgnoreCase(req.getName()) && namespace.equalsIgnoreCase(req.getNamespace());
    }

    protected HandlerManager getHandler(RequiredHandler req, ServiceContext context) {
        try {
            return (HandlerManager)req.getFactory().createComponentInstance(null, context);
        }
        catch (MissingHandlerException e) {
            this.m_logger.log(1, "The creation of the handler " + req.getFullName() + " has failed: " + e.getMessage());
            this.stop();
            return null;
        }
        catch (UnacceptableConfiguration e) {
            this.m_logger.log(1, "The creation of the handler " + req.getFullName() + " has failed (UnacceptableConfiguration): " + e.getMessage());
            this.stop();
            return null;
        }
        catch (ConfigurationException e) {
            this.m_logger.log(1, "The configuration of the handler " + req.getFullName() + " has failed (ConfigurationException): " + e.getMessage());
            this.stop();
            return null;
        }
    }

    private class SwitchNameGenerator
    implements NameGenerator {
        private NameGenerator computed;
        private NameGenerator userProvided;

        private SwitchNameGenerator() {
            this.computed = new DefaultNameGenerator();
            this.userProvided = new UserProvidedNameGenerator();
        }

        public String generate(String name, String version) throws UnacceptableConfiguration {
            if (name == null) {
                return this.computed.generate(null, null);
            }
            return this.userProvided.generate(name, version);
        }
    }

    private class UniquenessNameGenerator
    implements NameGenerator {
        private NameGenerator delegate;

        private UniquenessNameGenerator(NameGenerator delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String generate(String name, String version) throws UnacceptableConfiguration {
            String name2 = this.delegate.generate(name, version);
            List<String> list = INSTANCE_NAME;
            synchronized (list) {
                if (INSTANCE_NAME.contains(name2) && version != null) {
                    if (INSTANCE_NAME.contains(name2 = name2 + "-" + version)) {
                        IPojoFactory.this.m_logger.log(1, "The configuration is not acceptable : Name already used");
                        throw new UnacceptableConfiguration(IPojoFactory.this.getFactoryName() + " : Name already used : " + name2);
                    }
                } else if (INSTANCE_NAME.contains(name2)) {
                    IPojoFactory.this.m_logger.log(1, "The configuration is not acceptable : Name already used");
                    throw new UnacceptableConfiguration(IPojoFactory.this.getFactoryName() + " : Name already used : " + name2);
                }
                INSTANCE_NAME.add(name2);
            }
            return name2;
        }
    }

    private static class UserProvidedNameGenerator
    implements NameGenerator {
        private UserProvidedNameGenerator() {
        }

        public String generate(String name, String version) throws UnacceptableConfiguration {
            return name;
        }
    }

    private class DefaultNameGenerator
    implements NameGenerator {
        private long m_nextId = 0L;

        private DefaultNameGenerator() {
        }

        public synchronized String generate(String name, String version) throws UnacceptableConfiguration {
            return IPojoFactory.this.getFactoryName() + "-" + this.m_nextId++;
        }
    }

    private static interface NameGenerator {
        public String generate(String var1, String var2) throws UnacceptableConfiguration;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RequiredHandler
    implements Comparable {
        private HandlerFactory m_factory;
        private final String m_name;
        private int m_level = Integer.MAX_VALUE;
        private final String m_namespace;
        private ServiceReference<? extends HandlerFactory> m_reference;

        public RequiredHandler(String name, String namespace) {
            this.m_name = name;
            this.m_namespace = namespace;
        }

        public boolean equals(Object object) {
            if (object instanceof RequiredHandler) {
                RequiredHandler req = (RequiredHandler)object;
                if (this.m_namespace == null) {
                    return req.m_name.equalsIgnoreCase(this.m_name) && req.m_namespace == null;
                }
                return req.m_name.equalsIgnoreCase(this.m_name) && this.m_namespace.equalsIgnoreCase(req.m_namespace);
            }
            return false;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public HandlerFactory getFactory() {
            if (this.m_reference == null) {
                return null;
            }
            if (this.m_factory == null) {
                this.m_factory = (HandlerFactory)IPojoFactory.this.m_context.getService(this.getReference());
            }
            return this.m_factory;
        }

        public String getFullName() {
            if (this.m_namespace == null) {
                return "org.apache.felix.ipojo:" + this.m_name;
            }
            return this.m_namespace + ":" + this.m_name;
        }

        public String getName() {
            return this.m_name;
        }

        public String getNamespace() {
            return this.m_namespace;
        }

        public ServiceReference<? extends HandlerFactory> getReference() {
            return this.m_reference;
        }

        public int getLevel() {
            return this.m_level;
        }

        public void unRef() {
            if (this.m_reference != null) {
                this.m_factory = null;
                this.m_reference = null;
            }
        }

        public void setReference(ServiceReference<? extends HandlerFactory> ref) {
            this.m_reference = ref;
            Integer level = (Integer)this.m_reference.getProperty("handler.level");
            if (level != null) {
                this.m_level = level;
            }
        }

        public int compareTo(Object object) {
            if (object instanceof RequiredHandler) {
                RequiredHandler req = (RequiredHandler)object;
                if (this.m_level == req.m_level) {
                    return 0;
                }
                if (this.m_level < req.m_level) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    }
}

