/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.dependency.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.felix.ipojo.dependency.impl.ComparatorBasedServiceRankingInterceptor;
import org.apache.felix.ipojo.dependency.impl.DependencyProperties;
import org.apache.felix.ipojo.dependency.impl.EmptyBasedServiceRankingInterceptor;
import org.apache.felix.ipojo.dependency.impl.FilterBasedServiceTrackingInterceptor;
import org.apache.felix.ipojo.dependency.impl.ServiceReferenceUtils;
import org.apache.felix.ipojo.dependency.impl.TransformedServiceReferenceImpl;
import org.apache.felix.ipojo.dependency.interceptors.ServiceRankingInterceptor;
import org.apache.felix.ipojo.dependency.interceptors.ServiceTrackingInterceptor;
import org.apache.felix.ipojo.dependency.interceptors.TransformedServiceReference;
import org.apache.felix.ipojo.util.DependencyModel;
import org.apache.felix.ipojo.util.ServiceReferenceRankingComparator;
import org.apache.felix.ipojo.util.Tracker;
import org.apache.felix.ipojo.util.TrackerCustomizer;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceReferenceManager
implements TrackerCustomizer {
    private final DependencyModel m_dependency;
    private final Map<ServiceReference, TransformedServiceReference> m_matchingReferences = new LinkedHashMap<ServiceReference, TransformedServiceReference>();
    private Comparator<ServiceReference> m_comparator;
    private Filter m_filter;
    private List<? extends ServiceReference> m_selectedReferences = new ArrayList<ServiceReference>();
    private ServiceRankingInterceptor m_rankingInterceptor;
    private Tracker m_rankingInterceptorTracker;
    private Tracker m_trackingInterceptorTracker;
    private LinkedList<ServiceTrackingInterceptor> m_trackingInterceptors = new LinkedList();
    private List<ServiceReference> serviceReferencesList;

    public ServiceReferenceManager(DependencyModel dep, Filter filter, Comparator<ServiceReference> comparator) {
        this.m_dependency = dep;
        this.m_filter = filter;
        if (this.m_filter != null) {
            this.m_trackingInterceptors.addLast(new FilterBasedServiceTrackingInterceptor(this.m_filter));
        }
        if (comparator != null) {
            this.m_comparator = comparator;
            this.m_rankingInterceptor = new ComparatorBasedServiceRankingInterceptor(comparator);
        } else {
            this.m_rankingInterceptor = new EmptyBasedServiceRankingInterceptor();
        }
    }

    public void open() {
        this.m_trackingInterceptorTracker = new Tracker(this.m_dependency.getBundleContext(), ServiceTrackingInterceptor.class.getName(), new TrackerCustomizer(){

            public boolean addingService(ServiceReference reference) {
                return DependencyProperties.match(reference, ServiceReferenceManager.this.m_dependency);
            }

            public void addedService(ServiceReference reference) {
                ServiceTrackingInterceptor interceptor = (ServiceTrackingInterceptor)ServiceReferenceManager.this.m_trackingInterceptorTracker.getService(reference);
                if (interceptor != null) {
                    ServiceReferenceManager.this.addTrackingInterceptor(interceptor);
                } else {
                    ServiceReferenceManager.this.m_dependency.getComponentInstance().getFactory().getLogger().log(1, "Cannot retrieve the interceptor object from service reference " + reference.getProperty("service.id") + " - " + reference.getProperty("instance.name"));
                }
            }

            public void modifiedService(ServiceReference reference, Object service) {
            }

            public void removedService(ServiceReference reference, Object service) {
                if (service != null && ServiceReferenceManager.this.m_trackingInterceptors.contains(service)) {
                    ServiceReferenceManager.this.removeTrackingInterceptor((ServiceTrackingInterceptor)service);
                }
            }
        });
        this.m_trackingInterceptorTracker.open();
        this.m_rankingInterceptorTracker = new Tracker(this.m_dependency.getBundleContext(), ServiceRankingInterceptor.class.getName(), new TrackerCustomizer(){

            public boolean addingService(ServiceReference reference) {
                return DependencyProperties.match(reference, ServiceReferenceManager.this.m_dependency);
            }

            public void addedService(ServiceReference reference) {
                ServiceRankingInterceptor interceptor = (ServiceRankingInterceptor)ServiceReferenceManager.this.m_rankingInterceptorTracker.getService(reference);
                if (interceptor != null) {
                    ServiceReferenceManager.this.setRankingInterceptor(interceptor);
                } else {
                    ServiceReferenceManager.this.m_dependency.getComponentInstance().getFactory().getLogger().log(1, "Cannot retrieve the interceptor object from service reference " + reference.getProperty("service.id") + " - " + reference.getProperty("instance.name"));
                }
            }

            public void modifiedService(ServiceReference reference, Object service) {
            }

            public void removedService(ServiceReference reference, Object service) {
                if (service == ServiceReferenceManager.this.m_rankingInterceptor) {
                    ServiceReferenceManager.this.m_rankingInterceptor.close(ServiceReferenceManager.this.m_dependency);
                    ServiceReference anotherReference = ServiceReferenceManager.this.m_rankingInterceptorTracker.getServiceReference();
                    if (anotherReference != null) {
                        ServiceRankingInterceptor interceptor = (ServiceRankingInterceptor)ServiceReferenceManager.this.m_rankingInterceptorTracker.getService(anotherReference);
                        if (interceptor != null) {
                            ServiceReferenceManager.this.setRankingInterceptor(interceptor);
                        }
                    } else if (ServiceReferenceManager.this.m_comparator != null) {
                        ServiceReferenceManager.this.setComparator(ServiceReferenceManager.this.m_comparator);
                    } else {
                        ServiceReferenceManager.this.setRankingInterceptor(new EmptyBasedServiceRankingInterceptor());
                    }
                }
            }
        });
        this.m_rankingInterceptorTracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTrackingInterceptor(ServiceTrackingInterceptor interceptor) {
        ChangeSet changeset;
        try {
            this.m_dependency.acquireWriteLockIfNotHeld();
            this.m_trackingInterceptors.addFirst(interceptor);
            interceptor.open(this.m_dependency);
            changeset = this.computeChangesInMatchingServices();
        }
        finally {
            this.m_dependency.releaseWriteLockIfHeld();
        }
        this.m_dependency.onChange(changeset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTrackingInterceptor(ServiceTrackingInterceptor interceptor) {
        ChangeSet changeset;
        try {
            this.m_dependency.acquireWriteLockIfNotHeld();
            this.m_trackingInterceptors.remove(interceptor);
            interceptor.close(this.m_dependency);
            changeset = this.computeChangesInMatchingServices();
        }
        finally {
            this.m_dependency.releaseWriteLockIfHeld();
        }
        this.m_dependency.onChange(changeset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChangeSet computeChangesInMatchingServices() {
        if (this.m_dependency.getTracker() == null || this.m_dependency.getTracker().getServiceReferences() == null) {
            return new ChangeSet(Collections.<ServiceReference>emptyList(), Collections.<ServiceReference>emptyList(), Collections.<ServiceReference>emptyList(), null, null, null, null);
        }
        try {
            this.m_dependency.acquireWriteLockIfNotHeld();
            ServiceReference oldBest = this.getFirstService();
            this.m_matchingReferences.clear();
            this.serviceReferencesList = this.m_dependency.getTracker().getServiceReferencesList();
            if (this.serviceReferencesList != null) {
                for (ServiceReference reference : this.serviceReferencesList) {
                    TransformedServiceReference ref = new TransformedServiceReferenceImpl(reference);
                    if ((ref = this.accept(ref)) == null) continue;
                    this.m_matchingReferences.put(reference, ref);
                }
            }
            List<ServiceReference> beforeRanking = this.getSelectedServices();
            List<ServiceReference> allServices = this.getMatchingServices();
            List<ServiceReference> references = allServices.isEmpty() ? Collections.emptyList() : this.m_rankingInterceptor.getServiceReferences(this.m_dependency, allServices);
            RankingResult result = this.computeDifferences(beforeRanking, references);
            this.m_selectedReferences = result.selected;
            ServiceReference newFirst = this.getFirstService();
            ServiceReference modified = null;
            if (ServiceReferenceUtils.haveSameServiceId(oldBest, newFirst) && ServiceReferenceUtils.haveSameProperties(oldBest, newFirst)) {
                modified = newFirst;
            }
            ChangeSet changeSet = new ChangeSet(this.getSelectedServices(), result.departures, result.arrivals, oldBest, this.getFirstService(), null, modified);
            return changeSet;
        }
        finally {
            this.m_dependency.releaseWriteLockIfHeld();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServiceReference> getMatchingServices() {
        try {
            this.m_dependency.acquireReadLockIfNotHeld();
            ArrayList<ServiceReference> arrayList = new ArrayList<ServiceReference>(this.m_matchingReferences.values());
            return arrayList;
        }
        finally {
            this.m_dependency.releaseReadLockIfHeld();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServiceReference> getSelectedServices() {
        try {
            this.m_dependency.acquireReadLockIfNotHeld();
            ArrayList<ServiceReference> arrayList = new ArrayList<ServiceReference>(this.m_selectedReferences);
            return arrayList;
        }
        finally {
            this.m_dependency.releaseReadLockIfHeld();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReference getFirstService() {
        try {
            this.m_dependency.acquireReadLockIfNotHeld();
            if (this.m_selectedReferences.isEmpty()) {
                ServiceReference serviceReference = null;
                return serviceReference;
            }
            ServiceReference serviceReference = this.m_selectedReferences.get(0);
            return serviceReference;
        }
        finally {
            this.m_dependency.releaseReadLockIfHeld();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(ServiceReference ref) {
        try {
            this.m_dependency.acquireReadLockIfNotHeld();
            boolean bl = this.m_selectedReferences.contains(ref);
            return bl;
        }
        finally {
            this.m_dependency.releaseReadLockIfHeld();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        try {
            this.m_dependency.acquireWriteLockIfNotHeld();
            this.m_rankingInterceptor.close(this.m_dependency);
            for (ServiceTrackingInterceptor interceptor : this.m_trackingInterceptors) {
                interceptor.close(this.m_dependency);
            }
            this.m_trackingInterceptors.clear();
            this.m_matchingReferences.clear();
            this.m_selectedReferences = new ArrayList<ServiceReference>();
        }
        finally {
            this.m_dependency.releaseWriteLockIfHeld();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addingService(ServiceReference reference) {
        try {
            this.m_dependency.acquireReadLockIfNotHeld();
            boolean bl = this.m_dependency.getState() != -1 && !this.m_dependency.isFrozen();
            return bl;
        }
        finally {
            this.m_dependency.releaseReadLockIfHeld();
        }
    }

    private <S> TransformedServiceReference<S> accept(TransformedServiceReference<S> reference) {
        TransformedServiceReference<S> accumulator = reference;
        for (ServiceTrackingInterceptor interceptor : this.m_trackingInterceptors) {
            TransformedServiceReference<S> accepted = interceptor.accept(this.m_dependency, this.m_dependency.getBundleContext(), reference);
            if (accepted != null) {
                accumulator = accepted;
                continue;
            }
            this.m_dependency.getComponentInstance().getFactory().getLogger().log(3, "The service reference " + reference.getProperty("service.id") + " was rejected by " + "interceptor " + interceptor);
            return null;
        }
        return accumulator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addedService(ServiceReference reference) {
        boolean match;
        TransformedServiceReference ref = new TransformedServiceReferenceImpl(reference);
        try {
            this.m_dependency.acquireWriteLockIfNotHeld();
            ref = this.accept(ref);
            if (ref != null) {
                this.m_matchingReferences.put(reference, ref);
            }
            match = ref != null;
        }
        finally {
            this.m_dependency.releaseWriteLockIfHeld();
        }
        if (match) {
            this.onNewMatchingService(ref);
            this.m_dependency.notifyListeners(DependencyModel.DependencyEventType.ARRIVAL, ref, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNewMatchingService(TransformedServiceReference reference) {
        RankingResult result;
        ServiceReference oldFirst;
        try {
            this.m_dependency.acquireWriteLockIfNotHeld();
            oldFirst = this.getFirstService();
            result = this.applyRankingOnArrival(reference);
            this.m_selectedReferences = result.selected;
        }
        finally {
            this.m_dependency.releaseWriteLockIfHeld();
        }
        this.fireUpdate(this.getSelectedServices(), result.departures, result.arrivals, oldFirst, this.getFirstService(), null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onModificationOfAMatchingService(TransformedServiceReference reference, Object service) {
        RankingResult result;
        ServiceReference oldFirst;
        try {
            this.m_dependency.acquireWriteLockIfNotHeld();
            oldFirst = this.getFirstService();
            result = this.applyRankingOnModification(reference);
            this.m_selectedReferences = result.selected;
        }
        finally {
            this.m_dependency.releaseWriteLockIfHeld();
        }
        this.fireUpdate(this.getSelectedServices(), result.departures, result.arrivals, oldFirst, this.getFirstService(), service, reference);
    }

    private RankingResult applyRankingOnModification(ServiceReference reference) {
        List<ServiceReference> beforeRanking = this.getSelectedServices();
        List<ServiceReference> references = this.m_rankingInterceptor.onServiceModified(this.m_dependency, this.getMatchingServices(), reference);
        return this.computeDifferences(beforeRanking, references);
    }

    private void fireUpdate(List<ServiceReference> selectedServices, List<ServiceReference> departures, List<ServiceReference> arrivals, ServiceReference oldFirst, ServiceReference firstService, Object service, ServiceReference modified) {
        ChangeSet set = new ChangeSet(selectedServices, departures, arrivals, oldFirst, firstService, service, modified);
        this.m_dependency.onChange(set);
    }

    private RankingResult applyRankingOnArrival(ServiceReference ref) {
        List<ServiceReference> beforeRanking = this.getSelectedServices();
        List<ServiceReference> references = this.m_rankingInterceptor.onServiceArrival(this.m_dependency, this.getMatchingServices(), ref);
        return this.computeDifferences(beforeRanking, references);
    }

    private RankingResult applyRankingOnDeparture(ServiceReference ref) {
        List<ServiceReference> beforeRanking = this.getSelectedServices();
        List<ServiceReference> references = this.m_rankingInterceptor.onServiceDeparture(this.m_dependency, this.getMatchingServices(), ref);
        return this.computeDifferences(beforeRanking, references);
    }

    private RankingResult computeDifferences(List<ServiceReference> beforeRanking, List<ServiceReference> ranked) {
        ArrayList<ServiceReference> departures = new ArrayList<ServiceReference>();
        ArrayList<ServiceReference> arrivals = new ArrayList<ServiceReference>();
        for (ServiceReference old : beforeRanking) {
            if (ServiceReferenceUtils.containsReferenceById(ranked, old)) continue;
            departures.add(old);
        }
        for (ServiceReference newRef : ranked) {
            if (ServiceReferenceUtils.containsReferenceById(beforeRanking, newRef)) continue;
            arrivals.add(newRef);
        }
        return new RankingResult(departures, arrivals, ranked);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifiedService(ServiceReference reference, Object service) {
        DependencyModel.DependencyEventType eventType = null;
        TransformedServiceReference eventRef = null;
        try {
            this.m_dependency.acquireWriteLockIfNotHeld();
            if (this.m_matchingReferences.containsKey(reference)) {
                TransformedServiceReference initial = this.m_matchingReferences.get(reference);
                TransformedServiceReference accepted = new TransformedServiceReferenceImpl(reference);
                if ((accepted = this.accept(accepted)) == null) {
                    this.m_matchingReferences.remove(reference);
                    this.onDepartureOfAMatchingService(initial, service);
                    eventType = DependencyModel.DependencyEventType.DEPARTURE;
                    eventRef = initial;
                } else if (!ServiceReferenceUtils.haveSameProperties(initial, accepted)) {
                    this.m_matchingReferences.put(reference, accepted);
                    this.onModificationOfAMatchingService(accepted, service);
                    eventType = DependencyModel.DependencyEventType.MODIFIED;
                    eventRef = accepted;
                }
            } else {
                TransformedServiceReference transformed = new TransformedServiceReferenceImpl(reference);
                if ((transformed = this.accept(transformed)) != null) {
                    this.m_matchingReferences.put(reference, transformed);
                    this.onNewMatchingService(transformed);
                    eventType = DependencyModel.DependencyEventType.ARRIVAL;
                    eventRef = transformed;
                }
            }
        }
        finally {
            this.m_dependency.releaseWriteLockIfHeld();
        }
        if (eventType != null) {
            this.m_dependency.notifyListeners(eventType, eventRef, service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDepartureOfAMatchingService(TransformedServiceReference reference, Object service) {
        ServiceReference oldFirst;
        RankingResult result = null;
        try {
            this.m_dependency.acquireWriteLockIfNotHeld();
            oldFirst = this.getFirstService();
            result = this.applyRankingOnDeparture(reference);
            this.m_selectedReferences = result.selected;
        }
        finally {
            this.m_dependency.releaseWriteLockIfHeld();
        }
        this.fireUpdate(this.getSelectedServices(), result.departures, result.arrivals, oldFirst, this.getFirstService(), service, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removedService(ServiceReference reference, Object service) {
        TransformedServiceReference initial = null;
        try {
            this.m_dependency.acquireWriteLockIfNotHeld();
            initial = this.m_matchingReferences.remove(reference);
            if (initial != null) {
                this.onDepartureOfAMatchingService(initial, service);
            }
        }
        finally {
            this.m_dependency.releaseWriteLockIfHeld();
        }
        if (initial != null) {
            this.m_dependency.notifyListeners(DependencyModel.DependencyEventType.DEPARTURE, initial, service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeSet setFilter(Filter filter, Tracker tracker) {
        try {
            Object newInterceptor;
            ServiceTrackingInterceptor interceptor;
            this.m_dependency.acquireWriteLockIfNotHeld();
            this.m_filter = filter;
            if (!this.m_trackingInterceptors.isEmpty() && (interceptor = this.m_trackingInterceptors.getLast()) != null && interceptor instanceof FilterBasedServiceTrackingInterceptor) {
                this.m_trackingInterceptors.removeLast();
            }
            if (this.m_filter != null) {
                newInterceptor = new FilterBasedServiceTrackingInterceptor(this.m_filter);
                this.m_trackingInterceptors.addLast((ServiceTrackingInterceptor)newInterceptor);
            }
            if (tracker == null) {
                newInterceptor = new ChangeSet(Collections.<ServiceReference>emptyList(), Collections.<ServiceReference>emptyList(), Collections.<ServiceReference>emptyList(), null, null, null, null);
                return newInterceptor;
            }
            ServiceReference oldBest = this.getFirstService();
            this.m_matchingReferences.clear();
            List<ServiceReference> serviceReferencesList = tracker.getServiceReferencesList();
            if (serviceReferencesList != null) {
                for (ServiceReference reference : serviceReferencesList) {
                    TransformedServiceReference ref = new TransformedServiceReferenceImpl(reference);
                    if ((ref = this.accept(ref)) == null) continue;
                    this.m_matchingReferences.put(reference, ref);
                }
            }
            List<ServiceReference> beforeRanking = this.getSelectedServices();
            List<ServiceReference> allServices = this.getMatchingServices();
            List<ServiceReference> references = allServices.isEmpty() ? Collections.emptyList() : this.m_rankingInterceptor.getServiceReferences(this.m_dependency, allServices);
            RankingResult result = this.computeDifferences(beforeRanking, references);
            this.m_selectedReferences = result.selected;
            ChangeSet changeSet = new ChangeSet(this.getSelectedServices(), result.departures, result.arrivals, oldBest, this.getFirstService(), null, null);
            return changeSet;
        }
        finally {
            this.m_dependency.releaseWriteLockIfHeld();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        try {
            this.m_dependency.acquireReadLockIfNotHeld();
            boolean bl = this.m_selectedReferences.isEmpty();
            return bl;
        }
        finally {
            this.m_dependency.releaseReadLockIfHeld();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Comparator<ServiceReference> getComparator() {
        try {
            this.m_dependency.acquireReadLockIfNotHeld();
            Comparator<ServiceReference> comparator = this.m_comparator;
            return comparator;
        }
        finally {
            this.m_dependency.releaseReadLockIfHeld();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setComparator(Comparator<ServiceReference> cmp) {
        try {
            this.m_dependency.acquireWriteLockIfNotHeld();
            this.m_comparator = cmp == null ? new ServiceReferenceRankingComparator() : cmp;
            this.setRankingInterceptor(new ComparatorBasedServiceRankingInterceptor(this.m_comparator));
        }
        finally {
            this.m_dependency.releaseWriteLockIfHeld();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter getFilter() {
        try {
            this.m_dependency.acquireReadLockIfNotHeld();
            Filter filter = this.m_filter;
            return filter;
        }
        finally {
            this.m_dependency.releaseReadLockIfHeld();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRankingInterceptor(ServiceRankingInterceptor interceptor) {
        ChangeSet changeSet;
        this.m_dependency.getComponentInstance().getFactory().getLogger().log(3, "Dependency " + this.m_dependency.getId() + " is getting a new ranking interceptor : " + interceptor);
        try {
            this.m_dependency.acquireWriteLockIfNotHeld();
            ServiceReference oldBest = this.getFirstService();
            List<ServiceReference> beforeRanking = this.getSelectedServices();
            this.m_rankingInterceptor = interceptor;
            this.m_rankingInterceptor.open(this.m_dependency);
            List<ServiceReference> allServices = this.getMatchingServices();
            List<ServiceReference> references = Collections.emptyList();
            if (!allServices.isEmpty()) {
                references = this.m_rankingInterceptor.getServiceReferences(this.m_dependency, allServices);
            }
            RankingResult result = this.computeDifferences(beforeRanking, references);
            this.m_selectedReferences = result.selected;
            changeSet = new ChangeSet(this.getSelectedServices(), result.departures, result.arrivals, oldBest, this.getFirstService(), null, null);
        }
        finally {
            this.m_dependency.releaseWriteLockIfHeld();
        }
        this.m_dependency.onChange(changeSet);
    }

    public void close() {
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateMatchingServices() {
        ChangeSet changeset;
        try {
            this.m_dependency.acquireWriteLockIfNotHeld();
            this.m_matchingReferences.clear();
            changeset = this.computeChangesInMatchingServices();
        }
        finally {
            this.m_dependency.releaseWriteLockIfHeld();
        }
        this.m_dependency.onChange(changeset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateSelectedServices() {
        ChangeSet changeset;
        try {
            this.m_dependency.acquireWriteLockIfNotHeld();
            ServiceReference oldBest = this.getFirstService();
            List<ServiceReference> beforeRanking = this.getSelectedServices();
            this.m_selectedReferences.clear();
            List<ServiceReference> allServices = this.getMatchingServices();
            List<ServiceReference> references = Collections.emptyList();
            if (!allServices.isEmpty()) {
                references = this.m_rankingInterceptor.getServiceReferences(this.m_dependency, allServices);
            }
            RankingResult result = this.computeDifferences(beforeRanking, references);
            this.m_selectedReferences = result.selected;
            changeset = new ChangeSet(this.getSelectedServices(), result.departures, result.arrivals, oldBest, this.getFirstService(), null, null);
        }
        finally {
            this.m_dependency.releaseWriteLockIfHeld();
        }
        this.m_dependency.onChange(changeset);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChangeSet {
        public final List<ServiceReference> selected;
        public final List<ServiceReference> departures;
        public final List<ServiceReference> arrivals;
        public final ServiceReference oldFirstReference;
        public final ServiceReference newFirstReference;
        public final Object service;
        public final ServiceReference modified;

        public ChangeSet(List<ServiceReference> selectedServices, List<ServiceReference> departures, List<ServiceReference> arrivals, ServiceReference oldFirst, ServiceReference newFirst, Object service, ServiceReference modified) {
            this.selected = selectedServices;
            this.departures = departures;
            this.arrivals = arrivals;
            this.oldFirstReference = oldFirst;
            this.newFirstReference = newFirst;
            this.service = service;
            this.modified = modified;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RankingResult {
        final List<ServiceReference> departures;
        final List<ServiceReference> arrivals;
        final List<ServiceReference> selected;

        private RankingResult(List<ServiceReference> departures, List<ServiceReference> arrivals, List<ServiceReference> selected) {
            this.departures = departures;
            this.arrivals = arrivals;
            this.selected = selected;
        }
    }
}

