/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.extender.internal.queue;

import java.util.concurrent.Callable;
import org.apache.felix.ipojo.extender.internal.queue.Statistic;
import org.apache.felix.ipojo.extender.queue.Callback;
import org.apache.felix.ipojo.extender.queue.JobInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobInfoCallable<T>
implements Callable<T>,
JobInfo {
    private final Statistic m_statistic;
    private final Callable<T> m_delegate;
    private final Callback<T> m_callback;
    private final String m_description;
    private long enlistmentTime = System.currentTimeMillis();
    private long startTime = -1L;
    private long endTime = -1L;

    public JobInfoCallable(Statistic statistic, Callable<T> delegate, Callback<T> callback, String description) {
        this.m_statistic = statistic;
        this.m_delegate = delegate;
        this.m_callback = callback;
        this.m_description = description;
        this.m_statistic.getWaiters().add(this);
    }

    @Override
    public T call() throws Exception {
        this.m_statistic.getWaiters().remove(this);
        this.startTime = System.currentTimeMillis();
        this.m_statistic.getCurrentsCounter().incrementAndGet();
        Object result = null;
        try {
            Object t = result = (Object)this.m_delegate.call();
            return t;
        }
        catch (Exception e) {
            if (this.m_callback != null) {
                this.m_callback.error(this, e);
            }
            throw e;
        }
        finally {
            this.m_statistic.getCurrentsCounter().decrementAndGet();
            this.m_statistic.getFinishedCounter().incrementAndGet();
            this.endTime = System.currentTimeMillis();
            if (this.m_callback != null) {
                this.m_callback.success(this, result);
            }
        }
    }

    @Override
    public long getEnlistmentTime() {
        return this.enlistmentTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public long getWaitDuration() {
        long end = this.startTime;
        if (end == -1L) {
            end = System.currentTimeMillis();
        }
        return end - this.enlistmentTime;
    }

    @Override
    public long getExecutionDuration() {
        if (this.startTime == -1L || this.endTime == -1L) {
            return -1L;
        }
        return this.endTime - this.startTime;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }
}

