/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.extender.internal.queue.pref;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.felix.ipojo.extender.internal.LifecycleQueueService;
import org.apache.felix.ipojo.extender.internal.queue.pref.Preference;
import org.apache.felix.ipojo.extender.internal.queue.pref.PreferenceSelection;
import org.apache.felix.ipojo.extender.queue.Callback;
import org.apache.felix.ipojo.extender.queue.JobInfo;
import org.apache.felix.ipojo.extender.queue.QueueService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceQueueService
implements LifecycleQueueService {
    private final PreferenceSelection m_strategy;
    private final LifecycleQueueService m_syncQueue;
    private final LifecycleQueueService m_asyncQueue;
    private QueueService m_defaultQueue;

    public PreferenceQueueService(PreferenceSelection strategy, LifecycleQueueService syncQueue, LifecycleQueueService asyncQueue) {
        this.m_strategy = strategy;
        this.m_syncQueue = syncQueue;
        this.m_asyncQueue = asyncQueue;
        this.m_defaultQueue = asyncQueue;
    }

    @Override
    public void start() {
        this.m_syncQueue.start();
        this.m_asyncQueue.start();
    }

    @Override
    public void stop() {
        this.m_syncQueue.stop();
        this.m_asyncQueue.stop();
    }

    @Override
    public int getFinished() {
        return this.m_syncQueue.getFinished() + this.m_asyncQueue.getFinished();
    }

    @Override
    public int getWaiters() {
        return this.m_syncQueue.getWaiters() + this.m_asyncQueue.getWaiters();
    }

    @Override
    public int getCurrents() {
        return this.m_syncQueue.getCurrents() + this.m_asyncQueue.getCurrents();
    }

    @Override
    public List<JobInfo> getWaitersInfo() {
        return this.m_asyncQueue.getWaitersInfo();
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable, Callback<T> callback, String description) {
        Preference preference = Preference.DEFAULT;
        if (callable instanceof BundleReference) {
            Bundle bundle = ((BundleReference)callable).getBundle();
            preference = this.m_strategy.select(bundle);
        }
        QueueService selected = this.m_defaultQueue;
        switch (preference) {
            case ASYNC: {
                selected = this.m_asyncQueue;
                break;
            }
            case SYNC: {
                selected = this.m_syncQueue;
            }
        }
        return selected.submit(callable, callback, description);
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable, String description) {
        return this.submit(callable, null, description);
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        return this.submit(callable, "No description");
    }
}

