/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.extender.internal.queue.pref.enforce;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.felix.ipojo.extender.internal.LifecycleQueueService;
import org.apache.felix.ipojo.extender.internal.queue.pref.Preference;
import org.apache.felix.ipojo.extender.internal.queue.pref.PreferenceSelection;
import org.apache.felix.ipojo.extender.internal.queue.pref.enforce.ForwardingQueueService;
import org.apache.felix.ipojo.extender.queue.Callback;
import org.apache.felix.ipojo.util.Log;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnforcedQueueService
extends ForwardingQueueService {
    private final PreferenceSelection m_strategy;
    private final LifecycleQueueService m_queueService;
    private final Preference m_enforced;
    private final Log m_logger;

    public EnforcedQueueService(PreferenceSelection strategy, LifecycleQueueService queueService, Preference enforced, Log logger) {
        this.m_strategy = strategy;
        this.m_queueService = queueService;
        this.m_enforced = enforced;
        this.m_logger = logger;
    }

    @Override
    protected LifecycleQueueService delegate() {
        return this.m_queueService;
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable, Callback<T> callback, String description) {
        this.checkBundlePreference(callable);
        return super.submit(callable, callback, description);
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable, String description) {
        this.checkBundlePreference(callable);
        return super.submit(callable, description);
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        this.checkBundlePreference(callable);
        return super.submit(callable);
    }

    private void checkBundlePreference(Callable<?> callable) {
        Bundle bundle;
        Preference preference;
        if (callable instanceof BundleReference && !this.isCompatible(preference = this.m_strategy.select(bundle = ((BundleReference)callable).getBundle()))) {
            String message = String.format("Enforcing %s mode for Bundle %s/%s [%d] (asking for %s)", new Object[]{this.m_enforced.name(), bundle.getSymbolicName(), bundle.getVersion(), bundle.getBundleId(), preference});
            this.m_logger.log(2, message);
        }
    }

    private boolean isCompatible(Preference preference) {
        return preference == this.m_enforced || preference == Preference.DEFAULT;
    }
}

