/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.dependency;

import java.util.List;
import org.apache.felix.ipojo.architecture.HandlerDescription;
import org.apache.felix.ipojo.handlers.dependency.Dependency;
import org.apache.felix.ipojo.handlers.dependency.DependencyDescription;
import org.apache.felix.ipojo.handlers.dependency.DependencyHandler;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.osgi.framework.ServiceReference;

public class DependencyHandlerDescription
extends HandlerDescription {
    private DependencyDescription[] m_dependencies = new DependencyDescription[0];

    public DependencyHandlerDescription(DependencyHandler handler, Dependency[] deps) {
        super(handler);
        this.m_dependencies = new DependencyDescription[deps.length];
        for (int i = 0; i < this.m_dependencies.length; ++i) {
            this.m_dependencies[i] = new DependencyDescription(deps[i]);
        }
    }

    public DependencyDescription[] getDependencies() {
        return this.m_dependencies;
    }

    public Element getHandlerInfo() {
        Element deps = super.getHandlerInfo();
        for (int i = 0; i < this.m_dependencies.length; ++i) {
            String instance;
            Element use;
            String state = "resolved";
            if (this.m_dependencies[i].getState() == 0) {
                state = "unresolved";
            }
            if (this.m_dependencies[i].getState() == -1) {
                state = "broken";
            }
            Element dep = new Element("Requires", "");
            dep.addAttribute(new Attribute("Specification", this.m_dependencies[i].getInterface()));
            dep.addAttribute(new Attribute("Id", this.m_dependencies[i].getId()));
            if (this.m_dependencies[i].getFilter() != null) {
                dep.addAttribute(new Attribute("Filter", this.m_dependencies[i].getFilter()));
            }
            if (this.m_dependencies[i].isOptional()) {
                dep.addAttribute(new Attribute("Optional", "true"));
                if (this.m_dependencies[i].supportsNullable()) {
                    dep.addAttribute(new Attribute("Nullable", "true"));
                }
                if (this.m_dependencies[i].getDefaultImplementation() != null) {
                    dep.addAttribute(new Attribute("Default-Implementation", this.m_dependencies[i].getDefaultImplementation()));
                }
            } else {
                dep.addAttribute(new Attribute("Optional", "false"));
            }
            if (this.m_dependencies[i].isMultiple()) {
                dep.addAttribute(new Attribute("Aggregate", "true"));
            } else {
                dep.addAttribute(new Attribute("Aggregate", "false"));
            }
            if (this.m_dependencies[i].isProxy()) {
                dep.addAttribute(new Attribute("Proxy", "true"));
            } else {
                dep.addAttribute(new Attribute("Proxy", "false"));
            }
            String policy = "dynamic";
            if (this.m_dependencies[i].getPolicy() == 1) {
                policy = "static";
            } else if (this.m_dependencies[i].getPolicy() == 2) {
                policy = "dynamic-priority";
            }
            dep.addAttribute(new Attribute("Binding-Policy", policy));
            if (this.m_dependencies[i].getComparator() != null) {
                dep.addAttribute(new Attribute("Comparator", this.m_dependencies[i].getComparator()));
            }
            dep.addAttribute(new Attribute("State", state));
            List<ServiceReference> set = this.m_dependencies[i].getUsedServices();
            if (set != null) {
                for (ServiceReference ref : set) {
                    use = new Element("Uses", "");
                    use.addAttribute(new Attribute("service.id", ref.getProperty("service.id").toString()));
                    instance = (String)ref.getProperty("instance.name");
                    if (instance != null) {
                        use.addAttribute(new Attribute("instance.name", instance));
                    }
                    dep.addElement(use);
                }
            }
            if ((set = this.m_dependencies[i].getServiceReferences()) != null) {
                for (ServiceReference ref : set) {
                    use = new Element("Selected", "");
                    use.addAttribute(new Attribute("service.id", ref.getProperty("service.id").toString()));
                    instance = (String)ref.getProperty("instance.name");
                    if (instance != null) {
                        use.addAttribute(new Attribute("instance.name", instance));
                    }
                    dep.addElement(use);
                }
            }
            if (this.m_dependencies[i].getDependency() != null && (set = this.m_dependencies[i].getDependency().getServiceReferenceManager().getMatchingServices()) != null) {
                for (ServiceReference ref : set) {
                    use = new Element("Matches", "");
                    use.addAttribute(new Attribute("service.id", ref.getProperty("service.id").toString()));
                    instance = (String)ref.getProperty("instance.name");
                    if (instance != null) {
                        use.addAttribute(new Attribute("instance.name", instance));
                    }
                    dep.addElement(use);
                }
            }
            deps.addElement(dep);
        }
        return deps;
    }
}

