/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.IPOJOServiceFactory;
import org.apache.felix.ipojo.dependency.impl.ServiceReferenceManager;
import org.apache.felix.ipojo.util.ContextSourceManager;
import org.apache.felix.ipojo.util.DependencyModelListener;
import org.apache.felix.ipojo.util.DependencyStateListener;
import org.apache.felix.ipojo.util.ServiceReferenceRankingComparator;
import org.apache.felix.ipojo.util.Tracker;
import org.apache.felix.ipojo.util.TrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DependencyModel {
    public static final int BROKEN = -1;
    public static final int UNRESOLVED = 0;
    public static final int RESOLVED = 1;
    public static final int DYNAMIC_BINDING_POLICY = 0;
    public static final int STATIC_BINDING_POLICY = 1;
    public static final int DYNAMIC_PRIORITY_BINDING_POLICY = 2;
    protected final ServiceReferenceManager m_serviceReferenceManager;
    private final ContextSourceManager m_contextSourceManager;
    private final DependencyStateListener m_listener;
    private final ComponentInstance m_instance;
    private boolean m_aggregate;
    private boolean m_optional;
    private Class m_specification;
    private BundleContext m_context;
    private int m_state;
    private int m_policy = 0;
    private Tracker m_tracker;
    private Map<ServiceReference, Object> m_serviceObjects = new HashMap<ServiceReference, Object>();
    private List<ServiceReference> m_boundServices = new ArrayList<ServiceReference>();
    private ReentrantReadWriteLock m_lock = new ReentrantReadWriteLock();
    private final List<DependencyModelListener> m_listeners = new ArrayList<DependencyModelListener>();

    public DependencyModel(Class specification, boolean aggregate, boolean optional, Filter filter, Comparator<ServiceReference> comparator, int policy, BundleContext context, DependencyStateListener listener, ComponentInstance ci) {
        this.m_specification = specification;
        this.m_aggregate = aggregate;
        this.m_optional = optional;
        this.m_instance = ci;
        this.m_policy = policy;
        if (this.m_policy == 2 && comparator == null) {
            comparator = new ServiceReferenceRankingComparator();
        }
        if (context != null) {
            this.m_context = context;
        }
        this.m_serviceReferenceManager = new ServiceReferenceManager(this, filter, comparator);
        if (filter != null) {
            try {
                this.m_contextSourceManager = new ContextSourceManager(this);
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            this.m_contextSourceManager = null;
        }
        this.m_state = 0;
        this.m_listener = listener;
    }

    public void start() {
        this.m_state = 0;
        this.m_tracker = new Tracker(this.m_context, this.m_specification.getName(), (TrackerCustomizer)this.m_serviceReferenceManager);
        this.m_serviceReferenceManager.open();
        this.m_tracker.open();
        if (this.m_contextSourceManager != null) {
            this.m_contextSourceManager.start();
        }
        this.computeAndSetDependencyState();
    }

    public BundleContext getBundleContext() {
        return this.m_context;
    }

    public void invalidateSelectedServices() {
        this.m_serviceReferenceManager.invalidateSelectedServices();
    }

    public void invalidateMatchingServices() {
        this.m_serviceReferenceManager.invalidateMatchingServices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            this.acquireWriteLockIfNotHeld();
            if (this.m_tracker != null) {
                this.m_tracker.close();
                this.m_tracker = null;
            }
            this.m_boundServices.clear();
            this.m_serviceReferenceManager.close();
            this.ungetAllServices();
            this.m_state = 0;
            if (this.m_contextSourceManager != null) {
                this.m_contextSourceManager.stop();
            }
        }
        finally {
            this.releaseWriteLockIfHeld();
        }
    }

    private void ungetAllServices() {
        for (Map.Entry<ServiceReference, Object> entry : this.m_serviceObjects.entrySet()) {
            ServiceReference ref = entry.getKey();
            Object svc = entry.getValue();
            if (this.m_tracker != null) {
                this.m_tracker.ungetService(ref);
            }
            if (!(svc instanceof IPOJOServiceFactory)) continue;
            ((IPOJOServiceFactory)svc).ungetService(this.m_instance, svc);
        }
        this.m_serviceObjects.clear();
    }

    public boolean isFrozen() {
        return false;
    }

    public void unfreeze() {
    }

    public boolean match(ServiceReference ref) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeAndSetDependencyState() {
        try {
            boolean mustCallValidate = false;
            boolean mustCallInvalidate = false;
            this.acquireWriteLockIfNotHeld();
            if (this.m_state == -1) {
                return;
            }
            if (this.m_optional || !this.m_serviceReferenceManager.isEmpty()) {
                if (this.m_state == 0) {
                    this.m_state = 1;
                    mustCallValidate = true;
                }
            } else if (this.m_state == 1) {
                this.m_state = 0;
                mustCallInvalidate = true;
            }
            this.releaseWriteLockIfHeld();
            if (mustCallInvalidate) {
                this.invalidate();
            } else if (mustCallValidate) {
                this.validate();
            }
        }
        finally {
            this.releaseWriteLockIfHeld();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReference getServiceReference() {
        try {
            this.acquireReadLockIfNotHeld();
            if (this.m_boundServices.isEmpty()) {
                ServiceReference serviceReference = null;
                return serviceReference;
            }
            ServiceReference serviceReference = this.m_boundServices.get(0);
            return serviceReference;
        }
        finally {
            this.releaseReadLockIfHeld();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReference[] getServiceReferences() {
        try {
            this.acquireReadLockIfNotHeld();
            if (this.m_boundServices.isEmpty()) {
                ServiceReference[] serviceReferenceArray = null;
                return serviceReferenceArray;
            }
            ServiceReference[] serviceReferenceArray = this.m_boundServices.toArray(new ServiceReference[this.m_boundServices.size()]);
            return serviceReferenceArray;
        }
        finally {
            this.releaseReadLockIfHeld();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServiceReference> getUsedServiceReferences() {
        try {
            this.acquireReadLockIfNotHeld();
            int size = this.m_boundServices.size();
            List<ServiceReference> usedByTracker = null;
            if (this.m_tracker != null) {
                usedByTracker = this.m_tracker.getUsedServiceReferences();
            }
            if (size == 0 || usedByTracker == null) {
                List<ServiceReference> list = null;
                return list;
            }
            ArrayList<ServiceReference> list = new ArrayList<ServiceReference>(1);
            for (ServiceReference ref : this.m_boundServices) {
                if (!usedByTracker.contains(ref)) continue;
                list.add(ref);
                if (this.isAggregate()) continue;
                ArrayList<ServiceReference> arrayList = list;
                return arrayList;
            }
            ArrayList<ServiceReference> arrayList = list;
            return arrayList;
        }
        finally {
            this.releaseReadLockIfHeld();
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.m_instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        try {
            this.acquireReadLockIfNotHeld();
            int n = this.m_boundServices.size();
            return n;
        }
        finally {
            this.releaseReadLockIfHeld();
        }
    }

    public abstract void onServiceArrival(ServiceReference var1);

    public abstract void onServiceDeparture(ServiceReference var1);

    public abstract void onServiceModification(ServiceReference var1);

    public abstract void onDependencyReconfiguration(ServiceReference[] var1, ServiceReference[] var2);

    private void invalidate() {
        this.m_listener.invalidate(this);
        this.notifyListeners(DependencyEventType.INVALIDATE, null, null);
    }

    private void validate() {
        this.m_listener.validate(this);
        this.notifyListeners(DependencyEventType.VALIDATE, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        try {
            this.acquireReadLockIfNotHeld();
            int n = this.m_state;
            return n;
        }
        finally {
            this.releaseReadLockIfHeld();
        }
    }

    public Class getSpecification() {
        return this.m_specification;
    }

    public void setSpecification(Class specification) {
        if (this.m_tracker != null) {
            throw new UnsupportedOperationException("Dynamic specification change is not yet supported");
        }
        this.m_specification = specification;
    }

    public boolean acquireWriteLockIfNotHeld() {
        if (!this.m_lock.isWriteLockedByCurrentThread()) {
            this.m_lock.writeLock().lock();
            return true;
        }
        return false;
    }

    public boolean releaseWriteLockIfHeld() {
        if (this.m_lock.isWriteLockedByCurrentThread()) {
            this.m_lock.writeLock().unlock();
        }
        return this.m_lock.getWriteHoldCount() == 0;
    }

    public boolean acquireReadLockIfNotHeld() {
        this.m_lock.readLock().lock();
        return true;
    }

    public boolean releaseReadLockIfHeld() {
        try {
            this.m_lock.readLock().unlock();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilter() {
        Filter filter;
        try {
            this.acquireReadLockIfNotHeld();
            filter = this.m_serviceReferenceManager.getFilter();
        }
        finally {
            this.releaseReadLockIfHeld();
        }
        if (filter == null) {
            return null;
        }
        return filter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(Filter filter) {
        try {
            this.acquireWriteLockIfNotHeld();
            ServiceReferenceManager.ChangeSet changeSet = this.m_serviceReferenceManager.setFilter(filter, this.m_tracker);
            this.applyReconfiguration(changeSet);
        }
        finally {
            this.releaseWriteLockIfHeld();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyReconfiguration(ServiceReferenceManager.ChangeSet changeSet) {
        List<Object> arr = new ArrayList();
        List<Object> dep = new ArrayList();
        try {
            this.acquireWriteLockIfNotHeld();
            if (this.m_tracker == null) {
                return;
            }
            this.m_boundServices.clear();
            if (this.m_aggregate) {
                this.m_boundServices = new ArrayList<ServiceReference>(changeSet.selected);
                arr = changeSet.arrivals;
                dep = changeSet.departures;
            } else {
                ServiceReference used = null;
                if (!this.m_boundServices.isEmpty()) {
                    used = this.m_boundServices.get(0);
                }
                if (!changeSet.selected.isEmpty()) {
                    ServiceReference best = changeSet.newFirstReference;
                    if (used == null) {
                        this.m_boundServices.add(best);
                        arr.add(best);
                    } else if (changeSet.selected.contains(used)) {
                        if (this.getBindingPolicy() == 2 && used != best) {
                            this.m_boundServices.add(best);
                            dep.add(used);
                            arr.add(best);
                        } else {
                            this.m_boundServices.add(used);
                        }
                    } else {
                        this.m_boundServices.add(best);
                        dep.add(used);
                        arr.add(best);
                    }
                } else if (used != null) {
                    arr.add(used);
                }
            }
        }
        finally {
            this.releaseWriteLockIfHeld();
        }
        this.computeAndSetDependencyState();
        this.onDependencyReconfiguration(dep.toArray(new ServiceReference[dep.size()]), arr.toArray(new ServiceReference[arr.size()]));
        this.notifyListeners(DependencyEventType.RECONFIGURED, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAggregate() {
        try {
            this.acquireReadLockIfNotHeld();
            boolean bl = this.m_aggregate;
            return bl;
        }
        finally {
            this.releaseReadLockIfHeld();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAggregate(boolean isAggregate) {
        this.acquireWriteLockIfNotHeld();
        ArrayList<ServiceReference> arrivals = new ArrayList<ServiceReference>();
        ArrayList departures = new ArrayList();
        try {
            if (this.m_tracker == null) {
                this.m_aggregate = isAggregate;
            } else if (!this.m_aggregate && isAggregate) {
                this.m_aggregate = true;
                if (this.m_state == 1) {
                    for (ServiceReference ref : this.m_serviceReferenceManager.getSelectedServices()) {
                        if (this.m_boundServices.contains(ref)) continue;
                        this.m_boundServices.add(ref);
                        arrivals.add(ref);
                    }
                }
            } else if (this.m_aggregate && !isAggregate) {
                this.m_aggregate = false;
                if (this.m_state == 1) {
                    ArrayList<ServiceReference> list = new ArrayList<ServiceReference>(this.m_boundServices);
                    for (int i = 1; i < list.size(); ++i) {
                        this.m_boundServices.remove(list.get(i));
                        departures.add(list.get(i));
                    }
                }
            }
        }
        finally {
            this.releaseWriteLockIfHeld();
        }
        try {
            this.acquireReadLockIfNotHeld();
            for (ServiceReference ref : arrivals) {
                this.onServiceArrival(ref);
                this.notifyListeners(DependencyEventType.BINDING, ref, this.m_serviceObjects.get(ref));
            }
            for (ServiceReference ref : departures) {
                this.onServiceDeparture(ref);
                this.notifyListeners(DependencyEventType.UNBINDING, ref, this.m_serviceObjects.get(ref));
            }
        }
        finally {
            this.releaseReadLockIfHeld();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOptionality(boolean isOptional) {
        try {
            this.acquireWriteLockIfNotHeld();
            this.m_optional = isOptional;
            this.computeAndSetDependencyState();
        }
        finally {
            this.releaseWriteLockIfHeld();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOptional() {
        try {
            this.acquireReadLockIfNotHeld();
            boolean bl = this.m_optional;
            return bl;
        }
        finally {
            this.releaseReadLockIfHeld();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBindingPolicy() {
        try {
            this.acquireReadLockIfNotHeld();
            int n = this.m_policy;
            return n;
        }
        finally {
            this.releaseReadLockIfHeld();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getComparator() {
        Comparator<ServiceReference> comparator;
        try {
            this.acquireReadLockIfNotHeld();
            comparator = this.m_serviceReferenceManager.getComparator();
        }
        finally {
            this.releaseReadLockIfHeld();
        }
        if (comparator != null) {
            return comparator.getClass().getName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setComparator(Comparator<ServiceReference> cmp) {
        try {
            this.acquireWriteLockIfNotHeld();
            this.m_serviceReferenceManager.setComparator(cmp);
        }
        finally {
            this.releaseWriteLockIfHeld();
        }
    }

    public void setBundleContext(BundleContext context) {
        if (this.m_tracker != null) {
            throw new UnsupportedOperationException("Dynamic bundle (i.e. service) context change is not supported");
        }
        this.m_context = context;
    }

    public Object getService(ServiceReference ref) {
        return this.getService(ref, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(ServiceReference ref, boolean store) {
        Object svc = this.m_tracker.getService(ref);
        IPOJOServiceFactory factory = null;
        if (svc instanceof IPOJOServiceFactory) {
            factory = (IPOJOServiceFactory)svc;
            svc = factory.getService(this.m_instance);
        }
        if (store) {
            try {
                this.acquireWriteLockIfNotHeld();
                if (factory != null) {
                    this.m_serviceObjects.put(ref, factory);
                } else {
                    this.m_serviceObjects.put(ref, svc);
                }
            }
            finally {
                this.releaseWriteLockIfHeld();
            }
        }
        return svc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ungetService(ServiceReference ref) {
        Object obj;
        this.m_tracker.ungetService(ref);
        try {
            this.acquireWriteLockIfNotHeld();
            obj = this.m_serviceObjects.remove(ref);
        }
        finally {
            this.releaseWriteLockIfHeld();
        }
        if (obj != null && obj instanceof IPOJOServiceFactory) {
            ((IPOJOServiceFactory)obj).ungetService(this.m_instance, obj);
        }
    }

    public ContextSourceManager getContextSourceManager() {
        return this.m_contextSourceManager;
    }

    public String getId() {
        return this.getSpecification().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChange(ServiceReferenceManager.ChangeSet set) {
        try {
            Object svc;
            this.acquireWriteLockIfNotHeld();
            if (this.isFrozen() && this.getState() != -1) {
                for (ServiceReference ref : set.departures) {
                    if (!this.m_boundServices.contains(ref)) continue;
                    this.m_state = -1;
                    Object svc2 = this.m_serviceObjects.get(ref);
                    this.releaseWriteLockIfHeld();
                    this.notifyListeners(DependencyEventType.UNBINDING, ref, svc2);
                    this.notifyListeners(DependencyEventType.DEPARTURE, ref, null);
                    this.invalidate();
                    this.m_instance.stop();
                    this.unfreeze();
                    this.m_instance.start();
                    return;
                }
            }
            ArrayList<ServiceReference> arrivals = new ArrayList<ServiceReference>();
            ArrayList<ServiceReference> departures = new ArrayList<ServiceReference>();
            for (ServiceReference ref : set.departures) {
                if (!this.m_boundServices.contains(ref)) continue;
                this.m_boundServices.remove(ref);
                departures.add(ref);
            }
            if (this.m_aggregate) {
                if (this.m_serviceObjects.isEmpty() || 2 == this.getBindingPolicy()) {
                    this.m_boundServices.clear();
                    this.m_boundServices.addAll(set.selected);
                }
                for (ServiceReference ref : set.arrivals) {
                    if (!this.m_boundServices.contains(ref)) {
                        this.m_boundServices.add(ref);
                    }
                    arrivals.add(ref);
                }
            } else if (!set.selected.isEmpty()) {
                ServiceReference best = set.selected.get(0);
                if (this.m_boundServices.isEmpty()) {
                    this.m_boundServices.add(best);
                    arrivals.add(best);
                } else {
                    ServiceReference current = this.m_boundServices.get(0);
                    if (this.getBindingPolicy() == 2) {
                        if (current != best) {
                            this.m_boundServices.remove(current);
                            this.m_boundServices.add(best);
                            departures.add(current);
                            arrivals.add(best);
                        }
                    } else {
                        boolean isUsed = this.m_serviceObjects.containsKey(current);
                        if (!isUsed && current != best) {
                            this.m_boundServices.remove(current);
                            this.m_boundServices.add(best);
                            departures.add(current);
                            arrivals.add(best);
                        }
                    }
                }
            }
            HashMap<ServiceReference, Object> services = new HashMap<ServiceReference, Object>(this.m_serviceObjects);
            this.releaseWriteLockIfHeld();
            for (ServiceReference ref : departures) {
                this.onServiceDeparture(ref);
                svc = services.get(ref);
                this.notifyListeners(DependencyEventType.UNBINDING, ref, svc);
            }
            for (ServiceReference ref : arrivals) {
                this.onServiceArrival(ref);
                svc = services.get(ref);
                this.notifyListeners(DependencyEventType.BINDING, ref, svc);
            }
            if (set.modified != null && this.m_boundServices.contains(set.modified)) {
                this.onServiceModification(set.modified);
            }
            this.computeAndSetDependencyState();
        }
        finally {
            this.releaseWriteLockIfHeld();
        }
    }

    public ServiceReferenceManager getServiceReferenceManager() {
        return this.m_serviceReferenceManager;
    }

    public Tracker getTracker() {
        return this.m_tracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DependencyModelListener listener) {
        if (listener == null) {
            throw new NullPointerException("null listener");
        }
        List<DependencyModelListener> list = this.m_listeners;
        synchronized (list) {
            this.m_listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DependencyModelListener listener) {
        if (listener == null) {
            throw new NullPointerException("null listener");
        }
        List<DependencyModelListener> list = this.m_listeners;
        synchronized (list) {
            int i = -1;
            for (int j = this.m_listeners.size() - 1; j >= 0; --j) {
                if (this.m_listeners.get(j) != listener) continue;
                i = j;
                break;
            }
            if (i == -1) {
                throw new NoSuchElementException("no such listener");
            }
            this.m_listeners.remove(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners(DependencyEventType type, ServiceReference<?> service, Object object) {
        ArrayList<DependencyModelListener> tmp;
        List<DependencyModelListener> list = this.m_listeners;
        synchronized (list) {
            tmp = new ArrayList<DependencyModelListener>(this.m_listeners);
        }
        for (DependencyModelListener l : tmp) {
            try {
                switch (type) {
                    case VALIDATE: {
                        l.validate(this);
                        break;
                    }
                    case INVALIDATE: {
                        l.invalidate(this);
                        break;
                    }
                    case ARRIVAL: {
                        l.matchingServiceArrived(this, service);
                        break;
                    }
                    case MODIFIED: {
                        l.matchingServiceModified(this, service);
                        break;
                    }
                    case DEPARTURE: {
                        l.matchingServiceDeparted(this, service);
                        break;
                    }
                    case BINDING: {
                        l.serviceBound(this, service, object);
                        break;
                    }
                    case UNBINDING: {
                        l.serviceUnbound(this, service, object);
                        break;
                    }
                    case RECONFIGURED: {
                        l.reconfigured(this);
                    }
                }
            }
            catch (Throwable e) {
                this.getComponentInstance().getFactory().getLogger().log(2, String.format("[%s] A DependencyModelListener has failed: %s", this.getComponentInstance().getInstanceName(), e.getMessage()), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        List<DependencyModelListener> list = this.m_listeners;
        synchronized (list) {
            this.m_listeners.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DependencyEventType {
        VALIDATE,
        INVALIDATE,
        ARRIVAL,
        MODIFIED,
        DEPARTURE,
        BINDING,
        UNBINDING,
        RECONFIGURED;

    }
}

