/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.util;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.ConstructorInjector;
import org.apache.felix.ipojo.FieldInterceptor;
import org.apache.felix.ipojo.Handler;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.parser.ParseUtils;
import org.apache.felix.ipojo.util.Callback;
import org.osgi.framework.BundleContext;

public class Property
implements FieldInterceptor,
ConstructorInjector {
    public static final Object NO_VALUE = new Object();
    private final String m_name;
    private final String m_field;
    private final Callback m_method;
    private int m_index = -1;
    private Object m_value = NO_VALUE;
    private Object m_defaultValue = NO_VALUE;
    private boolean m_invoked;
    private final Class m_type;
    private final Handler m_handler;
    private final InstanceManager m_manager;

    public Property(String name, String field, String method, String value, String type, InstanceManager manager, Handler handler) throws ConfigurationException {
        this.m_handler = handler;
        this.m_manager = manager;
        this.m_field = field;
        this.m_name = name == null ? (this.m_field == null ? method : field) : name;
        this.m_type = Property.computeType(type, manager.getGlobalContext());
        if (value != null) {
            this.m_defaultValue = this.m_value = Property.create(this.m_type, value);
        }
        this.m_method = method != null ? new Callback(method, new String[]{this.m_type.getName()}, false, manager) : null;
    }

    public Property(String name, String field, String method, Object value, InstanceManager manager, Handler handler) throws ConfigurationException {
        this.m_handler = handler;
        this.m_manager = manager;
        this.m_field = field;
        if (value == null) {
            throw new ConfigurationException("Cannot create properties without a value");
        }
        this.m_name = name == null ? (this.m_field == null ? method : field) : name;
        this.m_type = value.getClass();
        this.m_defaultValue = this.m_value = value;
        this.m_method = method != null ? new Callback(method, new String[]{this.m_type.getName()}, false, manager) : null;
    }

    public Property(String name, String field, String method, int index, String value, String type, InstanceManager manager, Handler handler) throws ConfigurationException {
        this(name, field, method, value, type, manager, handler);
        this.m_index = index;
    }

    public static Class computeType(String type, BundleContext context) throws ConfigurationException {
        if (type.endsWith("[]")) {
            return Property.computeArrayType(type, context);
        }
        if ("string".equals(type) || "String".equals(type)) {
            return String.class;
        }
        if ("boolean".equals(type)) {
            return Boolean.TYPE;
        }
        if ("byte".equals(type)) {
            return Byte.TYPE;
        }
        if ("short".equals(type)) {
            return Short.TYPE;
        }
        if ("int".equals(type)) {
            return Integer.TYPE;
        }
        if ("long".equals(type)) {
            return Long.TYPE;
        }
        if ("float".equals(type)) {
            return Float.TYPE;
        }
        if ("double".equals(type)) {
            return Double.TYPE;
        }
        if ("char".equals(type)) {
            return Character.TYPE;
        }
        try {
            return context.getBundle().loadClass(type);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Class not found exception in setValue on " + type, e);
        }
        catch (SecurityException e) {
            throw new ConfigurationException("Security exception in setValue on " + type, e);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException("Argument issue when calling the constructor of the type " + type, e);
        }
    }

    private static Class computeArrayType(String type, BundleContext context) throws ConfigurationException {
        String internalType = type.substring(0, type.length() - 2);
        if ("string".equals(internalType) || "String".equals(internalType)) {
            return new String[0].getClass();
        }
        if ("boolean".equals(internalType)) {
            return new boolean[0].getClass();
        }
        if ("byte".equals(internalType)) {
            return new byte[0].getClass();
        }
        if ("short".equals(internalType)) {
            return new short[0].getClass();
        }
        if ("int".equals(internalType)) {
            return new int[0].getClass();
        }
        if ("long".equals(internalType)) {
            return new long[0].getClass();
        }
        if ("float".equals(internalType)) {
            return new float[0].getClass();
        }
        if ("double".equals(internalType)) {
            return new double[0].getClass();
        }
        if ("char".equals(internalType)) {
            return new char[0].getClass();
        }
        try {
            Class clazz = context.getBundle().loadClass(internalType);
            Object[] object = (Object[])Array.newInstance(clazz, 0);
            return object.getClass();
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Class not found exception in setValue on " + internalType, e);
        }
        catch (SecurityException e) {
            throw new ConfigurationException("Security Exception in setValue on " + internalType, e);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException("Argument issue when calling the constructor of the type " + internalType, e);
        }
    }

    public String getName() {
        return this.m_name;
    }

    public String getField() {
        return this.m_field;
    }

    public String getType() {
        return this.m_type.getName();
    }

    public String getMethod() {
        if (this.m_method == null) {
            return null;
        }
        return this.m_method.getMethod();
    }

    public boolean hasMethod() {
        return this.m_method != null;
    }

    public int getParameterIndex() {
        return this.m_index;
    }

    public boolean hasField() {
        return this.m_field != null;
    }

    public synchronized Object getValue() {
        return this.m_value;
    }

    public Object getDefaultValue() {
        return this.m_defaultValue;
    }

    private static Object getNoValue(Class type) {
        if (Boolean.TYPE.equals(type)) {
            return Boolean.FALSE;
        }
        if (Byte.TYPE.equals(type)) {
            return new Byte(0);
        }
        if (Short.TYPE.equals(type)) {
            return new Short(0);
        }
        if (Integer.TYPE.equals(type)) {
            return new Integer(0);
        }
        if (Long.TYPE.equals(type)) {
            return new Long(0L);
        }
        if (Float.TYPE.equals(type)) {
            return new Float(0.0f);
        }
        if (Double.TYPE.equals(type)) {
            return new Double(0.0);
        }
        if (Character.TYPE.equals(type)) {
            return new Character('\u0000');
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Object value) {
        Property property = this;
        synchronized (property) {
            if (Property.isAssignable(this.m_type, value)) {
                this.m_value = value;
            } else if (value instanceof String) {
                try {
                    this.m_value = Property.create(this.m_type, (String)value);
                }
                catch (ConfigurationException e) {
                    throw new ClassCastException("Incompatible type for the property " + this.m_name + " : " + e.getMessage());
                }
            } else {
                throw new ClassCastException("Incompatible type for the property " + this.m_name + " " + this.m_type.getName() + " expected, " + value.getClass() + " found");
            }
            this.m_invoked = false;
        }
    }

    public static boolean isAssignable(Class type, Object value) {
        if (value == null || type.isInstance(value) || value == NO_VALUE) {
            return true;
        }
        if (type.isPrimitive()) {
            if (value instanceof Boolean && Boolean.TYPE.equals(type)) {
                return true;
            }
            if (value instanceof Byte && Byte.TYPE.equals(type)) {
                return true;
            }
            if (value instanceof Short && Short.TYPE.equals(type)) {
                return true;
            }
            if (value instanceof Integer && Integer.TYPE.equals(type)) {
                return true;
            }
            if (value instanceof Long && Long.TYPE.equals(type)) {
                return true;
            }
            if (value instanceof Float && Float.TYPE.equals(type)) {
                return true;
            }
            if (value instanceof Double && Double.TYPE.equals(type)) {
                return true;
            }
            return value instanceof Character && Character.TYPE.equals(type);
        }
        return false;
    }

    public static Object create(Class type, String strValue) throws ConfigurationException {
        if (Boolean.TYPE.equals(type)) {
            return Boolean.valueOf(strValue);
        }
        if (Byte.TYPE.equals(type)) {
            return new Byte(strValue);
        }
        if (Short.TYPE.equals(type)) {
            return new Short(strValue);
        }
        if (Integer.TYPE.equals(type)) {
            return new Integer(strValue);
        }
        if (Long.TYPE.equals(type)) {
            return new Long(strValue);
        }
        if (Float.TYPE.equals(type)) {
            return new Float(strValue);
        }
        if (Double.TYPE.equals(type)) {
            return new Double(strValue);
        }
        if (Character.TYPE.equals(type)) {
            return new Character(strValue.charAt(0));
        }
        if (type.isArray()) {
            return Property.createArrayObject(type.getComponentType(), ParseUtils.parseArrays(strValue));
        }
        if (type.getSuperclass() != null && type.getSuperclass().getName().equals("java.lang.Enum")) {
            try {
                Method valueOf = type.getMethod("valueOf", String.class);
                if (!valueOf.isAccessible()) {
                    valueOf.setAccessible(true);
                }
                return valueOf.invoke(null, (Object[])new String[]{strValue});
            }
            catch (InvocationTargetException e) {
                throw new ConfigurationException("Cannot create an enumerated value for " + type + " with " + strValue, e.getTargetException());
            }
            catch (Exception e) {
                throw new ConfigurationException("Cannot create an enumerated value for " + type + " with " + strValue, e);
            }
        }
        try {
            Constructor cst = type.getConstructor(String.class);
            return cst.newInstance(strValue);
        }
        catch (SecurityException e) {
            throw new ConfigurationException("Security exception during the creation of " + type, e);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException("Constructor not found exception during the creation of " + type, e);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException("Argument issue when calling the constructor of the type " + type, e);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException("Instantiation problem  " + type, e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Illegal Access " + type, e);
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException("Invocation problem during the creation of " + type, e.getTargetException());
        }
    }

    public static Object createArrayObject(Class interntype, String[] values) throws ConfigurationException {
        if (Boolean.TYPE.equals(interntype)) {
            boolean[] bool = new boolean[values.length];
            for (int i = 0; i < values.length; ++i) {
                bool[i] = Boolean.valueOf(values[i]);
            }
            return bool;
        }
        if (Byte.TYPE.equals(interntype)) {
            byte[] byt = new byte[values.length];
            for (int i = 0; i < values.length; ++i) {
                byt[i] = new Byte(values[i]);
            }
            return byt;
        }
        if (Short.TYPE.equals(interntype)) {
            short[] shor = new short[values.length];
            for (int i = 0; i < values.length; ++i) {
                shor[i] = new Short(values[i]);
            }
            return shor;
        }
        if (Integer.TYPE.equals(interntype)) {
            int[] ints = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                ints[i] = new Integer(values[i]);
            }
            return ints;
        }
        if (Long.TYPE.equals(interntype)) {
            long[] longs = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                longs[i] = new Long(values[i]);
            }
            return longs;
        }
        if (Float.TYPE.equals(interntype)) {
            float[] floats = new float[values.length];
            for (int i = 0; i < values.length; ++i) {
                floats[i] = new Float(values[i]).floatValue();
            }
            return floats;
        }
        if (Double.TYPE.equals(interntype)) {
            double[] doubles = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                doubles[i] = new Double(values[i]);
            }
            return doubles;
        }
        if (Character.TYPE.equals(interntype)) {
            char[] chars = new char[values.length];
            for (int i = 0; i < values.length; ++i) {
                chars[i] = values[i].toCharArray()[0];
            }
            return chars;
        }
        try {
            Constructor cst = interntype.getConstructor(String.class);
            Object[] object = (Object[])Array.newInstance(interntype, values.length);
            for (int i = 0; i < values.length; ++i) {
                object[i] = cst.newInstance(values[i].trim());
            }
            return object;
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException("Constructor not found exception in setValue on " + interntype.getName(), e);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException("Argument issue when calling the constructor of the type " + interntype.getName(), e);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException("Instantiation problem  " + interntype.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Illegal Access Exception in  " + interntype.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException("Invocation problem " + interntype.getName(), e.getTargetException());
        }
    }

    public synchronized void reset() {
        this.m_invoked = false;
    }

    public synchronized void invoke(Object instance) {
        if (this.m_invoked) {
            return;
        }
        if (this.m_value == NO_VALUE) {
            return;
        }
        try {
            if (instance == null) {
                this.m_method.call(new Object[]{this.m_value});
            } else {
                this.m_method.call(instance, new Object[]{this.m_value});
            }
            this.m_invoked = true;
        }
        catch (NoSuchMethodException e) {
            this.m_handler.error("The method " + this.m_method + " does not exist in the implementation class " + this.m_manager.getClassName(), e);
            this.m_manager.stop();
        }
        catch (IllegalAccessException e) {
            this.m_handler.error("The method " + this.m_method + " is not accessible in the implementation class " + this.m_manager.getClassName(), e);
            this.m_manager.stop();
        }
        catch (InvocationTargetException e) {
            this.m_handler.error("The method " + this.m_method + " in the implementation class " + this.m_manager.getClassName() + "throws an exception : " + e.getTargetException().getMessage(), e.getTargetException());
            this.m_manager.setState(1);
        }
    }

    public synchronized Object onGet(Object pojo, String fieldName, Object value) {
        if (this.m_value == NO_VALUE) {
            return Property.getNoValue(this.m_type);
        }
        return this.m_value;
    }

    public synchronized void onSet(Object pojo, String fieldName, Object value) {
        if (this.m_value == null || !this.m_value.equals(value)) {
            this.setValue(value);
        }
    }

    public Object getConstructorParameter(int index) {
        if (this.m_index != index) {
            return null;
        }
        if (this.m_value == NO_VALUE) {
            return Property.getNoValue(this.m_type);
        }
        return this.m_value;
    }

    public Class getConstructorParameterType(int index) {
        if (this.m_index != index) {
            return null;
        }
        return this.m_type;
    }

    public Handler getHandler() {
        return this.m_handler;
    }
}

