/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.apache.felix.ipojo.ComponentFactory;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.HandlerFactory;
import org.apache.felix.ipojo.HandlerManager;
import org.apache.felix.ipojo.IPojoContext;
import org.apache.felix.ipojo.IPojoFactory;
import org.apache.felix.ipojo.architecture.ComponentTypeDescription;
import org.apache.felix.ipojo.metadata.Element;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerManagerFactory
extends ComponentFactory
implements HandlerFactory {
    private final String m_type;
    private final String m_namespace;
    private final int m_level;

    public HandlerManagerFactory(BundleContext context, Element metadata) throws ConfigurationException {
        super(context, metadata);
        this.m_factoryName = metadata.getAttribute("name");
        if (this.m_factoryName == null) {
            throw new ConfigurationException("A Handler needs a name");
        }
        String type = metadata.getAttribute("type");
        this.m_type = type != null ? type : "primitive";
        String level = metadata.getAttribute("level");
        this.m_level = level != null ? new Integer(level) : Integer.MAX_VALUE;
        String namespace = metadata.getAttribute("namespace");
        this.m_namespace = namespace != null ? namespace.toLowerCase() : "org.apache.felix.ipojo";
    }

    @Override
    public String getNamespace() {
        return this.m_namespace;
    }

    @Override
    public String getHandlerName() {
        return this.m_namespace + ":" + this.getName();
    }

    @Override
    public String getType() {
        return this.m_type;
    }

    @Override
    public int getStartLevel() {
        return this.m_level;
    }

    @Override
    public ComponentTypeDescription getComponentTypeDescription() {
        return new HandlerTypeDescription(this);
    }

    @Override
    public String getFactoryName() {
        if (this.m_type != null && "composite".equals(this.m_type) && "org.apache.felix.ipojo".equals(this.m_namespace)) {
            return this.m_namespace + ".composite:" + this.getName();
        }
        return this.getHandlerName();
    }

    @Override
    public void stopping() {
        if (this.m_tracker != null) {
            this.m_tracker.close();
            this.m_tracker = null;
        }
    }

    @Override
    public ComponentInstance createInstance(Dictionary configuration, IPojoContext context, HandlerManager[] handlers) throws ConfigurationException {
        HandlerManager instance = new HandlerManager(this, context, handlers);
        instance.configure(this.m_componentMetadata, configuration);
        return instance;
    }

    @Override
    public List<IPojoFactory.RequiredHandler> getRequiredHandlerList() {
        ArrayList<IPojoFactory.RequiredHandler> list = new ArrayList<IPojoFactory.RequiredHandler>();
        Element[] elems = this.m_componentMetadata.getElements();
        for (int i = 0; i < elems.length; ++i) {
            IPojoFactory.RequiredHandler req;
            Element current = elems[i];
            if ("manipulation".equals(current.getName()) || list.contains(req = new IPojoFactory.RequiredHandler(this, current.getName(), current.getNameSpace()))) continue;
            list.add(req);
        }
        String arch = this.m_componentMetadata.getAttribute("architecture");
        if (arch != null && arch.equalsIgnoreCase("true")) {
            list.add(new IPojoFactory.RequiredHandler(this, "architecture", null));
        }
        return list;
    }

    private class HandlerTypeDescription
    extends ComponentTypeDescription {
        public HandlerTypeDescription(IPojoFactory factory) {
            super(factory);
        }

        public Dictionary getPropertiesToPublish() {
            Dictionary<String, Object> props = super.getPropertiesToPublish();
            props.put("handler.name", HandlerManagerFactory.this.m_factoryName);
            props.put("handler.namespace", HandlerManagerFactory.this.m_namespace);
            props.put("handler.type", HandlerManagerFactory.this.m_type);
            if (HandlerManagerFactory.this.m_level != Integer.MAX_VALUE) {
                props.put("handler.level", new Integer(HandlerManagerFactory.this.m_level));
            }
            return props;
        }

        public String[] getFactoryInterfacesToPublish() {
            return new String[]{HandlerFactory.class.getName()};
        }
    }
}

