/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Instance {
    private String factory;
    private String name;
    private List<Property> configuration;

    public static Instance instance() {
        return new Instance();
    }

    public static <T> FluentList<T> list(T ... items) {
        return new FluentList<T>(items);
    }

    public static <K, T> FluentMap<K, T> map(Pair<K, T> ... pairs) {
        return new FluentMap<K, T>(pairs);
    }

    public static <K, T> Pair<K, T> pair(K k, T v) {
        return new Pair<K, T>(k, v);
    }

    public static <K, T> Pair<K, T> entry(K k, T v) {
        return new Pair<K, T>(k, v);
    }

    public String factory() {
        return this.factory;
    }

    public String name() {
        return this.name;
    }

    public Dictionary<String, Object> configuration() {
        Hashtable<String, Object> configuration = new Hashtable<String, Object>();
        if (this.configuration != null) {
            for (Property property : this.configuration) {
                configuration.put(property.name, property.value);
            }
        }
        if (this.name != null) {
            configuration.put("instance.name", this.name);
        }
        return configuration;
    }

    public Instance of(String factory) {
        this.factory = factory;
        return this;
    }

    public Instance of(Class clazz) {
        this.factory = clazz.getName();
        return this;
    }

    public Instance named(String name) {
        this.name = name;
        return this;
    }

    public Property<Object> with(String property) {
        if (this.configuration == null) {
            this.configuration = new ArrayList<Property>();
        }
        Property<Object> prop = new Property<Object>(property);
        this.configuration.add(prop);
        return prop;
    }

    public Instance nameIfUnnamed(String name) {
        if (this.name == null) {
            this.name = name;
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Property<T> {
        private final String name;
        private T value;

        Property(String name) {
            this.name = name;
        }

        public Instance setto(T value) {
            this.value = value;
            return Instance.this;
        }

        public T get() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Pair<K, V> {
        private final K key;
        private final V value;

        Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FluentMap<K, T>
    extends LinkedHashMap<K, T> {
        public FluentMap() {
            super(new LinkedHashMap());
        }

        public FluentMap(Pair<? extends K, ? extends T> ... pairs) {
            this();
            this.with(pairs);
        }

        public FluentMap<K, T> with(Pair<? extends K, ? extends T> ... pairs) {
            for (Pair<? extends K, ? extends T> pair : pairs) {
                this.put(((Pair)pair).key, ((Pair)pair).value);
            }
            return this;
        }

        public FluentMap<K, T> putAt(K k, T value) {
            this.put(k, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FluentList<T>
    extends ArrayList<T> {
        public FluentList() {
            super(new ArrayList());
        }

        public FluentList(T ... items) {
            this();
            this.addAll(Arrays.asList(items));
        }

        public FluentList<T> with(T o) {
            this.add(o);
            return this;
        }
    }
}

