/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Set;
import org.apache.felix.ipojo.ComponentFactory;
import org.apache.felix.ipojo.architecture.ComponentTypeDescription;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.PojoMetadata;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PrimitiveTypeDescription
extends ComponentTypeDescription {
    private Set<String> m_superClasses = new HashSet<String>();
    private Set<String> m_interfaces = new HashSet<String>();
    private ComponentFactory m_factory;

    public PrimitiveTypeDescription(ComponentFactory factory) {
        super(factory);
        this.m_factory = factory;
        try {
            if (factory.getClassName() != null) {
                new InheritanceInspector(factory.getPojoMetadata(), this.getBundleContext().getBundle()).computeInterfacesAndSuperClasses(this.m_interfaces, this.m_superClasses);
            }
        }
        catch (ClassNotFoundException e) {
            this.m_interfaces.clear();
            this.m_superClasses.clear();
        }
    }

    @Override
    public Dictionary<String, Object> getPropertiesToPublish() {
        Dictionary<String, Object> dict = super.getPropertiesToPublish();
        if (this.m_factory.getClassName() != null) {
            dict.put("component.class", this.m_factory.getClassName());
        }
        return dict;
    }

    @Override
    public Element getDescription() {
        Element elem = super.getDescription();
        elem.addAttribute(new Attribute("Implementation-Class", this.m_factory.getClassName()));
        Element inheritance = new Element("Inherited", "");
        inheritance.addAttribute(new Attribute("Interfaces", this.m_interfaces.toString()));
        inheritance.addAttribute(new Attribute("SuperClasses", this.m_superClasses.toString()));
        elem.addElement(inheritance);
        return elem;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class InheritanceInspector {
        private PojoMetadata m_pojoMetadata;
        private Bundle m_bundle;

        public InheritanceInspector(PojoMetadata pojoMetadata, Bundle bundle) {
            this.m_pojoMetadata = pojoMetadata;
            this.m_bundle = bundle;
        }

        public void computeInterfacesAndSuperClasses(Set<String> interfaces, Set<String> classes) throws ClassNotFoundException {
            String[] immediateInterfaces = this.m_pojoMetadata.getInterfaces();
            String parentClass = this.m_pojoMetadata.getSuperClass();
            for (String immediateInterface : immediateInterfaces) {
                interfaces.add(immediateInterface);
                Class clazz = this.m_bundle.loadClass(immediateInterface);
                this.collectInterfaces(clazz, interfaces, this.m_bundle);
            }
            if (parentClass != null) {
                Class clazz = this.m_bundle.loadClass(parentClass);
                this.collectInterfacesFromClass(clazz, interfaces, this.m_bundle);
                classes.add(parentClass);
                this.collectParentClassesFromClass(clazz, classes, this.m_bundle);
            }
            classes.remove(Object.class.getName());
        }

        private void collectInterfaces(Class<?> clazz, Set<String> acc, Bundle bundle) throws ClassNotFoundException {
            Class<?>[] clazzes;
            for (Class<?> clazze : clazzes = clazz.getInterfaces()) {
                acc.add(clazze.getName());
                this.collectInterfaces(clazze, acc, bundle);
            }
        }

        private void collectInterfacesFromClass(Class<?> clazz, Set<String> acc, Bundle bundle) throws ClassNotFoundException {
            Class<?>[] clazzes;
            for (Class<?> clazze : clazzes = clazz.getInterfaces()) {
                acc.add(clazze.getName());
                this.collectInterfaces(clazze, acc, bundle);
            }
            Class<?> sup = clazz.getSuperclass();
            if (sup != null) {
                this.collectInterfacesFromClass(sup, acc, bundle);
            }
        }

        private void collectParentClassesFromClass(Class<?> clazz, Set<String> acc, Bundle bundle) throws ClassNotFoundException {
            Class<?> parent = clazz.getSuperclass();
            if (parent != null) {
                acc.add(parent.getName());
                this.collectParentClassesFromClass(parent, acc, bundle);
            }
        }
    }
}

