/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.felix.ipojo.context.ServiceReferenceImpl;
import org.apache.felix.ipojo.util.SecurityHelper;
import org.apache.felix.ipojo.util.TrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class Tracker
implements TrackerCustomizer {
    protected BundleContext m_context;
    protected Filter m_filter;
    protected TrackerCustomizer m_customizer;
    protected String m_listenerFilter;
    private String m_trackClass;
    private ServiceReference m_trackReference;
    private Tracked m_tracked;
    private volatile ServiceReference m_cachedReference;
    private volatile Object m_cachedService;

    public Tracker(BundleContext context, ServiceReference reference, TrackerCustomizer customizer) {
        this.m_context = context;
        this.m_trackReference = reference;
        this.m_trackClass = null;
        this.m_customizer = customizer == null ? this : customizer;
        this.m_listenerFilter = "(service.id=" + reference.getProperty("service.id").toString() + ")";
        try {
            this.m_filter = context.createFilter(this.m_listenerFilter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("unexpected InvalidSyntaxException: " + e.getMessage());
        }
    }

    public Tracker(BundleContext context, String clazz, TrackerCustomizer customizer) {
        if (!SecurityHelper.hasPermissionToGetService(clazz, context)) {
            throw new SecurityException("The bundle " + context.getBundle().getBundleId() + " does not have the permission to get the service " + clazz);
        }
        this.m_context = context;
        this.m_trackReference = null;
        this.m_trackClass = clazz;
        this.m_customizer = customizer == null ? this : customizer;
        this.m_listenerFilter = "(objectClass=" + clazz + ")";
        try {
            this.m_filter = context.createFilter(this.m_listenerFilter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("unexpected InvalidSyntaxException: " + e.getMessage());
        }
    }

    public Tracker(BundleContext context, Filter filter, TrackerCustomizer customizer) {
        this.m_context = context;
        this.m_trackReference = null;
        this.m_trackClass = null;
        this.m_listenerFilter = null;
        this.m_filter = filter;
        this.m_customizer = customizer == null ? this : customizer;
        if (context == null || filter == null) {
            throw new NullPointerException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void open() {
        if (this.m_tracked != null) {
            return;
        }
        Tracked tracked = this.m_tracked = new Tracked();
        synchronized (tracked) {
            try {
                this.m_context.addServiceListener((ServiceListener)this.m_tracked, this.m_listenerFilter);
                ServiceReference[] references = this.m_listenerFilter == null ? this.getInitialReferences(null, this.m_filter.toString()) : (this.m_trackClass == null ? new ServiceReference[]{this.m_trackReference} : this.getInitialReferences(this.m_trackClass, null));
                this.m_tracked.setInitialServices(references);
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalStateException("unexpected InvalidSyntaxException: " + e.getMessage());
            }
        }
        this.m_tracked.trackInitialServices();
    }

    private ServiceReference[] getInitialReferences(String trackClass, String filterString) throws InvalidSyntaxException {
        return this.m_context.getServiceReferences(trackClass, filterString);
    }

    public synchronized void close() {
        if (this.m_tracked == null) {
            return;
        }
        this.m_tracked.close();
        ServiceReference[] references = this.getServiceReferences();
        Tracked outgoing = this.m_tracked;
        try {
            this.m_context.removeServiceListener((ServiceListener)outgoing);
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        if (references != null) {
            for (int i = 0; i < references.length; ++i) {
                outgoing.untrack(references[i]);
            }
        }
        this.m_tracked = null;
    }

    public boolean addingService(ServiceReference reference) {
        return true;
    }

    public void addedService(ServiceReference reference) {
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        this.m_context.ungetService(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object waitForService(long timeout) throws InterruptedException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        Object object = this.getService();
        while (object == null) {
            Tracked tracked = this.m_tracked;
            if (tracked == null) {
                return null;
            }
            Tracked tracked2 = tracked;
            synchronized (tracked2) {
                if (tracked.size() == 0) {
                    tracked.wait(timeout);
                }
            }
            object = this.getService();
            if (timeout <= 0L) continue;
            return object;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReference[] getServiceReferences() {
        Tracked tracked = this.m_tracked;
        if (tracked == null) {
            return null;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            int length = tracked.size();
            if (length == 0) {
                return null;
            }
            ServiceReference[] references = new ServiceReference[length];
            Iterator keys = tracked.keySet().iterator();
            for (int i = 0; i < length; ++i) {
                references[i] = (ServiceReference)keys.next();
            }
            return references;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getServiceReferencesList() {
        Tracked tracked = this.m_tracked;
        if (tracked == null) {
            return null;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            int length = tracked.size();
            if (length == 0) {
                return null;
            }
            ArrayList references = new ArrayList(length);
            Iterator keys = tracked.keySet().iterator();
            for (int i = 0; i < length; ++i) {
                references.add(keys.next());
            }
            return references;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getUsedServiceReferences() {
        Tracked tracked = this.m_tracked;
        if (tracked == null || tracked.size() == 0) {
            return null;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            int length = tracked.size();
            ArrayList references = new ArrayList();
            Iterator keys = tracked.entrySet().iterator();
            for (int i = 0; i < length; ++i) {
                Map.Entry entry = keys.next();
                Object key = entry.getKey();
                if (entry.getValue() == null) continue;
                references.add(key);
            }
            return references;
        }
    }

    public ServiceReference getServiceReference() {
        ServiceReference reference = this.m_cachedReference;
        if (reference != null) {
            return reference;
        }
        ServiceReference[] references = this.getServiceReferences();
        if (references == null) {
            return null;
        }
        this.m_cachedReference = references[0];
        return this.m_cachedReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(ServiceReference reference) {
        if (!SecurityHelper.hasPermissionToGetServices((String[])reference.getProperty("objectClass"), this.m_context)) {
            throw new SecurityException("The bundle " + this.m_context.getBundle().getBundleId() + " does not have" + " the permission to get the services " + Arrays.asList((String[])reference.getProperty("objectClass")));
        }
        Tracked tracked = this.m_tracked;
        if (tracked == null) {
            return null;
        }
        Object object = null;
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            object = tracked.get(reference);
            if (object == null) {
                if (tracked.containsKey(reference)) {
                    object = this.m_context.getService(reference);
                    tracked.put(reference, object);
                    return object;
                }
            } else {
                return object;
            }
            return this.m_context.getService(reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ungetService(ServiceReference reference) {
        Tracked tracked = this.m_tracked;
        if (tracked == null) {
            return;
        }
        Object object = null;
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            object = tracked.get(reference);
        }
        if (object != null) {
            this.m_context.ungetService(reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getServices() {
        Tracked tracked = this.m_tracked;
        if (tracked == null) {
            return null;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            ServiceReference[] references = this.getServiceReferences();
            int length = 0;
            if (references == null) {
                return null;
            }
            length = references.length;
            Object[] objects = new Object[length];
            for (int i = 0; i < length; ++i) {
                objects[i] = this.getService(references[i]);
            }
            return objects;
        }
    }

    public Object getService() {
        Object service = this.m_cachedService;
        if (service != null) {
            return service;
        }
        ServiceReference reference = this.getServiceReference();
        if (reference == null) {
            return null;
        }
        this.m_cachedService = this.getService(reference);
        return this.m_cachedService;
    }

    public void remove(ServiceReference reference) {
        Tracked tracked = this.m_tracked;
        if (tracked == null) {
            return;
        }
        tracked.untrack(reference);
    }

    public int size() {
        Tracked tracked = this.m_tracked;
        if (tracked == null) {
            return 0;
        }
        return tracked.size();
    }

    class Tracked
    extends HashMap
    implements ServiceListener {
        static final long serialVersionUID = -7420065199791006079L;
        private List m_adding = new ArrayList(6);
        private volatile boolean m_closed = false;
        private List m_initial = new LinkedList();

        protected Tracked() {
        }

        protected void setInitialServices(ServiceReference[] references) {
            if (references == null) {
                return;
            }
            int size = references.length;
            for (int i = 0; i < size; ++i) {
                this.m_initial.add(references[i]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void trackInitialServices() {
            while (true) {
                ServiceReference reference;
                Tracked tracked = this;
                synchronized (tracked) {
                    if (this.m_initial.isEmpty()) {
                        return;
                    }
                    reference = (ServiceReference)((LinkedList)this.m_initial).removeFirst();
                    if (this.containsKey(reference)) {
                        continue;
                    }
                    if (this.m_adding.contains(reference)) {
                        continue;
                    }
                    this.m_adding.add(reference);
                }
                this.trackAdding(reference);
            }
        }

        protected void close() {
            this.m_closed = true;
        }

        public void serviceChanged(ServiceEvent event) {
            if (this.m_closed) {
                return;
            }
            ServiceReference reference = event.getServiceReference();
            switch (event.getType()) {
                case 1: 
                case 2: {
                    if (Tracker.this.m_listenerFilter == null) {
                        boolean match = true;
                        match = reference instanceof ServiceReferenceImpl ? Tracker.this.m_filter.match(((ServiceReferenceImpl)reference).getProperties()) : Tracker.this.m_filter.match(reference);
                        if (match) {
                            this.track(reference);
                            break;
                        }
                        this.untrack(reference);
                        break;
                    }
                    this.track(reference);
                    break;
                }
                case 4: {
                    this.untrack(reference);
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void track(ServiceReference reference) {
            Object object;
            boolean alreadyTracked;
            Tracked tracked = this;
            synchronized (tracked) {
                alreadyTracked = this.containsKey(reference);
                object = this.get(reference);
            }
            if (alreadyTracked) {
                if (object != null) {
                    tracked = this;
                    synchronized (tracked) {
                        this.modified();
                    }
                }
                Tracker.this.m_customizer.modifiedService(reference, object);
                return;
            }
            tracked = this;
            synchronized (tracked) {
                if (this.m_adding.contains(reference)) {
                    return;
                }
                this.m_adding.add(reference);
            }
            this.trackAdding(reference);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void trackAdding(ServiceReference reference) {
            boolean mustBeTracked = false;
            boolean becameUntracked = false;
            boolean mustCallAdded = false;
            try {
                mustBeTracked = Tracker.this.m_customizer.addingService(reference);
            }
            finally {
                Tracked tracked = this;
                synchronized (tracked) {
                    if (this.m_adding.remove(reference)) {
                        if (mustBeTracked) {
                            this.put(reference, null);
                            this.modified();
                            mustCallAdded = true;
                            this.notifyAll();
                        }
                    } else {
                        becameUntracked = true;
                        Tracker.this.ungetService(reference);
                        this.modified();
                    }
                }
            }
            if (becameUntracked) {
                Tracker.this.m_customizer.removedService(reference, null);
            } else if (mustCallAdded) {
                Tracker.this.m_customizer.addedService(reference);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void untrack(ServiceReference reference) {
            Object object;
            Tracked tracked = this;
            synchronized (tracked) {
                if (this.m_initial.remove(reference)) {
                    return;
                }
                if (this.m_adding.remove(reference)) {
                    return;
                }
                boolean isTraked = this.containsKey(reference);
                object = this.remove(reference);
                if (!isTraked) {
                    return;
                }
                this.modified();
            }
            Tracker.this.m_customizer.removedService(reference, object);
        }

        void modified() {
            Tracker.this.m_cachedReference = null;
            Tracker.this.m_cachedService = null;
        }
    }
}

