/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.util;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServicePermission;

public class SecurityHelper {
    public static BundleContext selectContextToRegisterServices(String[] itfs, BundleContext comp, BundleContext ipojo) {
        if (System.getSecurityManager() != null) {
            for (int i = 0; i < itfs.length; ++i) {
                ServicePermission perm = new ServicePermission(itfs[i], "register");
                if (comp.getBundle().hasPermission((Object)perm)) continue;
                return ipojo;
            }
        }
        return comp;
    }

    public static BundleContext selectContextToRegisterService(String itf, BundleContext comp, BundleContext ipojo) {
        if (System.getSecurityManager() != null) {
            ServicePermission perm = new ServicePermission(itf, "register");
            if (!comp.getBundle().hasPermission((Object)perm)) {
                return ipojo;
            }
        }
        return comp;
    }

    public static BundleContext selectContextToGetService(String itf, BundleContext comp, BundleContext ipojo) {
        if (System.getSecurityManager() != null) {
            ServicePermission perm = new ServicePermission(itf, "get");
            if (!comp.getBundle().hasPermission((Object)perm)) {
                return ipojo;
            }
        }
        return comp;
    }

    public static boolean hasPermissionToGetService(String itf, BundleContext comp) {
        if (System.getSecurityManager() != null) {
            ServicePermission perm = new ServicePermission(itf, "get");
            return comp.getBundle().hasPermission((Object)perm);
        }
        return true;
    }

    public static boolean hasPermissionToGetServices(String[] itfs, BundleContext comp) {
        if (System.getSecurityManager() != null) {
            for (int i = 0; i < itfs.length; ++i) {
                ServicePermission perm = new ServicePermission(itfs[i], "get");
                if (comp.getBundle().hasPermission((Object)perm)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean hasPermissionToRegisterService(String itf, BundleContext comp) {
        if (System.getSecurityManager() != null) {
            ServicePermission perm = new ServicePermission(itf, "register");
            return comp.getBundle().hasPermission((Object)perm);
        }
        return true;
    }

    public static boolean hasPermissionToRegisterServices(String[] itfs, BundleContext comp) {
        if (System.getSecurityManager() != null) {
            for (int i = 0; i < itfs.length; ++i) {
                ServicePermission perm = new ServicePermission(itfs[i], "register");
                if (comp.getBundle().hasPermission((Object)perm)) continue;
                return false;
            }
        }
        return true;
    }
}

