/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.manipulator.Pojoization;
import org.osgi.framework.BundleContext;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;

public class IPOJOURLHandler
extends AbstractURLStreamHandlerService
implements URLStreamHandlerService,
Pojo {
    private InstanceManager __IM;
    private boolean __Fm_context;
    private BundleContext m_context;
    private boolean __Fm_temp;
    private File m_temp;
    private boolean __Mstop;
    private boolean __MopenConnection$java_net_URL;
    private boolean __Msave$java_net_URL$java_io_File;
    private boolean __Msave$java_io_InputStream$java_io_File;
    private boolean __MfindMetadata$java_util_jar_JarFile;

    BundleContext __getm_context() {
        if (!this.__Fm_context) {
            return this.m_context;
        }
        return (BundleContext)this.__IM.onGet(this, "m_context");
    }

    void __setm_context(BundleContext bundleContext) {
        if (!this.__Fm_context) {
            this.m_context = bundleContext;
            return;
        }
        this.__IM.onSet(this, "m_context", bundleContext);
    }

    File __getm_temp() {
        if (!this.__Fm_temp) {
            return this.m_temp;
        }
        return (File)this.__IM.onGet(this, "m_temp");
    }

    void __setm_temp(File file) {
        if (!this.__Fm_temp) {
            this.m_temp = file;
            return;
        }
        this.__IM.onSet(this, "m_temp", file);
    }

    public IPOJOURLHandler(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private IPOJOURLHandler(InstanceManager _manager, BundleContext bc) {
        this._setInstanceManager(_manager);
        this.__setm_context(bc);
        this.__setm_temp(this.__getm_context().getDataFile("temp"));
        if (!this.__getm_temp().exists()) {
            this.__getm_temp().mkdir();
        }
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry(this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit(this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "stop", throwable);
            throw throwable;
        }
    }

    private void __M_stop() {
        File[] files = this.__getm_temp().listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                files[i].delete();
            }
        }
        this.__getm_temp().delete();
    }

    public URLConnection openConnection(URL uRL) throws IOException {
        URLConnection uRLConnection;
        if (!this.__MopenConnection$java_net_URL) {
            return this.__M_openConnection(uRL);
        }
        try {
            this.__IM.onEntry(this, "openConnection$java_net_URL", new Object[]{uRL});
            uRLConnection = this.__M_openConnection(uRL);
            this.__IM.onExit(this, "openConnection$java_net_URL", uRLConnection);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "openConnection$java_net_URL", throwable);
            throw throwable;
        }
        return uRLConnection;
    }

    private URLConnection __M_openConnection(URL url) throws IOException {
        System.out.println("Processing URL : " + url);
        String full = url.toExternalForm();
        if (full.startsWith("ipojo:")) {
            full = full.substring(6);
        }
        while (full.startsWith("/")) {
            full = full.substring(1);
        }
        full = full.trim();
        String[] urls = full.split("!");
        URL bundleURL = null;
        URL metadataURL = null;
        if (urls.length == 1) {
            System.out.println("Extracted URL : " + urls[0]);
            bundleURL = new URL(urls[0]);
        } else if (urls.length == 2) {
            bundleURL = new URL(urls[0]);
            metadataURL = new URL(urls[1]);
        } else {
            throw new MalformedURLException("The iPOJO url is not formatted correctly, ipojo:bundle_url[!metadata_url] expected");
        }
        File bundle = File.createTempFile("ipojo_", ".jar", this.__getm_temp());
        this.save(bundleURL, bundle);
        File metadata = null;
        if (metadataURL != null) {
            metadata = File.createTempFile("ipojo_", ".xml", this.__getm_temp());
            this.save(metadataURL, metadata);
        } else {
            JarFile jar = new JarFile(bundle);
            metadata = this.findMetadata(jar);
        }
        Pojoization pojoizator = new Pojoization();
        File out = new File(this.__getm_temp(), bundle.getName() + "-ipojo.jar");
        System.out.println("Pojoization " + bundle.exists() + " - " + metadata.exists());
        try {
            pojoizator.pojoization(bundle, out, metadata);
        }
        catch (Exception e) {
            if (!pojoizator.getErrors().isEmpty()) {
                throw new IOException("Errors occured during the manipulation : " + pojoizator.getErrors());
            }
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        if (!pojoizator.getErrors().isEmpty()) {
            throw new IOException("Errors occured during the manipulation : " + pojoizator.getErrors());
        }
        if (!pojoizator.getWarnings().isEmpty()) {
            System.err.println("Warnings occured during the manipulation : " + pojoizator.getWarnings());
        }
        System.out.println("Manipulation done : " + out.exists());
        bundle.delete();
        if (metadata != null) {
            metadata.delete();
        }
        out.deleteOnExit();
        return out.toURI().toURL().openConnection();
    }

    private void save(URL uRL, File file) throws IOException {
        if (!this.__Msave$java_net_URL$java_io_File) {
            this.__M_save(uRL, file);
            return;
        }
        try {
            this.__IM.onEntry(this, "save$java_net_URL$java_io_File", new Object[]{uRL, file});
            this.__M_save(uRL, file);
            this.__IM.onExit(this, "save$java_net_URL$java_io_File", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "save$java_net_URL$java_io_File", throwable);
            throw throwable;
        }
    }

    private void __M_save(URL url, File file) throws IOException {
        InputStream is = url.openStream();
        this.save(is, file);
    }

    private void save(InputStream inputStream, File file) throws IOException {
        if (!this.__Msave$java_io_InputStream$java_io_File) {
            this.__M_save(inputStream, file);
            return;
        }
        try {
            this.__IM.onEntry(this, "save$java_io_InputStream$java_io_File", new Object[]{inputStream, file});
            this.__M_save(inputStream, file);
            this.__IM.onExit(this, "save$java_io_InputStream$java_io_File", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "save$java_io_InputStream$java_io_File", throwable);
            throw throwable;
        }
    }

    private void __M_save(InputStream is, File file) throws IOException {
        int i;
        FileOutputStream writer = new FileOutputStream(file);
        int cc = 0;
        while ((i = is.read()) != -1) {
            ++cc;
            writer.write(i);
        }
        System.out.println(cc + " bytes copied");
        is.close();
        writer.close();
    }

    private File findMetadata(JarFile jarFile) throws IOException {
        File file;
        if (!this.__MfindMetadata$java_util_jar_JarFile) {
            return this.__M_findMetadata(jarFile);
        }
        try {
            this.__IM.onEntry(this, "findMetadata$java_util_jar_JarFile", new Object[]{jarFile});
            file = this.__M_findMetadata(jarFile);
            this.__IM.onExit(this, "findMetadata$java_util_jar_JarFile", file);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "findMetadata$java_util_jar_JarFile", throwable);
            throw throwable;
        }
        return file;
    }

    private File __M_findMetadata(JarFile jar) throws IOException {
        JarEntry je = jar.getJarEntry("metadata.xml");
        if (je == null) {
            je = jar.getJarEntry("META-INF/metadata.xml");
        }
        if (je == null) {
            System.out.println("Metadata file not found, use annotations only.");
            return null;
        }
        System.out.println("Metadata file found: " + je.getName());
        File metadata = File.createTempFile("ipojo_", ".xml", this.__getm_temp());
        this.save(jar.getInputStream(je), metadata);
        System.out.println("Metadata file saved to " + metadata.getAbsolutePath());
        return metadata;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("m_context")) {
                this.__Fm_context = true;
            }
            if (set.contains("m_temp")) {
                this.__Fm_temp = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("openConnection$java_net_URL")) {
                this.__MopenConnection$java_net_URL = true;
            }
            if (set.contains("save$java_net_URL$java_io_File")) {
                this.__Msave$java_net_URL$java_io_File = true;
            }
            if (set.contains("save$java_io_InputStream$java_io_File")) {
                this.__Msave$java_io_InputStream$java_io_File = true;
            }
            if (set.contains("findMetadata$java_util_jar_JarFile")) {
                this.__MfindMetadata$java_util_jar_JarFile = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

