/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulation.annotations;

import java.lang.reflect.Array;
import org.apache.felix.ipojo.manipulation.annotations.MetadataCollector;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;

public class CustomAnnotationVisitor
extends EmptyVisitor
implements AnnotationVisitor {
    private Element m_elem;
    private String m_id;
    private String m_parent;
    private boolean m_root;
    private boolean m_classAnnotation;
    private MetadataCollector m_collector;
    private boolean m_isParameterAnnotation = false;
    private int m_index = -1;
    private String m_desc;

    public CustomAnnotationVisitor(Element elem, MetadataCollector collector, boolean root, boolean clazz) {
        this.m_elem = elem;
        this.m_root = root;
        this.m_collector = collector;
        this.m_classAnnotation = clazz;
    }

    public CustomAnnotationVisitor(Element elem, MetadataCollector collector, boolean root, boolean clazz, int index, String descriptor) {
        this.m_elem = elem;
        this.m_root = root;
        this.m_collector = collector;
        this.m_classAnnotation = clazz;
        this.m_isParameterAnnotation = true;
        this.m_index = index;
        this.m_desc = descriptor;
    }

    public static boolean isCustomAnnotation(String desc) {
        return (desc = desc.toLowerCase()).indexOf("ipojo") != -1 || desc.indexOf("handler") != -1;
    }

    public static Element buildElement(String desc) {
        String s = desc.replace('/', '.').substring(1, desc.length() - 1);
        int index = s.lastIndexOf(46);
        String name = s.substring(index + 1);
        String namespace = s.substring(0, index);
        return new Element(name, namespace);
    }

    public void visit(String arg0, Object arg1) {
        if (arg1.getClass().isArray()) {
            String v = null;
            int index = Array.getLength(arg1);
            for (int i = 0; i < index; ++i) {
                v = v == null ? "{" + Array.get(arg1, i) : v + "," + Array.get(arg1, i);
            }
            v = v + "}";
            this.m_elem.addAttribute(new Attribute(arg0, v));
            return;
        }
        if (!(arg1 instanceof Type)) {
            this.m_elem.addAttribute(new Attribute(arg0, arg1.toString()));
        } else {
            this.m_elem.addAttribute(new Attribute(arg0, ((Type)arg1).getClassName()));
        }
        if (this.m_root) {
            if (arg0.equals("id")) {
                this.m_id = arg1.toString();
            } else if (arg0.equals("parent")) {
                this.m_parent = arg1.toString();
            }
        }
    }

    public AnnotationVisitor visitAnnotation(String arg0, String arg1) {
        Element elem = CustomAnnotationVisitor.buildElement(arg1);
        this.m_elem.addElement(elem);
        return new CustomAnnotationVisitor(elem, this.m_collector, false, false);
    }

    public AnnotationVisitor visitArray(String arg0) {
        return new SubArrayVisitor(this.m_elem, arg0);
    }

    public void visitEnum(String arg0, String arg1, String arg2) {
        this.m_elem.addAttribute(new Attribute(arg0, arg2));
    }

    public void visitEnd() {
        if (this.m_root) {
            if (this.m_id != null) {
                this.m_collector.getIds().put(this.m_id, this.m_elem);
            } else {
                this.m_id = this.m_elem.getNameSpace();
                if (!this.m_collector.getIds().containsKey(this.m_elem.getNameSpace()) && this.m_classAnnotation) {
                    this.m_collector.getIds().put(this.m_elem.getNameSpace(), this.m_elem);
                } else if (this.m_parent == null) {
                    this.m_parent = this.m_elem.getNameSpace();
                }
            }
            this.m_collector.getElements().put(this.m_elem, this.m_parent);
            if (this.m_isParameterAnnotation) {
                String t = Type.getArgumentTypes(this.m_desc)[this.m_index].getClassName();
                this.m_elem.addAttribute(new Attribute("type", t));
                this.m_elem.addAttribute(new Attribute("constructor-parameter", Integer.toString(this.m_index)));
            }
        }
    }

    private class SubArrayVisitor
    extends EmptyVisitor
    implements AnnotationVisitor {
        private Element m_elem;
        private String m_name;
        private String m_acc;

        public SubArrayVisitor(Element elem, String name) {
            this.m_elem = elem;
            this.m_name = name;
        }

        public void visit(String arg0, Object arg1) {
            this.m_acc = this.m_acc == null ? (!(arg1 instanceof Type) ? "{" + arg1.toString() : "{" + ((Type)arg1).getClassName()) : (!(arg1 instanceof Type) ? this.m_acc + "," + arg1.toString() : this.m_acc + "," + ((Type)arg1).getClassName());
        }

        public AnnotationVisitor visitAnnotation(String arg0, String arg1) {
            Element elem = CustomAnnotationVisitor.buildElement(arg1);
            this.m_elem.addElement(elem);
            return new CustomAnnotationVisitor(elem, CustomAnnotationVisitor.this.m_collector, false, false);
        }

        public void visitEnd() {
            if (this.m_acc != null) {
                this.m_elem.addAttribute(new Attribute(this.m_name, this.m_acc + "}"));
            }
        }
    }
}

