/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.lifecycle.callback;

import java.lang.reflect.InvocationTargetException;
import java.util.Dictionary;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.PrimitiveHandler;
import org.apache.felix.ipojo.handlers.lifecycle.callback.LifecycleCallback;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.MethodMetadata;
import org.apache.felix.ipojo.parser.PojoMetadata;

public class LifecycleCallbackHandler
extends PrimitiveHandler
implements Pojo {
    private InstanceManager __IM;
    private boolean __Fm_callbacks;
    private LifecycleCallback[] m_callbacks;
    private boolean __Fm_state;
    private int m_state;
    private boolean __Fm_immediate;
    private boolean m_immediate;
    private boolean __MaddCallback$org_apache_felix_ipojo_handlers_lifecycle_callback_LifecycleCallback;
    private boolean __Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary;
    private boolean __Mstart;
    private boolean __Mstop;
    private boolean __MstateChanged$int;

    LifecycleCallback[] __getm_callbacks() {
        if (!this.__Fm_callbacks) {
            return this.m_callbacks;
        }
        return (LifecycleCallback[])this.__IM.onGet(this, "m_callbacks");
    }

    void __setm_callbacks(LifecycleCallback[] lifecycleCallbackArray) {
        if (!this.__Fm_callbacks) {
            this.m_callbacks = lifecycleCallbackArray;
            return;
        }
        this.__IM.onSet(this, "m_callbacks", lifecycleCallbackArray);
    }

    int __getm_state() {
        if (!this.__Fm_state) {
            return this.m_state;
        }
        Object object = this.__IM.onGet(this, "m_state");
        Integer n = (Integer)object;
        return n;
    }

    void __setm_state(int n) {
        if (!this.__Fm_state) {
            this.m_state = n;
            return;
        }
        Integer n2 = new Integer(n);
        this.__IM.onSet(this, "m_state", n2);
    }

    boolean __getm_immediate() {
        if (!this.__Fm_immediate) {
            return this.m_immediate;
        }
        Object object = this.__IM.onGet(this, "m_immediate");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setm_immediate(boolean bl) {
        if (!this.__Fm_immediate) {
            this.m_immediate = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet(this, "m_immediate", bl2);
    }

    public LifecycleCallbackHandler() {
        this(null);
    }

    private LifecycleCallbackHandler(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setm_callbacks(new LifecycleCallback[0]);
        this.__setm_state(1);
        this.__setm_immediate(false);
    }

    private void addCallback(LifecycleCallback lifecycleCallback) {
        if (!this.__MaddCallback$org_apache_felix_ipojo_handlers_lifecycle_callback_LifecycleCallback) {
            this.__M_addCallback(lifecycleCallback);
            return;
        }
        try {
            this.__IM.onEntry(this, "addCallback$org_apache_felix_ipojo_handlers_lifecycle_callback_LifecycleCallback", new Object[]{lifecycleCallback});
            this.__M_addCallback(lifecycleCallback);
            this.__IM.onExit(this, "addCallback$org_apache_felix_ipojo_handlers_lifecycle_callback_LifecycleCallback", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "addCallback$org_apache_felix_ipojo_handlers_lifecycle_callback_LifecycleCallback", throwable);
            throw throwable;
        }
    }

    private void __M_addCallback(LifecycleCallback callback) {
        for (int i = 0; this.__getm_callbacks() != null && i < this.__getm_callbacks().length; ++i) {
            if (this.__getm_callbacks()[i] != callback) continue;
            return;
        }
        if (this.__getm_callbacks() != null && this.__getm_callbacks().length > 0) {
            LifecycleCallback[] newHk = new LifecycleCallback[this.__getm_callbacks().length + 1];
            System.arraycopy(this.__getm_callbacks(), 0, newHk, 0, this.__getm_callbacks().length);
            newHk[this.__getm_callbacks().length] = callback;
            this.__setm_callbacks(newHk);
        } else {
            this.__setm_callbacks(new LifecycleCallback[]{callback});
        }
    }

    public void configure(Element element, Dictionary dictionary) throws ConfigurationException {
        if (!this.__Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary) {
            this.__M_configure(element, dictionary);
            return;
        }
        try {
            this.__IM.onEntry(this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", new Object[]{element, dictionary});
            this.__M_configure(element, dictionary);
            this.__IM.onExit(this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", throwable);
            throw throwable;
        }
    }

    private void __M_configure(Element metadata, Dictionary configuration) throws ConfigurationException {
        this.__setm_callbacks(new LifecycleCallback[0]);
        String imm = metadata.getAttribute("immediate");
        this.__setm_immediate(imm != null && imm.equalsIgnoreCase("true"));
        PojoMetadata meta = this.getFactory().getPojoMetadata();
        Element[] hooksMetadata = metadata.getElements("callback");
        for (int i = 0; hooksMetadata != null && i < hooksMetadata.length; ++i) {
            String method = hooksMetadata[i].getAttribute("method");
            if (method == null) {
                throw new ConfigurationException("Lifecycle callback : A callback needs to contain a method attribute");
            }
            MethodMetadata met = meta.getMethod(method, new String[0]);
            int transition = -1;
            String trans = hooksMetadata[i].getAttribute("transition");
            if (trans == null) {
                throw new ConfigurationException("Lifecycle callback : the transition attribute is missing");
            }
            if (trans.equalsIgnoreCase("validate")) {
                transition = 1;
            } else if (trans.equalsIgnoreCase("invalidate")) {
                transition = 0;
            } else {
                throw new ConfigurationException("Lifecycle callback : Unknown or malformed transition : " + trans);
            }
            LifecycleCallback callback = null;
            callback = met == null ? new LifecycleCallback(this, transition, method) : new LifecycleCallback(this, transition, met);
            this.addCallback(callback);
        }
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry(this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit(this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "start", throwable);
            throw throwable;
        }
    }

    private void __M_start() {
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry(this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit(this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "stop", throwable);
            throw throwable;
        }
    }

    private void __M_stop() {
        this.__setm_state(1);
    }

    public void stateChanged(int n) {
        if (!this.__MstateChanged$int) {
            this.__M_stateChanged(n);
            return;
        }
        try {
            this.__IM.onEntry(this, "stateChanged$int", new Object[]{new Integer(n)});
            this.__M_stateChanged(n);
            this.__IM.onExit(this, "stateChanged$int", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "stateChanged$int", throwable);
            throw throwable;
        }
    }

    private void __M_stateChanged(int state) {
        int transition = -1;
        if (this.__getm_state() == 1 && state == 2) {
            transition = 1;
        }
        if (this.__getm_state() == 2 && state == 1) {
            transition = 0;
        }
        if (this.__getm_immediate() && transition == 1 && this.getInstanceManager().getPojoObjects() == null) {
            this.getInstanceManager().getPojoObject();
        }
        for (int i = 0; i < this.__getm_callbacks().length; ++i) {
            if (this.__getm_callbacks()[i].getTransition() != transition) continue;
            try {
                this.__getm_callbacks()[i].call();
                continue;
            }
            catch (NoSuchMethodException e) {
                this.error("[" + this.getInstanceManager().getInstanceName() + "] The callback method " + this.__getm_callbacks()[i].getMethod() + " is not found");
                throw new IllegalStateException(e.getMessage());
            }
            catch (IllegalAccessException e) {
                this.error("[" + this.getInstanceManager().getInstanceName() + "] The callback method " + this.__getm_callbacks()[i].getMethod() + " is not accessible");
                throw new IllegalStateException(e.getMessage());
            }
            catch (InvocationTargetException e) {
                this.error("[" + this.getInstanceManager().getInstanceName() + "] The callback method " + this.__getm_callbacks()[i].getMethod() + " has thrown an exception : " + e.getTargetException().getMessage(), e.getTargetException());
                throw new IllegalStateException(e.getTargetException().getMessage());
            }
        }
        this.__setm_state(state);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("m_callbacks")) {
                this.__Fm_callbacks = true;
            }
            if (set.contains("m_immediate")) {
                this.__Fm_immediate = true;
            }
            if (set.contains("m_state")) {
                this.__Fm_state = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("addCallback$org_apache_felix_ipojo_handlers_lifecycle_callback_LifecycleCallback")) {
                this.__MaddCallback$org_apache_felix_ipojo_handlers_lifecycle_callback_LifecycleCallback = true;
            }
            if (set.contains("configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary")) {
                this.__Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary = true;
            }
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("stateChanged$int")) {
                this.__MstateChanged$int = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

