/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.jar.Manifest;
import org.apache.felix.ipojo.manipulator.ResourceStore;
import org.apache.felix.ipojo.manipulator.ResourceVisitor;
import org.apache.felix.ipojo.manipulator.store.ManifestBuilder;
import org.apache.felix.ipojo.manipulator.store.ResourceMapper;
import org.apache.felix.ipojo.manipulator.store.mapper.FileSystemResourceMapper;
import org.apache.felix.ipojo.manipulator.store.mapper.IdentityResourceMapper;
import org.apache.felix.ipojo.manipulator.util.Metadatas;
import org.apache.felix.ipojo.manipulator.util.Streams;
import org.apache.felix.ipojo.metadata.Element;

public class DirectoryResourceStore
implements ResourceStore {
    private File m_source;
    private File m_target;
    private ManifestBuilder m_manifestBuilder;
    private Manifest m_manifest;
    private File m_manifest_file;
    private ResourceMapper m_mapper = new FileSystemResourceMapper(new IdentityResourceMapper());

    public DirectoryResourceStore(File source) {
        this(source, source);
    }

    public DirectoryResourceStore(File source, File target) {
        this.m_source = source;
        this.m_target = target;
    }

    public void setResourceMapper(ResourceMapper mapper) {
        this.m_mapper = new FileSystemResourceMapper(mapper);
    }

    public void setManifestBuilder(ManifestBuilder manifestBuilder) {
        this.m_manifestBuilder = manifestBuilder;
    }

    public void setManifest(Manifest manifest) {
        this.m_manifest = manifest;
    }

    public void setManifestFile(File manifestFile) {
        this.m_manifest_file = manifestFile;
    }

    public byte[] read(String path) throws IOException {
        File resource = new File(this.m_source, this.m_mapper.internalize(path));
        if (!resource.isFile()) {
            throw new IOException("File '" + resource + "' is not found (for class " + path + ").");
        }
        return Streams.readBytes(new FileInputStream(resource));
    }

    public void accept(ResourceVisitor visitor) {
        this.traverseDirectory(this.m_source, visitor);
    }

    private void traverseDirectory(File directory, ResourceVisitor visitor) {
        for (File child : directory.listFiles()) {
            if (child.isDirectory()) {
                this.traverseDirectory(child, visitor);
                continue;
            }
            visitor.visit(this.getRelativeName(child));
        }
    }

    private String getRelativeName(File file) {
        String relative = file.getPath().substring(this.m_source.getPath().length());
        return this.m_mapper.externalize(relative);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        Manifest updated = this.m_manifestBuilder.build(this.m_manifest);
        FileOutputStream os = new FileOutputStream(this.m_manifest_file);
        try {
            updated.write(os);
        }
        catch (Throwable throwable) {
            Streams.close(os);
            throw throwable;
        }
        Streams.close(os);
    }

    public void writeMetadata(Element metadata) {
        this.m_manifestBuilder.addMetada(Collections.singletonList(metadata));
        this.m_manifestBuilder.addReferredPackage(Metadatas.findReferredPackages(metadata));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String resourcePath, byte[] bytecode) throws IOException {
        File resource = new File(this.m_target, this.m_mapper.internalize(resourcePath));
        if (!resource.getParentFile().exists()) {
            resource.getParentFile().mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(resource);
        try {
            fos.write(bytecode);
            fos.flush();
        }
        catch (Throwable throwable) {
            Streams.close(fos);
            throw throwable;
        }
        Streams.close(fos);
    }

    public void close() throws IOException {
    }
}

