/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.visitor.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.felix.ipojo.manipulator.ManipulationResultVisitor;
import org.apache.felix.ipojo.manipulator.ManipulationVisitor;
import org.apache.felix.ipojo.manipulator.Reporter;
import org.apache.felix.ipojo.manipulator.ResourceStore;
import org.apache.felix.ipojo.manipulator.visitor.writer.ManipulatedResultWriter;
import org.apache.felix.ipojo.metadata.Element;

public class ManipulatedResourcesWriter
implements ManipulationVisitor {
    private ResourceStore m_resourceStore;
    private Reporter m_reporter;
    private List<ManipulatedResultWriter> m_writers = new ArrayList<ManipulatedResultWriter>();

    public void setResourceStore(ResourceStore resourceStore) {
        this.m_resourceStore = resourceStore;
    }

    public void setReporter(Reporter reporter) {
        this.m_reporter = reporter;
    }

    public ManipulationResultVisitor visitManipulationResult(Element metadata) {
        this.m_resourceStore.writeMetadata(metadata);
        ManipulatedResultWriter writer = new ManipulatedResultWriter(metadata);
        this.m_writers.add(writer);
        return writer;
    }

    public void visitMetadata(Element metadata) {
        this.m_resourceStore.writeMetadata(metadata);
    }

    public void visitEnd() {
        try {
            this.m_resourceStore.open();
            for (ManipulatedResultWriter writer : this.m_writers) {
                for (Map.Entry<String, byte[]> entry : writer.getResources().entrySet()) {
                    this.m_resourceStore.write(entry.getKey(), entry.getValue());
                }
            }
            this.m_resourceStore.close();
        }
        catch (IOException e) {
            this.m_reporter.error("Cannot store manipulation result: " + e.getMessage(), new Object[0]);
        }
    }
}

