/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.ipojo.manipulation.annotations.MetadataCollector;
import org.apache.felix.ipojo.manipulator.MetadataProvider;
import org.apache.felix.ipojo.manipulator.Reporter;
import org.apache.felix.ipojo.manipulator.ResourceStore;
import org.apache.felix.ipojo.manipulator.ResourceVisitor;
import org.apache.felix.ipojo.metadata.Element;
import org.objectweb.asm.ClassReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationMetadataProvider
implements MetadataProvider {
    private ResourceStore m_store;
    private Reporter m_reporter;

    public AnnotationMetadataProvider(ResourceStore store, Reporter reporter) {
        this.m_store = store;
        this.m_reporter = reporter;
    }

    @Override
    public List<Element> getMetadatas() throws IOException {
        final ArrayList<Element> metadata = new ArrayList<Element>();
        this.m_store.accept(new ResourceVisitor(){

            public void visit(String name) {
                if (name.endsWith(".class")) {
                    byte[] data = null;
                    try {
                        data = AnnotationMetadataProvider.this.m_store.read(name);
                    }
                    catch (IOException e) {
                        AnnotationMetadataProvider.this.m_reporter.warn("Cannot read content of " + name, new Object[0]);
                    }
                    if (data != null && data.length > 0) {
                        AnnotationMetadataProvider.this.computeAnnotations(data, metadata);
                    } else {
                        AnnotationMetadataProvider.this.m_reporter.error("Cannot compute annotations from " + name + " : Empty file", new Object[0]);
                    }
                }
            }
        });
        return metadata;
    }

    private void computeAnnotations(byte[] bytecode, List<Element> metadata) {
        ClassReader cr = new ClassReader(bytecode);
        MetadataCollector collector = new MetadataCollector();
        cr.accept(collector, 0);
        if (!collector.isIgnoredBecauseOfMissingComponent() && collector.isComponentType()) {
            metadata.add(collector.getComponentTypeDeclaration());
            if (collector.getInstanceDeclaration() != null) {
                metadata.add(collector.getInstanceDeclaration());
            }
        }
    }
}

