/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.jaas.internal;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.ConfigurationSpi;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.felix.jaas.LoginContextFactory;
import org.apache.felix.jaas.LoginModuleFactory;
import org.apache.felix.jaas.boot.ProxyLoginModule;
import org.apache.felix.jaas.internal.Logger;
import org.apache.felix.jaas.internal.LoginModuleProvider;
import org.apache.felix.jaas.internal.OsgiLoginModuleProvider;
import org.apache.felix.jaas.internal.Util;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ConfigSpiOsgi
extends ConfigurationSpi
implements ManagedService,
ServiceTrackerCustomizer,
LoginContextFactory {
    public static final String JAAS_CONFIG_ALGO_NAME = "JavaLoginConfig";
    public static final String SERVICE_PID = "org.apache.felix.jaas.ConfigurationSpi";
    private Map<String, Realm> configs = Collections.emptyMap();
    private final Logger log;
    private static final String DEFAULT_REALM_NAME = "other";
    private static final String JAAS_DEFAULT_REALM_NAME = "jaas.defaultRealmName";
    private String defaultRealmName;
    private static final String DEFAULT_CONFIG_PROVIDER_NAME = "FelixJaasProvider";
    private static final String JAAS_CONFIG_PROVIDER_NAME = "jaas.configProviderName";
    static final String JAAS_CONFIG_POLICY = "jaas.globalConfigPolicy";
    private final Configuration osgiConfig = new OsgiConfiguration();
    private final Configuration originalConfig;
    private final Configuration proxyConfig;
    private volatile GlobalConfigurationPolicy globalConfigPolicy = GlobalConfigurationPolicy.DEFAULT;
    private final Map<ServiceReference, LoginModuleProvider> providerMap = new ConcurrentHashMap<ServiceReference, LoginModuleProvider>();
    private volatile String jaasConfigProviderName;
    private final Object lock = new Object();
    private final BundleContext context;
    private final ServiceTracker tracker;
    private ServiceRegistration spiReg;

    public ConfigSpiOsgi(BundleContext context, Logger log) throws ConfigurationException {
        this.context = context;
        this.log = log;
        this.originalConfig = ConfigSpiOsgi.getGlobalConfiguration();
        this.proxyConfig = new DelegatingConfiguration(this.osgiConfig, this.originalConfig);
        this.updated(this.getDefaultConfig());
        this.tracker = new ServiceTracker(context, LoginModuleFactory.class.getName(), (ServiceTrackerCustomizer)this);
        Properties props = new Properties();
        props.setProperty("service.vendor", "Apache Software Foundation");
        props.setProperty("service.pid", SERVICE_PID);
        this.context.registerService(ManagedService.class.getName(), (Object)this, (Dictionary)props);
        this.context.registerService(LoginContextFactory.class.getName(), (Object)this, (Dictionary)new Properties());
    }

    @Override
    public LoginContext createLoginContext(String realm, Subject subject, CallbackHandler handler) throws LoginException {
        Thread currentThread = Thread.currentThread();
        ClassLoader cl = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(ProxyLoginModule.class.getClassLoader());
            Configuration config = Configuration.getInstance(JAAS_CONFIG_ALGO_NAME, null, this.jaasConfigProviderName);
            LoginContext loginContext = new LoginContext(realm, subject, handler, config);
            return loginContext;
        }
        catch (NoSuchProviderException e) {
            throw new LoginException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new LoginException(e.getMessage());
        }
        finally {
            currentThread.setContextClassLoader(cl);
        }
    }

    @Override
    protected AppConfigurationEntry[] engineGetAppConfigurationEntry(String name) {
        Realm realm = this.configs.get(name);
        if (realm == null) {
            this.log.log(2, "No JAAS module configured for realm " + name);
            return null;
        }
        return realm.engineGetAppConfigurationEntry();
    }

    Map<String, Realm> getAllConfiguration() {
        return this.configs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recreateConfigs() {
        HashMap<String, Realm> realmToConfigMap = new HashMap<String, Realm>();
        for (LoginModuleProvider lmp : this.providerMap.values()) {
            Realm realm;
            String realmName = lmp.realmName();
            if (realmName == null) {
                realmName = this.defaultRealmName;
            }
            if ((realm = (Realm)realmToConfigMap.get(realmName)) == null) {
                realm = new Realm(realmName);
                realmToConfigMap.put(realmName, realm);
            }
            realm.add(new AppConfigurationHolder(lmp));
        }
        for (Realm realm : realmToConfigMap.values()) {
            realm.afterPropertiesSet();
        }
        if (!realmToConfigMap.isEmpty() && this.spiReg == null) {
            Properties props = new Properties();
            props.setProperty("providerName", "felix");
            Object object = this.lock;
            synchronized (object) {
                this.spiReg = this.context.registerService(ConfigurationSpi.class.getName(), (Object)this, (Dictionary)props);
            }
        }
        Object object = this.lock;
        synchronized (object) {
            this.configs = Collections.unmodifiableMap(realmToConfigMap);
        }
    }

    void open() {
        this.configs = Collections.emptyMap();
        this.tracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        this.tracker.close();
        this.deregisterProvider(this.jaasConfigProviderName);
        Object object = this.lock;
        synchronized (object) {
            this.providerMap.clear();
            this.configs = null;
        }
        if (this.globalConfigPolicy != GlobalConfigurationPolicy.DEFAULT) {
            this.restoreOriginalConfiguration();
        }
    }

    public synchronized void updated(Dictionary properties) throws ConfigurationException {
        if (properties == null) {
            return;
        }
        String newDefaultRealmName = PropertiesUtil.toString(properties.get(JAAS_DEFAULT_REALM_NAME), DEFAULT_REALM_NAME);
        if (!newDefaultRealmName.equals(this.defaultRealmName)) {
            this.defaultRealmName = newDefaultRealmName;
            this.recreateConfigs();
        }
        String newProviderName = PropertiesUtil.toString(properties.get(JAAS_CONFIG_PROVIDER_NAME), DEFAULT_CONFIG_PROVIDER_NAME);
        this.deregisterProvider(this.jaasConfigProviderName);
        this.registerProvider(newProviderName);
        this.jaasConfigProviderName = newProviderName;
        this.manageGlobalConfiguration(properties);
    }

    private void manageGlobalConfiguration(Dictionary props) {
        String configPolicy = PropertiesUtil.toString(props.get(JAAS_CONFIG_POLICY), GlobalConfigurationPolicy.DEFAULT.name());
        configPolicy = Util.trimToNull(configPolicy);
        GlobalConfigurationPolicy policy = GlobalConfigurationPolicy.DEFAULT;
        if (configPolicy != null) {
            policy = GlobalConfigurationPolicy.valueOf(configPolicy.toUpperCase());
        }
        this.globalConfigPolicy = policy;
        if (policy == GlobalConfigurationPolicy.REPLACE) {
            Configuration.setConfiguration(this.osgiConfig);
            this.log.log(3, "Replacing the global JAAS configuration with OSGi based configuration");
        } else if (policy == GlobalConfigurationPolicy.PROXY) {
            Configuration.setConfiguration(this.proxyConfig);
            this.log.log(3, "Replacing the global JAAS configuration with OSGi based proxy configuration. It would look first in the OSGi based configuration and if not found would use the default global configuration");
        } else if (policy == GlobalConfigurationPolicy.DEFAULT) {
            this.restoreOriginalConfiguration();
        }
    }

    private void restoreOriginalConfiguration() {
        if (this.originalConfig == null) {
            return;
        }
        Configuration current = Configuration.getConfiguration();
        if (current != this.originalConfig) {
            Configuration.setConfiguration(this.originalConfig);
        }
    }

    private Dictionary<String, String> getDefaultConfig() throws ConfigurationException {
        Hashtable<String, String> dict = new Hashtable<String, String>();
        this.put(dict, JAAS_DEFAULT_REALM_NAME, DEFAULT_REALM_NAME);
        this.put(dict, JAAS_CONFIG_PROVIDER_NAME, DEFAULT_CONFIG_PROVIDER_NAME);
        this.put(dict, JAAS_CONFIG_POLICY, GlobalConfigurationPolicy.DEFAULT.name());
        return dict;
    }

    private void put(Dictionary<String, String> dict, String key, String defaultValue) {
        dict.put(key, PropertiesUtil.toString(this.context.getProperty(key), defaultValue));
    }

    private void registerProvider(String providerName) {
        Security.addProvider(new OSGiProvider(providerName));
        this.log.log(3, "Registered provider " + providerName + " for managing JAAS config with type " + JAAS_CONFIG_ALGO_NAME);
    }

    private void deregisterProvider(String providerName) {
        Security.removeProvider(providerName);
        this.log.log(3, "Removed provider " + providerName + " type " + JAAS_CONFIG_ALGO_NAME + " from Security providers list");
    }

    public Object addingService(ServiceReference reference) {
        LoginModuleFactory lmf = (LoginModuleFactory)this.context.getService(reference);
        this.registerFactory(reference, lmf);
        this.recreateConfigs();
        return lmf;
    }

    public void modifiedService(ServiceReference reference, Object service) {
        LoginModuleFactory lmf = this.providerMap.get(reference);
        if (lmf instanceof OsgiLoginModuleProvider) {
            ((OsgiLoginModuleProvider)lmf).configure();
        }
        this.recreateConfigs();
    }

    public void removedService(ServiceReference reference, Object service) {
        this.deregisterFactory(reference);
        this.recreateConfigs();
        this.context.ungetService(reference);
    }

    private void deregisterFactory(ServiceReference ref) {
        LoginModuleProvider lmp = this.providerMap.remove(ref);
        if (lmp != null) {
            this.log.log(3, "Deregistering LoginModuleFactory " + lmp);
        }
    }

    private void registerFactory(ServiceReference ref, LoginModuleFactory lmf) {
        LoginModuleProvider lmfExt = lmf instanceof LoginModuleProvider ? (LoginModuleProvider)lmf : new OsgiLoginModuleProvider(ref, lmf);
        this.log.log(3, "Registering LoginModuleFactory " + lmf);
        this.providerMap.put(ref, lmfExt);
    }

    private static Configuration getGlobalConfiguration() {
        try {
            return Configuration.getConfiguration();
        }
        catch (Exception exception) {
            return null;
        }
    }

    static final class AppConfigurationHolder
    implements Comparable<AppConfigurationHolder> {
        private static final String LOGIN_MODULE_CLASS = ProxyLoginModule.class.getName();
        private final LoginModuleProvider provider;
        private final int ranking;
        private final AppConfigurationEntry entry;

        public AppConfigurationHolder(LoginModuleProvider provider) {
            this.provider = provider;
            this.ranking = provider.ranking();
            HashMap options = new HashMap(provider.options());
            options.put("org.apache.felix.jaas.LoginModuleFactory", provider);
            this.entry = new AppConfigurationEntry(LOGIN_MODULE_CLASS, provider.getControlFlag(), Collections.unmodifiableMap(options));
        }

        @Override
        public int compareTo(AppConfigurationHolder that) {
            if (this.ranking == that.ranking) {
                return 0;
            }
            return this.ranking > that.ranking ? -1 : 1;
        }

        public AppConfigurationEntry getEntry() {
            return this.entry;
        }

        public LoginModuleProvider getProvider() {
            return this.provider;
        }
    }

    static final class Realm {
        private final String realmName;
        private AppConfigurationEntry[] configArray;
        private List<AppConfigurationHolder> configs = new ArrayList<AppConfigurationHolder>();

        Realm(String realmName) {
            this.realmName = realmName;
        }

        public void add(AppConfigurationHolder config) {
            this.configs.add(config);
        }

        public void afterPropertiesSet() {
            Collections.sort(this.configs);
            this.configArray = new AppConfigurationEntry[this.configs.size()];
            for (int i = 0; i < this.configs.size(); ++i) {
                this.configArray[i] = this.configs.get(i).getEntry();
            }
            this.configs = Collections.unmodifiableList(this.configs);
        }

        public String getRealmName() {
            return this.realmName;
        }

        public List<AppConfigurationHolder> getConfigs() {
            return this.configs;
        }

        public AppConfigurationEntry[] engineGetAppConfigurationEntry() {
            return Arrays.copyOf(this.configArray, this.configArray.length);
        }

        public String toString() {
            return "Realm{realmName='" + this.realmName + '\'' + '}';
        }
    }

    private class DelegatingConfiguration
    extends Configuration {
        private final Configuration primary;
        private final Configuration secondary;

        private DelegatingConfiguration(Configuration primary, Configuration secondary) {
            this.primary = primary;
            this.secondary = secondary;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            AppConfigurationEntry[] result = null;
            try {
                result = this.primary.getAppConfigurationEntry(name);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (result == null) {
                try {
                    result = this.secondary.getAppConfigurationEntry(name);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return result;
        }
    }

    private class OsgiConfiguration
    extends Configuration {
        private OsgiConfiguration() {
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            return ConfigSpiOsgi.this.engineGetAppConfigurationEntry(name);
        }
    }

    private class ConfigurationService
    extends Provider.Service {
        public ConfigurationService(Provider provider) {
            super(provider, "Configuration", ConfigSpiOsgi.JAAS_CONFIG_ALGO_NAME, ConfigSpiOsgi.class.getName(), Collections.<String>emptyList(), Collections.<String, String>emptyMap());
        }

        @Override
        public Object newInstance(Object constructorParameter) throws NoSuchAlgorithmException {
            return ConfigSpiOsgi.this;
        }
    }

    private class OSGiProvider
    extends Provider {
        public static final String TYPE_CONFIGURATION = "Configuration";

        OSGiProvider(String providerName) {
            super(providerName, 1.0, "OSGi based provider for Jaas configuration");
        }

        @Override
        public synchronized Provider.Service getService(String type, String algorithm) {
            if (TYPE_CONFIGURATION.equals(type) && ConfigSpiOsgi.JAAS_CONFIG_ALGO_NAME.equals(algorithm)) {
                return new ConfigurationService(this);
            }
            return super.getService(type, algorithm);
        }
    }

    private static enum GlobalConfigurationPolicy {
        DEFAULT,
        REPLACE,
        PROXY;

    }
}

