/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.jaas.internal;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.jaas.LoginModuleFactory;
import org.apache.felix.jaas.internal.ConfigLoginModuleProvider;
import org.apache.felix.jaas.internal.ControlFlag;
import org.apache.felix.jaas.internal.Logger;
import org.apache.felix.jaas.internal.LoginModuleCreator;
import org.apache.felix.jaas.internal.Util;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;

public class JaasConfigFactory
implements ManagedServiceFactory {
    public static final String SERVICE_PID = "org.apache.felix.jaas.Configuration.factory";
    static final String JAAS_CLASS_NAME = "jaas.classname";
    static final String JAAS_OPTIONS = "jaas.options";
    private final Logger log;
    private final LoginModuleCreator factory;
    private final BundleContext context;
    private final ConcurrentMap<String, ServiceRegistration> registrations = new ConcurrentHashMap<String, ServiceRegistration>();

    public JaasConfigFactory(BundleContext context, LoginModuleCreator factory, Logger log) {
        this.context = context;
        this.factory = factory;
        this.log = log;
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("service.vendor", "Apache Software Foundation");
        props.put("service.pid", SERVICE_PID);
        context.registerService(ManagedServiceFactory.class.getName(), (Object)this, props);
    }

    public String getName() {
        return "JaasConfigFactory";
    }

    public void updated(String pid, Dictionary config) throws ConfigurationException {
        String className = Util.trimToNull(PropertiesUtil.toString(config.get(JAAS_CLASS_NAME), null));
        String flag = Util.trimToNull(PropertiesUtil.toString(config.get("jaas.controlFlag"), "required"));
        int ranking = PropertiesUtil.toInteger(config.get("jaas.ranking"), 0);
        Map<String, String> options = PropertiesUtil.toMap(config.get(JAAS_OPTIONS), new String[0]);
        String realmName = Util.trimToNull(PropertiesUtil.toString(config.get("jaas.realmName"), null));
        if (className == null) {
            this.log.log(2, "Class name for the LoginModule is required. Configuration would be ignored" + config);
            return;
        }
        Map combinedOptions = JaasConfigFactory.convertToMap(config);
        combinedOptions.putAll(options);
        ConfigLoginModuleProvider lmf = new ConfigLoginModuleProvider(realmName, className, combinedOptions, ControlFlag.from(flag).flag(), ranking, this.factory);
        ServiceRegistration reg = this.context.registerService(LoginModuleFactory.class.getName(), (Object)lmf, null);
        ServiceRegistration oldReg = this.registrations.put(pid, reg);
        if (oldReg != null) {
            oldReg.unregister();
        }
    }

    public void deleted(String pid) {
        ServiceRegistration reg = (ServiceRegistration)this.registrations.remove(pid);
        if (reg != null) {
            reg.unregister();
        }
    }

    private static Map convertToMap(Dictionary config) {
        HashMap copy = new HashMap();
        Enumeration e = config.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = config.get(key);
            copy.put(key, value);
        }
        return copy;
    }
}

