/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.log;

import org.apache.felix.log.LoggerAdminImpl;
import org.apache.felix.log.LoggerImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.service.log.Logger;

final class LogServiceImpl
implements LogService {
    private final Bundle m_bundle;
    private final LoggerAdminImpl m_loggerAdminImpl;

    LogServiceImpl(Bundle bundle, LoggerAdminImpl loggerAdminImpl) {
        this.m_bundle = bundle;
        this.m_loggerAdminImpl = loggerAdminImpl;
    }

    @Override
    public void log(int level, String message) {
        this.log(null, level, message, null);
    }

    @Override
    public void log(int level, String message, Throwable exception) {
        this.log(null, level, message, exception);
    }

    @Override
    public void log(ServiceReference<?> sr, int level, String message) {
        this.log(sr, level, message, null);
    }

    @Override
    public void log(ServiceReference<?> sr, int level, String message, Throwable exception) {
        LoggerImpl logger = (LoggerImpl)this.m_loggerAdminImpl.getLogger(this.m_bundle, "LogService", Logger.class);
        switch (level) {
            case 4: {
                logger.debug(message, sr, exception);
                break;
            }
            case 1: {
                logger.error(message, sr, exception);
                break;
            }
            case 3: {
                logger.info(message, sr, exception);
                break;
            }
            case 2: {
                logger.warn(message, sr, exception);
                break;
            }
            default: {
                logger.log(level, message, sr, exception);
            }
        }
    }

    @Override
    public Logger getLogger(String name) {
        return this.m_loggerAdminImpl.getLogger(this.m_bundle, name, Logger.class);
    }

    @Override
    public Logger getLogger(Class<?> clazz) {
        return this.m_loggerAdminImpl.getLogger(this.m_bundle, clazz.getName(), Logger.class);
    }

    @Override
    public <L extends Logger> L getLogger(String name, Class<L> loggerType) {
        return this.m_loggerAdminImpl.getLogger(this.m_bundle, name, loggerType);
    }

    @Override
    public <L extends Logger> L getLogger(Class<?> clazz, Class<L> loggerType) {
        return this.m_loggerAdminImpl.getLogger(this.m_bundle, clazz.getName(), loggerType);
    }

    @Override
    public <L extends Logger> L getLogger(Bundle bundle, String name, Class<L> loggerType) {
        return this.m_loggerAdminImpl.getLogger(bundle, name, loggerType);
    }
}

