/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util.manifestparser;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.felix.framework.FilterImpl;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.util.VersionRange;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class R4LibraryClause {
    private String[] m_libraryFiles = null;
    private String[] m_osnames = null;
    private String[] m_processors = null;
    private String[] m_osversions = null;
    private String[] m_languages = null;
    private String m_selectionFilter = null;

    public R4LibraryClause(String[] libraryFiles, String[] osnames, String[] processors, String[] osversions, String[] languages, String selectionFilter) {
        this.m_libraryFiles = libraryFiles;
        this.m_osnames = osnames;
        this.m_processors = processors;
        this.m_osversions = osversions;
        this.m_languages = languages;
        this.m_selectionFilter = selectionFilter;
    }

    public R4LibraryClause(R4LibraryClause library) {
        this.m_libraryFiles = library.m_libraryFiles;
        this.m_osnames = library.m_osnames;
        this.m_osversions = library.m_osversions;
        this.m_processors = library.m_processors;
        this.m_languages = library.m_languages;
        this.m_selectionFilter = library.m_selectionFilter;
    }

    public String[] getLibraryFiles() {
        return this.m_libraryFiles;
    }

    public String[] getOSNames() {
        return this.m_osnames;
    }

    public String[] getProcessors() {
        return this.m_processors;
    }

    public String[] getOSVersions() {
        return this.m_osversions;
    }

    public String[] getLanguages() {
        return this.m_languages;
    }

    public String getSelectionFilter() {
        return this.m_selectionFilter;
    }

    public boolean match(Map configMap) throws BundleException {
        String normal_osname = R4LibraryClause.normalizeOSName((String)configMap.get("org.osgi.framework.os.name"));
        String normal_processor = R4LibraryClause.normalizeProcessor((String)configMap.get("org.osgi.framework.processor"));
        String normal_osversion = R4LibraryClause.normalizeOSVersion((String)configMap.get("org.osgi.framework.os.version"));
        String normal_language = (String)configMap.get("org.osgi.framework.language");
        if (!this.checkOSNames(normal_osname, this.getOSNames())) {
            return false;
        }
        if (!this.checkProcessors(normal_processor, this.getProcessors())) {
            return false;
        }
        if (this.getOSVersions() != null && this.getOSVersions().length > 0 && !this.checkOSVersions(normal_osversion, this.getOSVersions())) {
            return false;
        }
        if (this.getLanguages() != null && this.getLanguages().length > 0 && !this.checkLanguages(normal_language, this.getLanguages())) {
            return false;
        }
        return this.getSelectionFilter() == null || this.getSelectionFilter().length() < 0 || this.checkSelectionFilter(configMap, this.getSelectionFilter());
    }

    private boolean checkOSNames(String currentOSName, String[] osnames) {
        boolean win32 = currentOSName.startsWith("win") && (currentOSName.equals("windows95") || currentOSName.equals("windows98") || currentOSName.equals("windowsnt") || currentOSName.equals("windows2000") || currentOSName.equals("windowsxp") || currentOSName.equals("windowsce") || currentOSName.equals("windowsvista"));
        for (int i = 0; osnames != null && i < osnames.length; ++i) {
            if (!osnames[i].equals(currentOSName) && (!"win32".equals(osnames[i]) || !win32)) continue;
            return true;
        }
        return false;
    }

    private boolean checkProcessors(String currentProcessor, String[] processors) {
        for (int i = 0; processors != null && i < processors.length; ++i) {
            if (!processors[i].equals(currentProcessor)) continue;
            return true;
        }
        return false;
    }

    private boolean checkOSVersions(String currentOSVersion, String[] osversions) throws BundleException {
        for (int i = 0; osversions != null && i < osversions.length; ++i) {
            try {
                VersionRange range = VersionRange.parse(osversions[i]);
                if (!range.isInRange(new Version(currentOSVersion))) continue;
                return true;
            }
            catch (Exception ex) {
                throw new BundleException("Error evaluating osversion: " + osversions[i], ex);
            }
        }
        return false;
    }

    private boolean checkLanguages(String currentLanguage, String[] languages) {
        for (int i = 0; languages != null && i < languages.length; ++i) {
            if (!languages[i].equals(currentLanguage)) continue;
            return true;
        }
        return false;
    }

    private boolean checkSelectionFilter(Map configMap, String expr) throws BundleException {
        Hashtable dict = new Hashtable();
        Iterator i = configMap.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            ((Dictionary)dict).put(key, configMap.get(key));
        }
        try {
            FilterImpl filter = new FilterImpl(expr);
            return filter.match(dict);
        }
        catch (Exception ex) {
            throw new BundleException("Error evaluating filter expression: " + expr, ex);
        }
    }

    public static R4LibraryClause parse(Logger logger, String s) {
        try {
            if (s == null || s.length() == 0) {
                return null;
            }
            if (s.equals("*")) {
                return new R4LibraryClause(null, null, null, null, null, null);
            }
            StringTokenizer st = new StringTokenizer(s, ";");
            String[] libFiles = new String[st.countTokens()];
            ArrayList<String> osNameList = new ArrayList<String>();
            ArrayList<String> osVersionList = new ArrayList<String>();
            ArrayList<String> processorList = new ArrayList<String>();
            ArrayList<String> languageList = new ArrayList<String>();
            String selectionFilter = null;
            int libCount = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (token.indexOf(61) < 0) {
                    libFiles[libCount] = token.charAt(0) == '/' ? token.substring(1) : token;
                    ++libCount;
                    continue;
                }
                String property = null;
                String value = null;
                if (token.indexOf("=") <= 1) {
                    throw new IllegalArgumentException("Bundle manifest native library entry malformed: " + token);
                }
                property = token.substring(0, token.indexOf("=")).trim().toLowerCase();
                value = token.substring(token.indexOf("=") + 1, token.length()).trim();
                if (value.charAt(0) == '\"') {
                    value = value.charAt(value.length() - 1) == '\"' ? value.substring(1, value.length() - 1) : value.substring(1);
                }
                if (property.equals("osname")) {
                    osNameList.add(R4LibraryClause.normalizeOSName(value));
                    continue;
                }
                if (property.equals("osversion")) {
                    osVersionList.add(R4LibraryClause.normalizeOSVersion(value));
                    continue;
                }
                if (property.equals("processor")) {
                    processorList.add(R4LibraryClause.normalizeProcessor(value));
                    continue;
                }
                if (property.equals("language")) {
                    languageList.add(value);
                    continue;
                }
                if (!property.equals("selection-filter")) continue;
                selectionFilter = value;
            }
            if (libCount == 0) {
                return null;
            }
            String[] actualLibFiles = new String[libCount];
            System.arraycopy(libFiles, 0, actualLibFiles, 0, libCount);
            return new R4LibraryClause(actualLibFiles, osNameList.toArray(new String[osNameList.size()]), processorList.toArray(new String[processorList.size()]), osVersionList.toArray(new String[osVersionList.size()]), languageList.toArray(new String[languageList.size()]), selectionFilter);
        }
        catch (RuntimeException ex) {
            logger.log(1, "Error parsing native library header.", ex);
            throw ex;
        }
    }

    public static String normalizeOSName(String value) {
        if ((value = value.toLowerCase()).startsWith("win")) {
            String os = "win";
            if (value.indexOf("32") >= 0 || value.indexOf("*") >= 0) {
                os = "win32";
            } else if (value.indexOf("95") >= 0) {
                os = "windows95";
            } else if (value.indexOf("98") >= 0) {
                os = "windows98";
            } else if (value.indexOf("nt") >= 0) {
                os = "windowsnt";
            } else if (value.indexOf("2000") >= 0) {
                os = "windows2000";
            } else if (value.indexOf("xp") >= 0) {
                os = "windowsxp";
            } else if (value.indexOf("ce") >= 0) {
                os = "windowsce";
            } else if (value.indexOf("vista") >= 0) {
                os = "windowsvista";
            }
            return os;
        }
        if (value.startsWith("linux")) {
            return "linux";
        }
        if (value.startsWith("aix")) {
            return "aix";
        }
        if (value.startsWith("digitalunix")) {
            return "digitalunix";
        }
        if (value.startsWith("hpux")) {
            return "hpux";
        }
        if (value.startsWith("irix")) {
            return "irix";
        }
        if (value.startsWith("macos") || value.startsWith("mac os")) {
            return "macos";
        }
        if (value.startsWith("netware")) {
            return "netware";
        }
        if (value.startsWith("openbsd")) {
            return "openbsd";
        }
        if (value.startsWith("netbsd")) {
            return "netbsd";
        }
        if (value.startsWith("os2") || value.startsWith("os/2")) {
            return "os2";
        }
        if (value.startsWith("qnx") || value.startsWith("procnto")) {
            return "qnx";
        }
        if (value.startsWith("solaris")) {
            return "solaris";
        }
        if (value.startsWith("sunos")) {
            return "sunos";
        }
        if (value.startsWith("vxworks")) {
            return "vxworks";
        }
        return value;
    }

    public static String normalizeProcessor(String value) {
        if ((value = value.toLowerCase()).startsWith("x86-64") || value.startsWith("amd64")) {
            return "x86-64";
        }
        if (value.startsWith("x86") || value.startsWith("pentium") || value.startsWith("i386") || value.startsWith("i486") || value.startsWith("i586") || value.startsWith("i686")) {
            return "x86";
        }
        if (value.startsWith("68k")) {
            return "68k";
        }
        if (value.startsWith("arm")) {
            return "arm";
        }
        if (value.startsWith("alpha")) {
            return "alpha";
        }
        if (value.startsWith("ignite") || value.startsWith("psc1k")) {
            return "ignite";
        }
        if (value.startsWith("mips")) {
            return "mips";
        }
        if (value.startsWith("parisc")) {
            return "parisc";
        }
        if (value.startsWith("powerpc") || value.startsWith("power") || value.startsWith("ppc")) {
            return "powerpc";
        }
        if (value.startsWith("sparc")) {
            return "sparc";
        }
        return value;
    }

    public static String normalizeOSVersion(String value) {
        String VERSION_DELIM = ".";
        String QUALIFIER_DELIM = "-";
        int major = 0;
        int minor = 0;
        int micro = 0;
        try {
            StringTokenizer st = new StringTokenizer(value, VERSION_DELIM, true);
            major = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                st.nextToken();
                minor = Integer.parseInt(st.nextToken());
                if (st.hasMoreTokens()) {
                    st.nextToken();
                    String microStr = st.nextToken();
                    micro = microStr.indexOf(QUALIFIER_DELIM) < 0 ? Integer.parseInt(microStr) : Integer.parseInt(microStr.substring(0, microStr.indexOf(QUALIFIER_DELIM)));
                }
            }
        }
        catch (Exception ex) {
            return Version.emptyVersion.toString();
        }
        return major + "." + minor + "." + micro;
    }
}

