/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util.ldap;

import java.io.CharArrayReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Stack;
import org.apache.felix.framework.util.ldap.DriverMapper;
import org.apache.felix.framework.util.ldap.EvaluationException;
import org.apache.felix.framework.util.ldap.Evaluator;
import org.apache.felix.framework.util.ldap.LdapLexer;
import org.apache.felix.framework.util.ldap.ParseException;
import org.apache.felix.framework.util.ldap.Parser;

public class Driver {
    public static void main(String[] argv) {
        DriverMapper mapper = new DriverMapper();
        if (argv == null || argv.length == 0) {
            System.err.println("usage: Driver <ldap spec file>");
            return;
        }
        LdapLexer lexer = new LdapLexer();
        FileReader fr = null;
        char[] line = null;
        Evaluator engine = new Evaluator();
        Parser parser = new Parser();
        try {
            File spec = new File(argv[0]);
            fr = new FileReader(spec);
            while ((line = Driver.getLine(fr)) != null) {
                System.out.println("Driver: filter: " + new String(line));
                CharArrayReader car = new CharArrayReader(line);
                lexer.setReader(car);
                parser.reset(lexer);
                boolean status = false;
                try {
                    status = parser.start();
                    if (!status) {
                        System.err.println("parse failed");
                        Driver.printErrorLocation(line, lexer.charno());
                    }
                }
                catch (ParseException pe) {
                    System.err.println(pe.toString());
                    Driver.printErrorLocation(line, lexer.charno());
                }
                if (!status) continue;
                try {
                    engine.reset(parser.getProgram());
                    System.out.println("Driver: program: " + engine.toStringInfix());
                    System.out.println("Eval = " + engine.evaluate(mapper));
                }
                catch (EvaluationException ee) {
                    System.err.print("Driver: ");
                    Driver.printEvaluationStack(engine.getOperands());
                    System.err.println(ee.toString());
                }
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
            Driver.printErrorLocation(line, lexer.charno());
            e.printStackTrace();
        }
    }

    static char[] getLine(Reader reader) throws IOException {
        StringBuffer buf = new StringBuffer();
        while (true) {
            int c;
            if ((c = reader.read()) == 13) {
                continue;
            }
            if (c < 0) {
                if (buf.length() != 0) break;
                return null;
            }
            if (c == 10) break;
            buf.append((char)c);
        }
        char[] cbuf = new char[buf.length()];
        buf.getChars(0, buf.length(), cbuf, 0);
        return cbuf;
    }

    static void printErrorLocation(char[] line, int charno) {
        System.err.print("|");
        if (line != null) {
            System.err.print(new String(line));
        }
        System.err.println("|");
        for (int i = 0; i < charno; ++i) {
            System.err.print(" ");
        }
        System.err.println("^");
    }

    static void printEvaluationStack(Stack stack) {
        System.err.print("Stack:");
        Stack operands = stack;
        int len = operands.size();
        for (int i = 0; i < len; ++i) {
            System.err.print(" " + operands.elementAt(i));
        }
        System.err.println();
    }
}

