/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.resolver;

import java.util.List;
import org.apache.felix.framework.capabilityset.Attribute;
import org.apache.felix.framework.capabilityset.Capability;
import org.apache.felix.framework.capabilityset.Directive;
import org.apache.felix.framework.resolver.Module;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostedCapability
implements Capability {
    private final Module m_host;
    private final Capability m_cap;

    public HostedCapability(Module module, Capability cap) {
        this.m_host = module;
        this.m_cap = cap;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HostedCapability other = (HostedCapability)obj;
        if (!(this.m_host == other.m_host || this.m_host != null && this.m_host.equals(other.m_host))) {
            return false;
        }
        return this.m_cap == other.m_cap || this.m_cap != null && this.m_cap.equals(other.m_cap);
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.m_host != null ? this.m_host.hashCode() : 0);
        hash = 37 * hash + (this.m_cap != null ? this.m_cap.hashCode() : 0);
        return hash;
    }

    public Capability getDeclaredCapability() {
        return this.m_cap;
    }

    @Override
    public Module getModule() {
        return this.m_host;
    }

    @Override
    public String getNamespace() {
        return this.m_cap.getNamespace();
    }

    @Override
    public Directive getDirective(String name) {
        return this.m_cap.getDirective(name);
    }

    @Override
    public List<Directive> getDirectives() {
        return this.m_cap.getDirectives();
    }

    @Override
    public Attribute getAttribute(String name) {
        return this.m_cap.getAttribute(name);
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.m_cap.getAttributes();
    }

    @Override
    public List<String> getUses() {
        return this.m_cap.getUses();
    }

    public String toString() {
        if (this.m_host == null) {
            return this.getAttributes().toString();
        }
        if (this.getNamespace().equals("package")) {
            return new StringBuffer().append("[").append(this.m_host).append("] ").append(this.getNamespace()).append("; ").append(this.getAttribute("package")).toString();
        }
        return new StringBuffer().append("[").append(this.m_host).append("] ").append(this.getNamespace()).append("; ").append(this.getAttributes()).toString();
    }
}

