/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.resolver.Candidates;
import org.apache.felix.resolver.Logger;
import org.apache.felix.resolver.Util;
import org.apache.felix.resolver.WireImpl;
import org.apache.felix.resolver.WrappedCapability;
import org.apache.felix.resolver.WrappedRequirement;
import org.apache.felix.resolver.WrappedResource;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;
import org.osgi.service.resolver.HostedCapability;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.resolver.ResolveContext;
import org.osgi.service.resolver.Resolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolverImpl
implements Resolver {
    private final Logger m_logger;

    public ResolverImpl(Logger logger) {
        this.m_logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public Map<Resource, List<Wire>> resolve(ResolveContext rc) throws ResolutionException {
        boolean retry;
        ResolveSession session = new ResolveSession(rc);
        Map<Resource, List<Wire>> wireMap = new HashMap<Resource, List<Wire>>();
        HashMap<Resource, Packages> resourcePkgMap = new HashMap<Resource, Packages>();
        ArrayList<Resource> mandatoryResources = new ArrayList<Resource>(rc.getMandatoryResources());
        ArrayList<Resource> optionalResources = new ArrayList<Resource>(rc.getOptionalResources());
        HashMap<Resource, Boolean> validOnDemandResources = new HashMap<Resource, Boolean>(0);
        do {
            retry = false;
            try {
                Candidates allCandidates = new Candidates(validOnDemandResources);
                Iterator it = mandatoryResources.iterator();
                while (it.hasNext()) {
                    Resource resource = (Resource)it.next();
                    if (Util.isFragment(resource) || rc.getWirings().get(resource) == null) {
                        allCandidates.populate(rc, resource, 0);
                        continue;
                    }
                    it.remove();
                }
                for (Resource resource : optionalResources) {
                    boolean isFragment = Util.isFragment(resource);
                    if (!isFragment && rc.getWirings().get(resource) != null) continue;
                    allCandidates.populate(rc, resource, 1);
                }
                allCandidates.prepare(rc);
                LinkedHashSet<Resource> allResources = new LinkedHashSet<Resource>(mandatoryResources);
                for (Resource resource3 : optionalResources) {
                    if (!allCandidates.isPopulated(resource3)) continue;
                    allResources.add(resource3);
                }
                List<Candidates> list = session.getUsesPermutations();
                List<Candidates> importPermutations = session.getImportPermutations();
                list.add(allCandidates);
                ResolutionException rethrow = null;
                HashMap<Resource, Requirement> hostReqs = new HashMap<Resource, Requirement>();
                for (Resource resource4 : allResources) {
                    if (!Util.isFragment(resource4)) continue;
                    hostReqs.put(resource4, resource4.getRequirements("osgi.wiring.host").get(0));
                }
                HashSet<Object> processedDeltas = new HashSet<Object>();
                Map faultyResources = null;
                do {
                    Candidates candidates = list.size() > 0 ? list.remove(0) : (allCandidates = importPermutations.size() > 0 ? importPermutations.remove(0) : null);
                    if (allCandidates == null) break;
                    if (!processedDeltas.add(allCandidates.getDelta())) continue;
                    rethrow = null;
                    resourcePkgMap.clear();
                    session.getPackageSourcesCache().clear();
                    session.setMultipleCardCandidates(null);
                    HashMap<Resource, ResolutionException> currentFaultyResources = null;
                    try {
                        allCandidates.checkSubstitutes(importPermutations);
                    }
                    catch (ResolutionException e) {
                        rethrow = e;
                        continue;
                    }
                    HashMap resultCache = new HashMap(allResources.size());
                    Iterator iterator = allResources.iterator();
                    while (iterator.hasNext()) {
                        Resource resource5;
                        Resource target = resource5 = (Resource)iterator.next();
                        Requirement hostReq = (Requirement)hostReqs.get(resource5);
                        if (hostReq != null) {
                            Capability hostCap = allCandidates.getFirstCandidate(hostReq);
                            if (hostCap == null) continue;
                            target = hostCap.getResource();
                        }
                        this.calculatePackageSpaces(session, allCandidates.getWrappedHost(target), allCandidates, resourcePkgMap, new HashMap<Capability, Set<Resource>>(256), new HashSet<Resource>(64));
                        try {
                            this.checkPackageSpaceConsistency(session, allCandidates.getWrappedHost(target), allCandidates, resourcePkgMap, resultCache);
                        }
                        catch (ResolutionException ex) {
                            rethrow = ex;
                            if (currentFaultyResources == null) {
                                currentFaultyResources = new HashMap<Resource, ResolutionException>();
                            }
                            Resource faultyResource = resource5;
                            for (Requirement faultyReq : ex.getUnresolvedRequirements()) {
                                if (!(faultyReq instanceof WrappedRequirement)) continue;
                                faultyResource = ((WrappedRequirement)faultyReq).getDeclaredRequirement().getResource();
                                break;
                            }
                            currentFaultyResources.put(faultyResource, ex);
                        }
                    }
                    if (currentFaultyResources == null) continue;
                    if (faultyResources == null) {
                        faultyResources = currentFaultyResources;
                        continue;
                    }
                    if (faultyResources.size() <= currentFaultyResources.size()) continue;
                    faultyResources = currentFaultyResources;
                } while (rethrow != null);
                if (rethrow != null) {
                    if (faultyResources != null) {
                        Set resourceKeys = faultyResources.keySet();
                        retry = optionalResources.removeAll(resourceKeys);
                        for (Resource resource : resourceKeys) {
                            Boolean valid = (Boolean)validOnDemandResources.get(resource);
                            if (valid == null || !valid.booleanValue()) continue;
                            validOnDemandResources.put(resource, Boolean.FALSE);
                            retry = true;
                        }
                        for (Map.Entry entry : faultyResources.entrySet()) {
                            this.m_logger.logUsesConstraintViolation((Resource)entry.getKey(), (ResolutionException)entry.getValue());
                        }
                    }
                    if (retry) continue;
                    throw rethrow;
                }
                if (session.getMultipleCardCandidates() != null) {
                    allCandidates = session.getMultipleCardCandidates();
                }
                Iterator iterator = allResources.iterator();
                while (iterator.hasNext()) {
                    void var19_33;
                    Resource resource6;
                    Resource resource = resource6 = (Resource)iterator.next();
                    Requirement hostReq = (Requirement)hostReqs.get(resource6);
                    if (hostReq != null) {
                        Capability hostCap = allCandidates.getFirstCandidate(hostReq);
                        if (hostCap == null) continue;
                        Resource resource2 = hostCap.getResource();
                    }
                    if (!allCandidates.isPopulated((Resource)var19_33)) continue;
                    wireMap = ResolverImpl.populateWireMap(rc, allCandidates.getWrappedHost((Resource)var19_33), resourcePkgMap, wireMap, allCandidates);
                }
            }
            finally {
                session.getUsesPermutations().clear();
                session.getImportPermutations().clear();
                session.setMultipleCardCandidates(null);
                session.getPackageSourcesCache().clear();
            }
        } while (retry);
        return wireMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Resource, List<Wire>> resolve(ResolveContext rc, Resource host, Requirement dynamicReq, List<Capability> matches) throws ResolutionException {
        ResolveSession session = new ResolveSession(rc);
        Map<Resource, List<Wire>> wireMap = new HashMap<Resource, List<Wire>>();
        if (!matches.isEmpty() && rc.getWirings().containsKey(host)) {
            boolean retry;
            for (Capability cap : matches) {
                if (cap.getNamespace().equals("osgi.wiring.package")) continue;
                throw new IllegalArgumentException("Matching candidate does not provide a package name.");
            }
            HashMap<Resource, Packages> resourcePkgMap = new HashMap<Resource, Packages>();
            HashMap<Resource, Boolean> onDemandResources = new HashMap<Resource, Boolean>();
            do {
                retry = false;
                try {
                    ResolutionException rethrow;
                    Candidates allCandidates = new Candidates(onDemandResources);
                    allCandidates.populateDynamic(rc, host, dynamicReq, matches);
                    allCandidates.prepare(rc);
                    List<Candidates> usesPermutations = session.getUsesPermutations();
                    List<Candidates> importPermutations = session.getImportPermutations();
                    usesPermutations.add(allCandidates);
                    do {
                        rethrow = null;
                        resourcePkgMap.clear();
                        session.getPackageSourcesCache().clear();
                        allCandidates = usesPermutations.size() > 0 ? usesPermutations.remove(0) : importPermutations.remove(0);
                        try {
                            allCandidates.checkSubstitutes(importPermutations);
                        }
                        catch (ResolutionException e) {
                            rethrow = e;
                            continue;
                        }
                        this.calculatePackageSpaces(session, allCandidates.getWrappedHost(host), allCandidates, resourcePkgMap, new HashMap<Capability, Set<Resource>>(256), new HashSet<Resource>(64));
                        try {
                            this.checkDynamicPackageSpaceConsistency(session, allCandidates.getWrappedHost(host), allCandidates, resourcePkgMap, new HashMap<Resource, Object>(64));
                        }
                        catch (ResolutionException ex) {
                            rethrow = ex;
                        }
                    } while (rethrow != null && (usesPermutations.size() > 0 || importPermutations.size() > 0));
                    if (rethrow != null) {
                        Boolean valid;
                        Resource faultyResource;
                        Collection<Requirement> exReqs = rethrow.getUnresolvedRequirements();
                        Requirement faultyReq = exReqs == null || exReqs.isEmpty() ? null : exReqs.iterator().next();
                        Resource resource = faultyResource = faultyReq == null ? null : ResolverImpl.getDeclaredResource(faultyReq.getResource());
                        if (faultyReq instanceof WrappedRequirement) {
                            faultyResource = ((WrappedRequirement)faultyReq).getDeclaredRequirement().getResource();
                        }
                        if ((valid = (Boolean)onDemandResources.get(faultyResource)) != null && valid.booleanValue()) {
                            onDemandResources.put(faultyResource, Boolean.FALSE);
                            retry = true;
                            continue;
                        }
                        throw rethrow;
                    }
                    if (session.getMultipleCardCandidates() != null) {
                        allCandidates = session.getMultipleCardCandidates();
                    }
                    wireMap = ResolverImpl.populateDynamicWireMap(rc, host, dynamicReq, resourcePkgMap, wireMap, allCandidates);
                }
                finally {
                    session.getUsesPermutations().clear();
                    session.getImportPermutations().clear();
                    session.setMultipleCardCandidates(null);
                    session.getPackageSourcesCache().clear();
                }
            } while (retry);
        }
        return wireMap;
    }

    private void calculatePackageSpaces(ResolveSession session, Resource resource, Candidates allCandidates, Map<Resource, Packages> resourcePkgMap, Map<Capability, Set<Resource>> usesCycleMap, Set<Resource> cycle) {
        Capability cap;
        List<Capability> candCaps;
        if (cycle.contains(resource)) {
            return;
        }
        cycle.add(resource);
        Packages resourcePkgs = resourcePkgMap.get(resource);
        if (resourcePkgs != null) {
            if (resourcePkgs.m_isCalculated) {
                return;
            }
            resourcePkgs.m_isCalculated = true;
        }
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        ArrayList<Object> caps = new ArrayList<Object>();
        boolean isDynamicImporting = false;
        Wiring wiring = session.getContext().getWirings().get(resource);
        if (wiring != null) {
            for (Wire wire : wiring.getRequiredResourceWires(null)) {
                Capability c;
                Requirement r = wire.getRequirement();
                if (!r.getResource().equals(wire.getRequirer()) || r.getDirectives().get("resolution") != null && r.getDirectives().get("resolution").equals("dynamic")) {
                    r = new WrappedRequirement(wire.getRequirer(), r);
                }
                if (!(c = wire.getCapability()).getResource().equals(wire.getProvider())) {
                    c = new WrappedCapability(wire.getProvider(), c);
                }
                reqs.add(r);
                caps.add(c);
            }
            for (Requirement requirement : Util.getDynamicRequirements(wiring.getResourceRequirements(null))) {
                candCaps = allCandidates.getCandidates(requirement);
                if (candCaps == null) continue;
                Capability cap2 = candCaps.get(0);
                reqs.add(requirement);
                caps.add(cap2);
                isDynamicImporting = true;
                break;
            }
        } else {
            for (Requirement requirement : resource.getRequirements(null)) {
                if (Util.isDynamic(requirement) || (candCaps = allCandidates.getCandidates(requirement)) == null) continue;
                if (Util.isMultiple(requirement)) {
                    for (Capability cap3 : candCaps) {
                        reqs.add(requirement);
                        caps.add(cap3);
                    }
                    continue;
                }
                Capability cap2 = candCaps.get(0);
                reqs.add(requirement);
                caps.add(cap2);
            }
        }
        ResolverImpl.calculateExportedPackages(session.getContext(), resource, allCandidates, resourcePkgMap);
        resourcePkgs = resourcePkgMap.get(resource);
        for (int i = 0; i < reqs.size(); ++i) {
            String pkgName;
            Requirement requirement = (Requirement)reqs.get(i);
            cap = (Capability)caps.get(i);
            ResolverImpl.calculateExportedPackages(session.getContext(), cap.getResource(), allCandidates, resourcePkgMap);
            if (isDynamicImporting && i + 1 == reqs.size() && (resourcePkgs.m_exportedPkgs.containsKey(pkgName = (String)cap.getAttributes().get("osgi.wiring.package")) || resourcePkgs.m_importedPkgs.containsKey(pkgName) || resourcePkgs.m_requiredPkgs.containsKey(pkgName))) {
                throw new IllegalArgumentException("Resource " + resource + " cannot dynamically import package '" + pkgName + "' since it already has access to it.");
            }
            this.mergeCandidatePackages(session.getContext(), resource, requirement, cap, resourcePkgMap, allCandidates, new HashMap<Resource, Set<Capability>>(), new HashMap<Resource, Set<Resource>>());
        }
        for (Capability capability : caps) {
            this.calculatePackageSpaces(session, capability.getResource(), allCandidates, resourcePkgMap, usesCycleMap, cycle);
        }
        if (wiring == null || isDynamicImporting) {
            ArrayList<Requirement> blameReqs;
            for (int i = 0; i < reqs.size(); ++i) {
                Requirement requirement = (Requirement)reqs.get(i);
                cap = (Capability)caps.get(i);
                if (requirement.getNamespace().equals("osgi.wiring.bundle") || requirement.getNamespace().equals("osgi.wiring.package")) continue;
                ArrayList<Requirement> blameReqs2 = new ArrayList<Requirement>();
                blameReqs2.add(requirement);
                this.mergeUses(session, resource, resourcePkgs, cap, blameReqs2, cap, resourcePkgMap, allCandidates, usesCycleMap);
            }
            for (Map.Entry<String, List<Blame>> entry : resourcePkgs.m_importedPkgs.entrySet()) {
                for (Blame blame : entry.getValue()) {
                    if (blame.m_cap.getResource().equals(resource)) continue;
                    blameReqs = new ArrayList<Requirement>();
                    blameReqs.add(blame.m_reqs.get(0));
                    this.mergeUses(session, resource, resourcePkgs, blame.m_cap, blameReqs, null, resourcePkgMap, allCandidates, usesCycleMap);
                }
            }
            for (Map.Entry<String, List<Blame>> entry : resourcePkgs.m_requiredPkgs.entrySet()) {
                for (Blame blame : entry.getValue()) {
                    blameReqs = new ArrayList();
                    blameReqs.add(blame.m_reqs.get(0));
                    this.mergeUses(session, resource, resourcePkgs, blame.m_cap, blameReqs, null, resourcePkgMap, allCandidates, usesCycleMap);
                }
            }
        }
    }

    private void mergeCandidatePackages(ResolveContext rc, Resource current, Requirement currentReq, Capability candCap, Map<Resource, Packages> resourcePkgMap, Candidates allCandidates, Map<Resource, Set<Capability>> cycles, HashMap<Resource, Set<Resource>> visitedRequiredBundlesMap) {
        Set<Capability> cycleCaps = cycles.get(current);
        if (cycleCaps == null) {
            cycleCaps = new HashSet<Capability>();
            cycles.put(current, cycleCaps);
        }
        if (!cycleCaps.add(candCap)) {
            return;
        }
        if (candCap.getNamespace().equals("osgi.wiring.package")) {
            this.mergeCandidatePackage(current, false, currentReq, candCap, resourcePkgMap);
        } else if (candCap.getNamespace().equals("osgi.wiring.bundle")) {
            Wiring candWiring;
            ResolverImpl.calculateExportedPackages(rc, candCap.getResource(), allCandidates, resourcePkgMap);
            Packages candPkgs = resourcePkgMap.get(candCap.getResource());
            Set<Resource> visitedRequiredBundles = visitedRequiredBundlesMap.get(current);
            if (visitedRequiredBundles == null) {
                visitedRequiredBundles = new HashSet<Resource>();
                visitedRequiredBundlesMap.put(current, visitedRequiredBundles);
            }
            if (visitedRequiredBundles.add(candCap.getResource())) {
                for (Map.Entry<String, Blame> entry : candPkgs.m_exportedPkgs.entrySet()) {
                    this.mergeCandidatePackage(current, true, currentReq, entry.getValue().m_cap, resourcePkgMap);
                }
            }
            if ((candWiring = rc.getWirings().get(candCap.getResource())) != null) {
                for (Wire w : candWiring.getRequiredResourceWires(null)) {
                    String value;
                    if (!w.getRequirement().getNamespace().equals("osgi.wiring.bundle") || (value = w.getRequirement().getDirectives().get("visibility")) == null || !value.equals("reexport")) continue;
                    this.mergeCandidatePackages(rc, current, currentReq, w.getCapability(), resourcePkgMap, allCandidates, cycles, visitedRequiredBundlesMap);
                }
            } else {
                for (Requirement req : candCap.getResource().getRequirements(null)) {
                    Capability cap;
                    String value;
                    if (!req.getNamespace().equals("osgi.wiring.bundle") || (value = req.getDirectives().get("visibility")) == null || !value.equals("reexport") || (cap = allCandidates.getFirstCandidate(req)) == null) continue;
                    this.mergeCandidatePackages(rc, current, currentReq, cap, resourcePkgMap, allCandidates, cycles, visitedRequiredBundlesMap);
                }
            }
        }
        cycles.remove(current);
    }

    private void mergeCandidatePackage(Resource current, boolean requires, Requirement currentReq, Capability candCap, Map<Resource, Packages> resourcePkgMap) {
        if (candCap.getNamespace().equals("osgi.wiring.package")) {
            String pkgName = (String)candCap.getAttributes().get("osgi.wiring.package");
            ArrayList<Requirement> blameReqs = new ArrayList<Requirement>();
            blameReqs.add(currentReq);
            Packages currentPkgs = resourcePkgMap.get(current);
            Map<String, List<Blame>> packages = requires ? currentPkgs.m_requiredPkgs : currentPkgs.m_importedPkgs;
            List<Blame> blames = packages.get(pkgName);
            if (blames == null) {
                blames = new ArrayList<Blame>();
                packages.put(pkgName, blames);
            }
            blames.add(new Blame(candCap, blameReqs));
        }
    }

    private void mergeUses(ResolveSession session, Resource current, Packages currentPkgs, Capability mergeCap, List<Requirement> blameReqs, Capability matchingCap, Map<Resource, Packages> resourcePkgMap, Candidates allCandidates, Map<Capability, Set<Resource>> cycleMap) {
        if (current.equals(mergeCap.getResource())) {
            return;
        }
        Set<Resource> set = cycleMap.get(mergeCap);
        if (set == null) {
            set = new HashSet<Resource>();
            cycleMap.put(mergeCap, set);
        }
        if (!set.add(current)) {
            return;
        }
        for (Capability candSourceCap : this.getPackageSources(session, mergeCap, resourcePkgMap)) {
            List<Object> uses;
            String s = candSourceCap.getDirectives().get("uses");
            if (s != null) {
                uses = session.getUsesCache().get(s);
                if (uses == null) {
                    uses = ResolverImpl.parseUses(s);
                    session.getUsesCache().put(s, uses);
                }
            } else {
                uses = Collections.emptyList();
            }
            for (String usedPkgName : uses) {
                List<Object> candSourceBlames;
                Packages candSourcePkgs = resourcePkgMap.get(candSourceCap.getResource());
                Blame candExportedBlame = candSourcePkgs.m_exportedPkgs.get(usedPkgName);
                if (candExportedBlame != null) {
                    candSourceBlames = new ArrayList<Blame>(1);
                    candSourceBlames.add(candExportedBlame);
                } else {
                    candSourceBlames = candSourcePkgs.m_requiredPkgs.get(usedPkgName);
                    List<Object> list = candSourceBlames = candSourceBlames != null ? candSourceBlames : candSourcePkgs.m_importedPkgs.get(usedPkgName);
                }
                if (candSourceBlames == null) continue;
                Map<Capability, UsedBlames> usedPkgBlames = currentPkgs.m_usedPkgs.get(usedPkgName);
                if (usedPkgBlames == null) {
                    usedPkgBlames = new LinkedHashMap<Capability, UsedBlames>();
                    currentPkgs.m_usedPkgs.put(usedPkgName, usedPkgBlames);
                }
                for (Blame blame : candSourceBlames) {
                    if (blame.m_reqs != null) {
                        ArrayList<Requirement> blameReqs2 = new ArrayList<Requirement>(blameReqs);
                        blameReqs2.add(blame.m_reqs.get(blame.m_reqs.size() - 1));
                        ResolverImpl.addUsedBlame(usedPkgBlames, blame.m_cap, blameReqs2, matchingCap);
                        this.mergeUses(session, current, currentPkgs, blame.m_cap, blameReqs2, matchingCap, resourcePkgMap, allCandidates, cycleMap);
                        continue;
                    }
                    ResolverImpl.addUsedBlame(usedPkgBlames, blame.m_cap, blameReqs, matchingCap);
                    this.mergeUses(session, current, currentPkgs, blame.m_cap, blameReqs, matchingCap, resourcePkgMap, allCandidates, cycleMap);
                }
            }
        }
    }

    private static List<String> parseUses(String s) {
        int nb = 1;
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            if (s.charAt(i) != ',') continue;
            ++nb;
        }
        ArrayList<String> uses = new ArrayList<String>(nb);
        int start = 0;
        while (true) {
            char c;
            int end;
            char c2;
            if (start < l && ((c2 = s.charAt(start)) == ' ' || c2 == ',')) {
                ++start;
                continue;
            }
            for (end = start + 1; end < l && (c = s.charAt(end)) != ' ' && c != ','; ++end) {
            }
            if (start >= l) break;
            uses.add(s.substring(start, end));
            start = end + 1;
        }
        return uses;
    }

    private static void addUsedBlame(Map<Capability, UsedBlames> usedBlames, Capability usedCap, List<Requirement> blameReqs, Capability matchingCap) {
        Blame newBlame = new Blame(usedCap, blameReqs);
        UsedBlames addToBlame = usedBlames.get(usedCap);
        if (addToBlame == null) {
            addToBlame = new UsedBlames(usedCap);
            usedBlames.put(usedCap, addToBlame);
        }
        addToBlame.addBlame(newBlame, matchingCap);
    }

    private void checkPackageSpaceConsistency(ResolveSession session, Resource resource, Candidates allCandidates, Map<Resource, Packages> resourcePkgMap, Map<Resource, Object> resultCache) throws ResolutionException {
        if (session.getContext().getWirings().containsKey(resource)) {
            return;
        }
        this.checkDynamicPackageSpaceConsistency(session, resource, allCandidates, resourcePkgMap, resultCache);
    }

    /*
     * WARNING - void declaration
     */
    private void checkDynamicPackageSpaceConsistency(ResolveSession session, Resource resource, Candidates allCandidates, Map<Resource, Packages> resourcePkgMap, Map<Resource, Object> resultCache) throws ResolutionException {
        if (resultCache.containsKey(resource)) {
            return;
        }
        Packages pkgs = resourcePkgMap.get(resource);
        ResolutionException rethrow = null;
        Candidates permutation = null;
        Set mutated = null;
        List<Candidates> importPermutations = session.getImportPermutations();
        List<Candidates> usesPermutations = session.getUsesPermutations();
        for (Map.Entry<String, List<Blame>> entry : pkgs.m_importedPkgs.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            Object var14_19 = null;
            for (Iterator<UsedBlames> blame : entry.getValue()) {
                void var14_18;
                if (var14_18 == null) {
                    Blame blame2 = blame;
                    continue;
                }
                if (var14_18.m_cap.getResource().equals(((Blame)((Object)blame)).m_cap.getResource())) continue;
                allCandidates.permutate(((Blame)((Object)blame)).m_reqs.get(0), importPermutations);
                allCandidates.permutate(var14_18.m_reqs.get(0), importPermutations);
                ResolutionException ex = new ResolutionException("Uses constraint violation. Unable to resolve resource " + Util.getSymbolicName(resource) + " [" + resource + "] because it is exposed to package '" + entry.getKey() + "' from resources " + Util.getSymbolicName(var14_18.m_cap.getResource()) + " [" + var14_18.m_cap.getResource() + "] and " + Util.getSymbolicName(((Blame)((Object)blame)).m_cap.getResource()) + " [" + ((Blame)((Object)blame)).m_cap.getResource() + "] via two dependency chains.\n\nChain 1:\n" + ResolverImpl.toStringBlame(session.getContext(), allCandidates, (Blame)var14_18) + "\n\nChain 2:\n" + ResolverImpl.toStringBlame(session.getContext(), allCandidates, blame), null, Collections.singleton(((Blame)((Object)blame)).m_reqs.get(0)));
                this.m_logger.log(4, "Candidate permutation failed due to a conflict with a fragment import; will try another if possible.", ex);
                throw ex;
            }
        }
        for (Map.Entry<String, Object> entry : pkgs.m_exportedPkgs.entrySet()) {
            String string = entry.getKey();
            Blame exportBlame = (Blame)entry.getValue();
            if (!pkgs.m_usedPkgs.containsKey(string)) continue;
            for (UsedBlames usedBlames : pkgs.m_usedPkgs.get(string).values()) {
                if (this.isCompatible(session, Collections.singletonList(exportBlame), usedBlames.m_cap, resourcePkgMap)) continue;
                block6: for (Blame blame : usedBlames.m_blames) {
                    if (this.checkMultiple(session, usedBlames, blame, allCandidates)) continue;
                    permutation = permutation != null ? permutation : allCandidates.copy();
                    rethrow = rethrow != null ? rethrow : new ResolutionException("Uses constraint violation. Unable to resolve resource " + Util.getSymbolicName(resource) + " [" + resource + "] because it exports package '" + string + "' and is also exposed to it from resource " + Util.getSymbolicName(blame.m_cap.getResource()) + " [" + blame.m_cap.getResource() + "] via the following dependency chain:\n\n" + ResolverImpl.toStringBlame(session.getContext(), allCandidates, blame), null, null);
                    mutated = mutated != null ? mutated : new HashSet();
                    for (int reqIdx = blame.m_reqs.size() - 1; reqIdx >= 0; --reqIdx) {
                        Requirement req = blame.m_reqs.get(reqIdx);
                        if (Util.isMultiple(req)) continue;
                        if (mutated.contains(req)) continue block6;
                        if (!permutation.canRemoveCandidate(req)) continue;
                        permutation.removeFirstCandidate(req);
                        mutated.add(req);
                        continue block6;
                    }
                }
            }
            if (rethrow == null) continue;
            if (!mutated.isEmpty()) {
                usesPermutations.add(permutation);
            }
            this.m_logger.log(4, "Candidate permutation failed due to a conflict between an export and import; will try another if possible.", rethrow);
            throw rethrow;
        }
        LinkedHashMap<String, List<Blame>> allImportRequirePkgs = new LinkedHashMap<String, List<Blame>>(pkgs.m_requiredPkgs.size() + pkgs.m_importedPkgs.size());
        allImportRequirePkgs.putAll(pkgs.m_requiredPkgs);
        allImportRequirePkgs.putAll(pkgs.m_importedPkgs);
        for (Map.Entry entry : allImportRequirePkgs.entrySet()) {
            String pkgName = (String)entry.getKey();
            if (!pkgs.m_usedPkgs.containsKey(pkgName)) continue;
            for (UsedBlames usedBlames : pkgs.m_usedPkgs.get(pkgName).values()) {
                if (!this.isCompatible(session, (List)entry.getValue(), usedBlames.m_cap, resourcePkgMap)) {
                    Blame requirementBlame = (Blame)((List)entry.getValue()).get(0);
                    block10: for (Blame usedBlame : usedBlames.m_blames) {
                        if (this.checkMultiple(session, usedBlames, usedBlame, allCandidates)) continue;
                        permutation = permutation != null ? permutation : allCandidates.copy();
                        rethrow = rethrow != null ? rethrow : new ResolutionException("Uses constraint violation. Unable to resolve resource " + Util.getSymbolicName(resource) + " [" + resource + "] because it is exposed to package '" + pkgName + "' from resources " + Util.getSymbolicName(requirementBlame.m_cap.getResource()) + " [" + requirementBlame.m_cap.getResource() + "] and " + Util.getSymbolicName(usedBlame.m_cap.getResource()) + " [" + usedBlame.m_cap.getResource() + "] via two dependency chains.\n\nChain 1:\n" + ResolverImpl.toStringBlame(session.getContext(), allCandidates, requirementBlame) + "\n\nChain 2:\n" + ResolverImpl.toStringBlame(session.getContext(), allCandidates, usedBlame), null, null);
                        mutated = mutated != null ? mutated : new HashSet();
                        for (int reqIdx = usedBlame.m_reqs.size() - 1; reqIdx >= 0; --reqIdx) {
                            Requirement req = usedBlame.m_reqs.get(reqIdx);
                            if (Util.isMultiple(req)) continue;
                            if (mutated.contains(req)) continue block10;
                            if (!permutation.canRemoveCandidate(req)) continue;
                            permutation.removeFirstCandidate(req);
                            mutated.add(req);
                            continue block10;
                        }
                    }
                }
                if (rethrow == null) continue;
                if (!mutated.isEmpty()) {
                    usesPermutations.add(permutation);
                }
                for (Blame blame : (List)entry.getValue()) {
                    Requirement req = blame.m_reqs.get(0);
                    if (mutated.contains(req)) continue;
                    allCandidates.permutateIfNeeded(req, importPermutations);
                }
                this.m_logger.log(4, "Candidate permutation failed due to a conflict between imports; will try another if possible.", rethrow);
                throw rethrow;
            }
        }
        resultCache.put(resource, Boolean.TRUE);
        int n = usesPermutations.size() + importPermutations.size();
        for (Requirement req : resource.getRequirements(null)) {
            Capability cap = allCandidates.getFirstCandidate(req);
            if (cap == null || resource.equals(cap.getResource())) continue;
            try {
                this.checkPackageSpaceConsistency(session, cap.getResource(), allCandidates, resourcePkgMap, resultCache);
            }
            catch (ResolutionException ex) {
                if (n == usesPermutations.size() + importPermutations.size()) {
                    allCandidates.permutate(req, importPermutations);
                }
                throw ex;
            }
        }
    }

    private boolean checkMultiple(ResolveSession session, UsedBlames usedBlames, Blame usedBlame, Candidates permutation) {
        List<Capability> candidates = null;
        Requirement req = usedBlame.m_reqs.get(0);
        if (Util.isMultiple(req)) {
            if (session.getMultipleCardCandidates() == null) {
                session.setMultipleCardCandidates(permutation.copy());
            }
            candidates = session.getMultipleCardCandidates().clearCandidates(req, usedBlames.getRootCauses(req));
        }
        return candidates != null && !candidates.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private static void calculateExportedPackages(ResolveContext rc, Resource resource, Candidates allCandidates, Map<Resource, Packages> resourcePkgMap) {
        Packages packages = resourcePkgMap.get(resource);
        if (packages != null) {
            return;
        }
        packages = new Packages(resource);
        Wiring wiring = rc.getWirings().get(resource);
        List<Capability> caps = wiring != null ? wiring.getResourceCapabilities(null) : resource.getCapabilities(null);
        HashMap<String, void> exports = new HashMap<String, void>(caps.size());
        for (Capability capability : caps) {
            void var9_9;
            if (!capability.getNamespace().equals("osgi.wiring.package")) continue;
            if (!capability.getResource().equals(resource)) {
                WrappedCapability wrappedCapability = new WrappedCapability(resource, capability);
            }
            exports.put((String)var9_9.getAttributes().get("osgi.wiring.package"), var9_9);
        }
        if (!exports.isEmpty()) {
            if (wiring == null) {
                for (Requirement requirement : resource.getRequirements(null)) {
                    Capability cand;
                    if (!requirement.getNamespace().equals("osgi.wiring.package") || (cand = allCandidates.getFirstCandidate(requirement)) == null) continue;
                    String pkgName = (String)cand.getAttributes().get("osgi.wiring.package");
                    exports.remove(pkgName);
                }
            }
            for (Map.Entry entry : exports.entrySet()) {
                packages.m_exportedPkgs.put((String)entry.getKey(), new Blame((Capability)entry.getValue(), null));
            }
        }
        resourcePkgMap.put(resource, packages);
    }

    private boolean isCompatible(ResolveSession session, List<Blame> currentBlames, Capability candCap, Map<Resource, Packages> resourcePkgMap) {
        if (!currentBlames.isEmpty() && candCap != null) {
            Set<Object> currentSources;
            if (currentBlames.size() == 1) {
                Capability currentCap = currentBlames.get((int)0).m_cap;
                if (currentCap.equals(candCap)) {
                    return true;
                }
                currentSources = this.getPackageSources(session, currentCap, resourcePkgMap);
            } else {
                currentSources = new HashSet(currentBlames.size());
                for (Blame currentBlame : currentBlames) {
                    Set<Capability> blameSources = this.getPackageSources(session, currentBlame.m_cap, resourcePkgMap);
                    for (Capability blameSource : blameSources) {
                        currentSources.add(blameSource);
                    }
                }
            }
            Set<Capability> candSources = this.getPackageSources(session, candCap, resourcePkgMap);
            return currentSources.containsAll(candSources) || candSources.containsAll(currentSources);
        }
        return true;
    }

    private Set<Capability> getPackageSources(ResolveSession session, Capability cap, Map<Resource, Packages> resourcePkgMap) {
        Map<Capability, Set<Capability>> packageSourcesCache = session.getPackageSourcesCache();
        if (cap.getNamespace().equals("osgi.wiring.package")) {
            Set<Capability> sources = packageSourcesCache.get(cap);
            if (sources == null) {
                sources = ResolverImpl.getPackageSourcesInternal(session.getContext(), cap, resourcePkgMap, new HashSet<Capability>(64), new HashSet<Capability>(64));
                packageSourcesCache.put(cap, sources);
            }
            return sources;
        }
        String uses = cap.getDirectives().get("uses");
        if (uses != null && uses.length() > 0) {
            return Collections.singleton(cap);
        }
        return Collections.emptySet();
    }

    private static Set<Capability> getPackageSourcesInternal(ResolveContext rc, Capability cap, Map<Resource, Packages> resourcePkgMap, Set<Capability> sources, Set<Capability> cycleMap) {
        if (cap.getNamespace().equals("osgi.wiring.package")) {
            if (!cycleMap.add(cap)) {
                return sources;
            }
            String pkgName = cap.getAttributes().get("osgi.wiring.package").toString();
            Wiring wiring = rc.getWirings().get(cap.getResource());
            List<Capability> caps = wiring != null ? wiring.getResourceCapabilities(null) : cap.getResource().getCapabilities(null);
            for (Capability sourceCap : caps) {
                if (!sourceCap.getNamespace().equals("osgi.wiring.package") || !sourceCap.getAttributes().get("osgi.wiring.package").equals(pkgName)) continue;
                if (!cap.getResource().equals(sourceCap.getResource())) {
                    sourceCap = new WrappedCapability(cap.getResource(), sourceCap);
                }
                sources.add(sourceCap);
            }
            Packages pkgs = resourcePkgMap.get(cap.getResource());
            List<Blame> required = pkgs.m_requiredPkgs.get(pkgName);
            if (required != null) {
                for (Blame blame : required) {
                    ResolverImpl.getPackageSourcesInternal(rc, blame.m_cap, resourcePkgMap, sources, cycleMap);
                }
            }
        }
        return sources;
    }

    private static Resource getDeclaredResource(Resource resource) {
        if (resource instanceof WrappedResource) {
            return ((WrappedResource)resource).getDeclaredResource();
        }
        return resource;
    }

    private static Capability getDeclaredCapability(Capability c) {
        if (c instanceof HostedCapability) {
            return ((HostedCapability)c).getDeclaredCapability();
        }
        return c;
    }

    private static Requirement getDeclaredRequirement(Requirement r) {
        if (r instanceof WrappedRequirement) {
            return ((WrappedRequirement)r).getDeclaredRequirement();
        }
        return r;
    }

    private static Map<Resource, List<Wire>> populateWireMap(ResolveContext rc, Resource resource, Map<Resource, Packages> resourcePkgMap, Map<Resource, List<Wire>> wireMap, Candidates allCandidates) {
        Resource unwrappedResource = ResolverImpl.getDeclaredResource(resource);
        if (!rc.getWirings().containsKey(unwrappedResource) && !wireMap.containsKey(unwrappedResource)) {
            wireMap.put(unwrappedResource, Collections.emptyList());
            ArrayList<WireImpl> packageWires = new ArrayList<WireImpl>();
            ArrayList<WireImpl> bundleWires = new ArrayList<WireImpl>();
            ArrayList<WireImpl> capabilityWires = new ArrayList<WireImpl>();
            block0: for (Requirement req : resource.getRequirements(null)) {
                List<Capability> cands = allCandidates.getCandidates(req);
                if (cands == null || cands.size() <= 0) continue;
                for (Capability cand : cands) {
                    if (!cand.getNamespace().startsWith("osgi.wiring.") || !resource.equals(cand.getResource())) {
                        if (!rc.getWirings().containsKey(cand.getResource())) {
                            Resource targetCand = cand.getResource();
                            if ("osgi.identity".equals(cand.getNamespace()) && Util.isFragment(targetCand)) {
                                targetCand = allCandidates.getFirstCandidate(targetCand.getRequirements("osgi.wiring.host").get(0)).getResource();
                                targetCand = allCandidates.getWrappedHost(targetCand);
                            }
                            ResolverImpl.populateWireMap(rc, targetCand, resourcePkgMap, wireMap, allCandidates);
                        }
                        WireImpl wire = new WireImpl(unwrappedResource, ResolverImpl.getDeclaredRequirement(req), ResolverImpl.getDeclaredResource(cand.getResource()), ResolverImpl.getDeclaredCapability(cand));
                        if (req.getNamespace().equals("osgi.wiring.package")) {
                            packageWires.add(wire);
                        } else if (req.getNamespace().equals("osgi.wiring.bundle")) {
                            bundleWires.add(wire);
                        } else {
                            capabilityWires.add(wire);
                        }
                    }
                    if (Util.isMultiple(req)) continue;
                    continue block0;
                }
            }
            packageWires.addAll(bundleWires);
            packageWires.addAll(capabilityWires);
            wireMap.put(unwrappedResource, packageWires);
            if (resource instanceof WrappedResource) {
                List<Resource> fragments = ((WrappedResource)resource).getFragments();
                for (Resource fragment : fragments) {
                    ArrayList<Wire> fragmentWires = wireMap.get(fragment);
                    fragmentWires = fragmentWires == null ? new ArrayList<Wire>() : fragmentWires;
                    for (Requirement req : fragment.getRequirements(null)) {
                        Wire wire;
                        if (ResolverImpl.isPayload(req)) continue;
                        if (req.getNamespace().equals("osgi.wiring.host")) {
                            fragmentWires.add(new WireImpl(ResolverImpl.getDeclaredResource(fragment), req, unwrappedResource, unwrappedResource.getCapabilities("osgi.wiring.host").get(0)));
                            continue;
                        }
                        if (rc.getWirings().containsKey(fragment) || wireMap.containsKey(fragment) || (wire = ResolverImpl.createWire(req, allCandidates)) == null) continue;
                        fragmentWires.add(wire);
                    }
                    wireMap.put(fragment, fragmentWires);
                }
            }
        }
        return wireMap;
    }

    private static Wire createWire(Requirement requirement, Candidates allCandidates) {
        Capability cand = allCandidates.getFirstCandidate(requirement);
        if (cand == null) {
            return null;
        }
        return new WireImpl(ResolverImpl.getDeclaredResource(requirement.getResource()), ResolverImpl.getDeclaredRequirement(requirement), ResolverImpl.getDeclaredResource(cand.getResource()), ResolverImpl.getDeclaredCapability(cand));
    }

    private static boolean isPayload(Requirement fragmentReq) {
        if ("osgi.ee".equals(fragmentReq.getNamespace())) {
            return false;
        }
        return !"osgi.wiring.host".equals(fragmentReq.getNamespace());
    }

    private static Map<Resource, List<Wire>> populateDynamicWireMap(ResolveContext rc, Resource resource, Requirement dynReq, Map<Resource, Packages> resourcePkgMap, Map<Resource, List<Wire>> wireMap, Candidates allCandidates) {
        wireMap.put(resource, Collections.emptyList());
        ArrayList<WireImpl> packageWires = new ArrayList<WireImpl>();
        Capability dynCand = allCandidates.getFirstCandidate(dynReq);
        if (!rc.getWirings().containsKey(dynCand.getResource())) {
            ResolverImpl.populateWireMap(rc, dynCand.getResource(), resourcePkgMap, wireMap, allCandidates);
        }
        packageWires.add(new WireImpl(resource, dynReq, ResolverImpl.getDeclaredResource(dynCand.getResource()), ResolverImpl.getDeclaredCapability(dynCand)));
        wireMap.put(resource, packageWires);
        return wireMap;
    }

    private static void dumpResourcePkgMap(ResolveContext rc, Map<Resource, Packages> resourcePkgMap) {
        System.out.println("+++RESOURCE PKG MAP+++");
        for (Map.Entry<Resource, Packages> entry : resourcePkgMap.entrySet()) {
            ResolverImpl.dumpResourcePkgs(rc, entry.getKey(), entry.getValue());
        }
    }

    private static void dumpResourcePkgs(ResolveContext rc, Resource resource, Packages packages) {
        Wiring wiring = rc.getWirings().get(resource);
        System.out.println(resource + " (" + (wiring != null ? "RESOLVED)" : "UNRESOLVED)"));
        System.out.println("  EXPORTED");
        for (Map.Entry<String, Blame> entry : packages.m_exportedPkgs.entrySet()) {
            System.out.println("    " + entry.getKey() + " - " + entry.getValue());
        }
        System.out.println("  IMPORTED");
        for (Map.Entry<String, Object> entry : packages.m_importedPkgs.entrySet()) {
            System.out.println("    " + entry.getKey() + " - " + entry.getValue());
        }
        System.out.println("  REQUIRED");
        for (Map.Entry<String, Object> entry : packages.m_requiredPkgs.entrySet()) {
            System.out.println("    " + entry.getKey() + " - " + entry.getValue());
        }
        System.out.println("  USED");
        for (Map.Entry<String, Object> entry : packages.m_usedPkgs.entrySet()) {
            System.out.println("    " + entry.getKey() + " - " + ((Map)entry.getValue()).values());
        }
    }

    private static String toStringBlame(ResolveContext rc, Candidates allCandidates, Blame blame) {
        StringBuilder sb = new StringBuilder();
        if (blame.m_reqs != null && !blame.m_reqs.isEmpty()) {
            for (int i = 0; i < blame.m_reqs.size(); ++i) {
                Requirement req = blame.m_reqs.get(i);
                sb.append("  ");
                sb.append(Util.getSymbolicName(req.getResource()));
                sb.append(" [");
                sb.append(req.getResource().toString());
                sb.append("]\n");
                if (req.getNamespace().equals("osgi.wiring.package")) {
                    sb.append("    import: ");
                } else {
                    sb.append("    require: ");
                }
                sb.append(req.getDirectives().get("filter"));
                sb.append("\n     |");
                if (req.getNamespace().equals("osgi.wiring.package")) {
                    sb.append("\n    export: ");
                } else {
                    sb.append("\n    provide: ");
                }
                if (i + 1 < blame.m_reqs.size()) {
                    Capability cap = ResolverImpl.getSatisfyingCapability(rc, allCandidates, blame.m_reqs.get(i));
                    if (cap.getNamespace().equals("osgi.wiring.package")) {
                        sb.append("osgi.wiring.package");
                        sb.append("=");
                        sb.append(cap.getAttributes().get("osgi.wiring.package").toString());
                        Capability usedCap = ResolverImpl.getSatisfyingCapability(rc, allCandidates, blame.m_reqs.get(i + 1));
                        sb.append("; uses:=");
                        sb.append(usedCap.getAttributes().get("osgi.wiring.package"));
                    } else {
                        sb.append(cap);
                    }
                    sb.append("\n");
                    continue;
                }
                Capability export = ResolverImpl.getSatisfyingCapability(rc, allCandidates, blame.m_reqs.get(i));
                sb.append(export.getNamespace());
                sb.append(": ");
                Object namespaceVal = export.getAttributes().get(export.getNamespace());
                if (namespaceVal != null) {
                    sb.append(namespaceVal.toString());
                } else {
                    for (Map.Entry<String, Object> attrEntry : export.getAttributes().entrySet()) {
                        sb.append(attrEntry.getKey()).append('=').append(attrEntry.getValue()).append(';');
                    }
                }
                if (export.getNamespace().equals("osgi.wiring.package") && !export.getAttributes().get("osgi.wiring.package").equals(blame.m_cap.getAttributes().get("osgi.wiring.package"))) {
                    sb.append("; uses:=");
                    sb.append(blame.m_cap.getAttributes().get("osgi.wiring.package"));
                    sb.append("\n    export: ");
                    sb.append("osgi.wiring.package");
                    sb.append("=");
                    sb.append(blame.m_cap.getAttributes().get("osgi.wiring.package").toString());
                }
                sb.append("\n  ");
                sb.append(Util.getSymbolicName(blame.m_cap.getResource()));
                sb.append(" [");
                sb.append(blame.m_cap.getResource().toString());
                sb.append("]");
            }
        } else {
            sb.append(blame.m_cap.getResource().toString());
        }
        return sb.toString();
    }

    private static Capability getSatisfyingCapability(ResolveContext rc, Candidates allCandidates, Requirement req) {
        Capability cap = allCandidates.getFirstCandidate(req);
        if (cap == null && rc.getWirings().containsKey(req.getResource())) {
            List<Wire> wires = rc.getWirings().get(req.getResource()).getRequiredResourceWires(null);
            req = ResolverImpl.getDeclaredRequirement(req);
            for (Wire w : wires) {
                if (!w.getRequirement().equals(req)) continue;
                cap = w.getCapability();
                break;
            }
        }
        return cap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UsedBlames {
        public final Capability m_cap;
        public final List<Blame> m_blames = new ArrayList<Blame>();
        private Map<Requirement, Set<Capability>> m_rootCauses;

        public UsedBlames(Capability cap) {
            this.m_cap = cap;
        }

        public void addBlame(Blame blame, Capability matchingRootCause) {
            Requirement req;
            if (!this.m_cap.equals(blame.m_cap)) {
                throw new IllegalArgumentException("Attempt to add a blame with a different used capability: " + blame.m_cap);
            }
            this.m_blames.add(blame);
            if (matchingRootCause != null && Util.isMultiple(req = blame.m_reqs.get(0))) {
                Set<Capability> rootCauses;
                if (this.m_rootCauses == null) {
                    this.m_rootCauses = new HashMap<Requirement, Set<Capability>>();
                }
                if ((rootCauses = this.m_rootCauses.get(req)) == null) {
                    rootCauses = new HashSet<Capability>();
                    this.m_rootCauses.put(req, rootCauses);
                }
                rootCauses.add(matchingRootCause);
            }
        }

        public Set<Capability> getRootCauses(Requirement req) {
            if (this.m_rootCauses == null) {
                return Collections.emptySet();
            }
            Set<Capability> result = this.m_rootCauses.get(req);
            return result == null ? Collections.emptySet() : result;
        }

        public String toString() {
            return this.m_blames.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Blame {
        public final Capability m_cap;
        public final List<Requirement> m_reqs;

        public Blame(Capability cap, List<Requirement> reqs) {
            this.m_cap = cap;
            this.m_reqs = reqs;
        }

        public String toString() {
            return this.m_cap.getResource() + "." + this.m_cap.getAttributes().get("osgi.wiring.package") + (this.m_reqs == null || this.m_reqs.isEmpty() ? " NO BLAME" : " BLAMED ON " + this.m_reqs);
        }

        public boolean equals(Object o) {
            return o instanceof Blame && this.m_reqs.equals(((Blame)o).m_reqs) && this.m_cap.equals(((Blame)o).m_cap);
        }
    }

    private static class Packages {
        private final Resource m_resource;
        public final Map<String, Blame> m_exportedPkgs = new LinkedHashMap<String, Blame>(32);
        public final Map<String, List<Blame>> m_importedPkgs = new LinkedHashMap<String, List<Blame>>(32);
        public final Map<String, List<Blame>> m_requiredPkgs = new LinkedHashMap<String, List<Blame>>(32);
        public final Map<String, Map<Capability, UsedBlames>> m_usedPkgs = new LinkedHashMap<String, Map<Capability, UsedBlames>>(32);
        public boolean m_isCalculated = false;

        public Packages(Resource resource) {
            this.m_resource = resource;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ResolveSession {
        private final ResolveContext m_resolveContext;
        private final List<Candidates> m_usesPermutations = new ArrayList<Candidates>();
        private final List<Candidates> m_importPermutations = new ArrayList<Candidates>();
        private Candidates m_multipleCardCandidates = null;
        private final Map<Capability, Set<Capability>> m_packageSourcesCache = new HashMap<Capability, Set<Capability>>(256);
        private final Map<String, List<String>> m_usesCache = new HashMap<String, List<String>>();

        ResolveSession(ResolveContext resolveContext) {
            this.m_resolveContext = resolveContext;
        }

        List<Candidates> getUsesPermutations() {
            return this.m_usesPermutations;
        }

        List<Candidates> getImportPermutations() {
            return this.m_importPermutations;
        }

        Candidates getMultipleCardCandidates() {
            return this.m_multipleCardCandidates;
        }

        void setMultipleCardCandidates(Candidates multipleCardCandidates) {
            this.m_multipleCardCandidates = multipleCardCandidates;
        }

        Map<Capability, Set<Capability>> getPackageSourcesCache() {
            return this.m_packageSourcesCache;
        }

        ResolveContext getContext() {
            return this.m_resolveContext;
        }

        public Map<String, List<String>> getUsesCache() {
            return this.m_usesCache;
        }
    }
}

